/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.opensoundcontrol;

import com.bitwig.extension.api.opensoundcontrol.OscInvalidArgumentTypeException;
import com.bitwig.extension.api.opensoundcontrol.OscPacketSizeExceededException;
import com.bitwig.flt.control_surface.opensoundcontrol.nCp;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Stack;

class AQp {
    private final byte[] BOK = new byte[65536];
    private final ByteBuffer HaN = ByteBuffer.wrap(this.BOK);
    private int rLM = 0;
    private final Stack bsM = new Stack();

    AQp() {
        this.HaN.order(ByteOrder.BIG_ENDIAN);
    }

    void w2Z() {
        this.HaN.position(0);
        this.rLM = 0;
        this.bsM.clear();
    }

    void BOK() {
        try {
            if (this.rLM > 0) {
                this.bsM.add(this.HaN.position());
                this.w2Z(0);
            }
            this.w2Z("#bundle");
            this.w2Z(42L);
            ++this.rLM;
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new OscPacketSizeExceededException();
        }
    }

    void HaN() {
        try {
            if (this.rLM == 0) {
                throw new IllegalStateException("Call to endBundle() without a call to startBundle() first.");
            }
            --this.rLM;
            if (this.rLM > 0) {
                int n2 = this.HaN.position();
                int n3 = (Integer)this.bsM.pop();
                this.HaN.putInt(n3, n2 - n3 - 4);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new OscPacketSizeExceededException();
        }
    }

    void w2Z(String string, Object ... objectArray) {
        try {
            int n2 = this.HaN.position();
            if (this.rLM > 0) {
                this.HaN.putInt(0);
            }
            this.w2Z(string);
            String string2 = nCp.w2Z(objectArray);
            this.w2Z(string2);
            if (objectArray == null) {
                return;
            }
            for (Object object : objectArray) {
                if (object == null || object instanceof Boolean) continue;
                if (object instanceof Integer) {
                    this.w2Z((Integer)object);
                    continue;
                }
                if (object instanceof Long) {
                    this.BOK((Long)object);
                    continue;
                }
                if (object instanceof Float) {
                    this.w2Z(((Float)object).floatValue());
                    continue;
                }
                if (object instanceof Double) {
                    this.w2Z((Double)object);
                    continue;
                }
                if (object instanceof String) {
                    this.w2Z((String)object);
                    continue;
                }
                if (object instanceof byte[]) {
                    this.BOK((byte[])object);
                    continue;
                }
                throw new OscInvalidArgumentTypeException(object);
            }
            if (this.rLM > 0) {
                this.HaN.putInt(n2, this.HaN.position() - n2 - 4);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new OscPacketSizeExceededException();
        }
    }

    int rLM() {
        return this.rLM;
    }

    private void w2Z(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        if (byArray.length % 4 == 0) {
            this.HaN.put(byArray);
            this.HaN.putInt(0);
        } else {
            this.w2Z(byArray);
        }
    }

    private void w2Z(byte[] byArray) {
        this.HaN.put(byArray);
        int n2 = byArray.length > 0 ? (4 - byArray.length % 4) % 4 : 4;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.HaN.put((byte)0);
        }
    }

    private void w2Z(long l2) {
        this.BOK(l2);
    }

    private void w2Z(int n2) {
        assert (bTm.w2Z(this.HaN.order() == ByteOrder.BIG_ENDIAN));
        this.HaN.putInt(n2);
    }

    private void BOK(long l2) {
        assert (bTm.w2Z(this.HaN.order() == ByteOrder.BIG_ENDIAN));
        this.HaN.putLong(l2);
    }

    private void w2Z(float f2) {
        this.HaN.putFloat(f2);
    }

    private void w2Z(double d2) {
        this.HaN.putDouble(d2);
    }

    private void BOK(byte[] byArray) {
        this.HaN.putInt(byArray.length);
        this.w2Z(byArray);
    }

    byte[] bsM() {
        return this.BOK;
    }

    int KyJ() {
        return this.HaN.position();
    }
}

