/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.opensoundcontrol;

import com.bitwig.extension.api.opensoundcontrol.OscConnection;
import com.bitwig.extension.api.opensoundcontrol.OscPacket;
import com.bitwig.flt.control_surface.opensoundcontrol.AQp;
import com.bitwig.flt.control_surface.opensoundcontrol.aOa;
import com.bitwig.flt.control_surface.opensoundcontrol.pdu;
import com.bitwig.flt.control_surface.opensoundcontrol.rKC;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;

public class QTJ
extends ControlSurfaceObject
implements OscConnection {
    private final int BOK = 65536;
    private boolean HaN = false;
    private final Thread rLM;
    private final DatagramSocket bsM;
    private final AQp KyJ = new AQp();
    private final rKC UN3 = new rKC();
    private final pdu JEB;
    private final byte[] zxv = new byte[65536];
    private final aOa Bh1;

    private static DatagramSocket w2Z(String string, int n2) {
        InetAddress inetAddress = InetAddress.getByName(string);
        DatagramSocket datagramSocket = new DatagramSocket();
        datagramSocket.connect(inetAddress, n2);
        return datagramSocket;
    }

    public QTJ(ControlSurfaceObject controlSurfaceObject, String string, int n2, pdu pdu2, aOa aOa2) {
        this(controlSurfaceObject, QTJ.w2Z(string, n2), pdu2, aOa2);
    }

    QTJ(ControlSurfaceObject controlSurfaceObject, DatagramSocket datagramSocket, pdu pdu2, aOa aOa2) {
        super(controlSurfaceObject);
        assert (this.w2Z(datagramSocket != null));
        assert (this.w2Z(datagramSocket.isConnected()));
        this.JEB = pdu2;
        this.bsM = datagramSocket;
        this.rLM = new Thread(this::BOK);
        this.rLM.setName("OscUdpConnection::readLoop()");
        this.rLM.start();
        this.Bh1 = aOa2;
    }

    private void BOK() {
        DatagramPacket datagramPacket = new DatagramPacket(this.zxv, 65536);
        while (!this.HaN && !this.bsM.isClosed()) {
            try {
                this.bsM.receive(datagramPacket);
                OscPacket oscPacket = this.UN3.w2Z(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                if (oscPacket == null) continue;
                i1t i1t2 = this.Bh1.getHost().getControlSurface();
                i1t2.bsM(() -> {
                    try {
                        this.JEB.w2Z((OscConnection)this, oscPacket);
                    }
                    catch (Throwable throwable) {
                        i1t2.w2Z(throwable);
                    }
                });
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void startBundle() {
        assert (this.w2Z(this.isControlSurfaceThread()));
        this.KyJ.BOK();
    }

    @Override
    public void sendMessage(String string, Object ... objectArray) {
        assert (this.w2Z(this.isControlSurfaceThread()));
        this.notEmpty(string, "address");
        this.KyJ.w2Z(string, objectArray);
        if (this.KyJ.rLM() == 0) {
            this.HaN();
        }
    }

    @Override
    public void endBundle() {
        assert (this.w2Z(this.isControlSurfaceThread()));
        this.KyJ.HaN();
        if (this.KyJ.rLM() == 0) {
            this.HaN();
        }
    }

    private void HaN() {
        try {
            this.bsM.send(new DatagramPacket(this.KyJ.bsM(), this.KyJ.KyJ()));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            this.KyJ.w2Z();
        }
    }

    public void w2Z() {
        this.HaN = true;
        byte[] byArray = new byte[]{0};
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.bsM.getLocalSocketAddress());
        try {
            this.bsM.send(datagramPacket);
        }
        catch (IOException iOException) {
            bTm.bsM.BOK(iOException);
        }
        this.rLM.interrupt();
        this.bsM.close();
        try {
            this.rLM.join();
        }
        catch (InterruptedException interruptedException) {
            bTm.bsM.BOK(interruptedException);
        }
    }
}

