/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.opensoundcontrol;

import com.bitwig.extension.api.opensoundcontrol.OscBundle;
import com.bitwig.extension.api.opensoundcontrol.OscPacket;
import com.bitwig.flt.control_surface.opensoundcontrol.SoS;
import com.bitwig.flt.control_surface.opensoundcontrol.cw;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

class rKC {
    private ByteBuffer BOK = null;
    private byte[] HaN = null;

    rKC() {
    }

    OscPacket w2Z(byte[] byArray, int n2, int n3) {
        try {
            this.HaN = byArray;
            this.BOK = ByteBuffer.wrap(byArray, n2, n3);
            this.BOK.order(ByteOrder.BIG_ENDIAN);
            return this.w2Z(null);
        }
        catch (IllegalArgumentException | BufferUnderflowException runtimeException) {
            return null;
        }
    }

    private OscPacket w2Z(OscBundle oscBundle) {
        String string = this.w2Z();
        if (string.equals("#bundle")) {
            return this.BOK(oscBundle);
        }
        return this.w2Z(oscBundle, string);
    }

    private String w2Z() {
        byte by2;
        int n2 = this.BOK.position();
        assert (bTm.w2Z(n2 % 4 == 0));
        while ((by2 = this.BOK.get()) != 0) {
        }
        String string = new String(this.HaN, n2, this.BOK.position() - n2 - 1);
        this.UN3();
        return string;
    }

    private int BOK() {
        assert (bTm.w2Z(this.BOK.order() == ByteOrder.BIG_ENDIAN));
        return this.BOK.getInt();
    }

    private long HaN() {
        assert (bTm.w2Z(this.BOK.order() == ByteOrder.BIG_ENDIAN));
        return this.BOK.getLong();
    }

    private float rLM() {
        return this.BOK.getFloat();
    }

    private double bsM() {
        return this.BOK.getDouble();
    }

    private byte[] KyJ() {
        int n2 = this.BOK();
        if (n2 < 0) {
            throw new IOException("Invalid blob size: " + n2);
        }
        byte[] byArray = new byte[n2];
        this.BOK.get(byArray);
        this.UN3();
        return byArray;
    }

    private void UN3() {
        int n2 = this.BOK.position() % 4;
        if (n2 != 0) {
            int n3 = this.BOK.position() + 4 - n2;
            this.BOK.position(n3);
        }
        assert (bTm.w2Z(this.BOK.position() % 4 == 0));
    }

    private cw w2Z(OscBundle oscBundle, String string) {
        String string2 = this.w2Z();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!string2.isEmpty() && string2.charAt(0) == ',') {
            block11: for (int i2 = 1; i2 < string2.length(); ++i2) {
                char c2 = string2.charAt(i2);
                switch (c2) {
                    case 'F': {
                        arrayList.add(false);
                        continue block11;
                    }
                    case 'T': {
                        arrayList.add(true);
                        continue block11;
                    }
                    case 'N': {
                        arrayList.add(null);
                        continue block11;
                    }
                    case 'i': {
                        arrayList.add(this.BOK());
                        continue block11;
                    }
                    case 'h': {
                        arrayList.add(this.HaN());
                        continue block11;
                    }
                    case 'f': {
                        arrayList.add(Float.valueOf(this.rLM()));
                        continue block11;
                    }
                    case 'd': {
                        arrayList.add(this.bsM());
                        continue block11;
                    }
                    case 'b': {
                        arrayList.add(this.KyJ());
                        continue block11;
                    }
                    case 's': {
                        arrayList.add(this.w2Z());
                        continue block11;
                    }
                    default: {
                        i2 = string2.length();
                    }
                }
            }
        }
        return new cw(oscBundle, string, string2, arrayList);
    }

    private SoS BOK(OscBundle oscBundle) {
        long l2 = this.HaN();
        SoS soS = new SoS(oscBundle, l2);
        while (this.BOK.position() < this.BOK.limit()) {
            int n2 = this.BOK();
            if (this.BOK.limit() < this.BOK.position() + n2) {
                throw new IOException("OSC: Invalid Packet Size (" + n2 + ") which exceeds the packet by " + (this.BOK.position() + n2 - this.HaN.length) + " bytes.");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.HaN, this.BOK.position(), n2);
            ByteBuffer byteBuffer2 = this.BOK;
            byteBuffer2.position(byteBuffer2.position() + n2);
            this.BOK = byteBuffer;
            OscPacket oscPacket = this.w2Z(soS);
            soS.w2Z(oscPacket);
            assert (bTm.w2Z(byteBuffer.position() <= byteBuffer2.position()));
            this.BOK = byteBuffer2;
        }
        return soS;
    }
}

