/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.NotePlaybackCallback;
import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Channel;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.HardwareControlType;
import com.bitwig.extension.controller.api.Send;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableStringValue;
import com.bitwig.extension.controller.api.SoloValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.AbstractChannelProxy$1;
import com.bitwig.flt.control_surface.proxy.AbstractChannelProxy$2;
import com.bitwig.flt.control_surface.proxy.AbstractChannelProxy$VuMeterObserver;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceChainProxy;
import com.bitwig.flt.control_surface.proxy.DocumentAction;
import com.bitwig.flt.control_surface.proxy.SendBankProxy;
import com.bitwig.flt.control_surface.values.BooleanValueAtomProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.ComputedPlayingNoteArrayValue;
import com.bitwig.flt.control_surface.values.ComputedStringValue;
import com.bitwig.flt.control_surface.values.PlayingNote;
import com.bitwig.flt.control_surface.values.RemappableParameterProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.control_surface.values.SettableStringValueProxy;
import com.bitwig.flt.control_surface.values.SoloProxy;
import com.bitwig.flt.document.core.iface.KcU;
import com.bitwig.flt.document.core.iface.dfU;
import com.bitwig.flt.document.core.iface.rKC;
import com.bitwig.ramona.core.vE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractChannelProxy
extends DeviceChainProxy
implements Channel {
    protected final SettableBooleanValueProxy mIsActivated;
    protected final BooleanValueAtomProxy mMute;
    protected final SoloProxy mSolo;
    protected final Map mPlayingNotes = new HashMap();
    protected final ComputedPlayingNoteArrayValue mPlayingNotesValue;
    protected final RemappableParameterProxy mVolume;
    protected final RemappableParameterProxy mPan;
    protected final SettableColorValueProxy mColor;
    private final SettableStringValueProxy mNameProxy;
    protected final SendBankProxy mSendBankProxy;
    private final List mNotePlaybackCallbacks = new ArrayList();
    private uP mNoteObserverAtom;
    private final XmJ mNotePlaybackListener = gw2 -> this.notePlayed(gw2.HaN(), gw2.rLM(), gw2.bsM());
    private boolean mHasScheduledUpdatePlayingNotes = false;
    private final BooleanValueProxy mIsMutedBySolo;
    private final ComputedStringValue mChannelId;

    public AbstractChannelProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3) {
        super(controlSurfaceObject, string);
        this.mNameProxy = new SettableStringValueProxy(this);
        this.mChannelId = new ComputedStringValue(this);
        this.mIsActivated = new SettableBooleanValueProxy((ControlSurfaceObject)this, true);
        this.mMute = new BooleanValueAtomProxy(this);
        this.mPan = new RemappableParameterProxy((ControlSurfaceObject)this, string + "/Pan");
        this.mPan.setHardwareControlType(HardwareControlType.KNOB);
        this.mVolume = new RemappableParameterProxy((ControlSurfaceObject)this, string + "/Volume");
        this.mVolume.setHardwareControlType(HardwareControlType.SLIDER);
        this.mSolo = new SoloProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mPlayingNotesValue = new ComputedPlayingNoteArrayValue(this);
        this.mIsMutedBySolo = new BooleanValueProxy((ControlSurfaceObject)this, false);
        this.addChild(this.mIsActivated);
        this.addChild(this.mMute);
        this.addChild(this.mSolo);
        this.addChild(this.mVolume);
        this.addChild(this.mPan);
        this.addChild(this.mPlayingNotesValue);
        this.mVolume.setIndexInGroup(n2);
        this.mPan.setIndexInGroup(n2);
        this.mSendBankProxy = n3 > 0 ? new SendBankProxy(this, string + "/Send/", n3, n2) : null;
    }

    @Override
    protected int getNumSends() {
        return this.mSendBankProxy != null ? this.mSendBankProxy.getSizeOfBank() : 0;
    }

    @Override
    public void select() {
        this.selectInEditor();
    }

    @Override
    public void duplicate() {
        this.exec(() -> {
            wL wL2;
            if (this.getTarget() != null && (wL2 = this.getEditorChannelSelection((rKC)this.getTarget())) != null) {
                wL2.r2((vE)this.getTarget());
                wL2.Iso();
                if (wL2.cux()) {
                    wL2.XBS();
                }
            }
        });
    }

    @Override
    public StringValue channelId() {
        this.newSince(20);
        return this.mChannelId;
    }

    @Override
    public SettableBooleanValue isActivated() {
        return this.mIsActivated;
    }

    @Override
    public RemappableParameterProxy getVolume() {
        this.deprecated(1, 5, "Use volume() instead");
        return this.mVolume;
    }

    @Override
    public RemappableParameterProxy volume() {
        this.newSince(5);
        return this.mVolume;
    }

    @Override
    public RemappableParameterProxy getPan() {
        this.deprecated(1, 5, "Use pan() instead");
        return this.mPan;
    }

    @Override
    public RemappableParameterProxy pan() {
        this.newSince(5);
        return this.mPan;
    }

    @Override
    public SettableBooleanValue getMute() {
        this.deprecated(1, 5, "Use mute() instead");
        return this.mMute;
    }

    @Override
    public SettableBooleanValue mute() {
        this.newSince(5);
        return this.mMute;
    }

    @Override
    public SoloProxy getSolo() {
        this.deprecated(1, 5, "Use solo() instead");
        return this.mSolo;
    }

    @Override
    public SoloValue solo() {
        this.newSince(5);
        return this.mSolo;
    }

    @Override
    public BooleanValue isMutedBySolo() {
        this.newSince(10);
        return this.mIsMutedBySolo;
    }

    @Override
    public SendBankProxy sendBank() {
        if (this.mSendBankProxy == null) {
            throw new VEr("No send bank exists: Requested a send bank size of 0");
        }
        return this.mSendBankProxy;
    }

    public SendBankProxy getSendBankOnDocumentThread() {
        assert (this.w2Z(this.isDocumentThread()));
        return this.mSendBankProxy;
    }

    @Override
    public Send getSend(int n2) {
        if (this.mSendBankProxy == null) {
            if (this.getRequiredApiVersion() == 1) {
                return null;
            }
            throw new VEr("No send bank exists: Requested a send bank size of 0");
        }
        return this.mSendBankProxy.getItemAt(n2);
    }

    @Override
    public SettableStringValue name() {
        this.newSince(2);
        return this.mNameProxy;
    }

    @Override
    public void addNameObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.deprecated(1, 2, "Use name() instead");
        this.mNameProxy.addValueObserver(n2, string, stringValueChangedCallback);
    }

    @Override
    public void addVuMeterObserver(int n2, int n3, boolean bl2, IntegerValueChangedCallback integerValueChangedCallback) {
        if (n3 < -1 || n3 > 1) {
            throw new VEr("No such channel.");
        }
        this.addObserver(new AbstractChannelProxy$VuMeterObserver(this.getControlSurface(), integerValueChangedCallback, n2, n3, bl2));
    }

    @Override
    public ComputedPlayingNoteArrayValue playingNotes() {
        return this.mPlayingNotesValue;
    }

    @Override
    public void addNoteObserver(NotePlaybackCallback notePlaybackCallback) {
        assert (this.rLM(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(notePlaybackCallback, "callback");
        this.mNotePlaybackCallbacks.add(notePlaybackCallback);
    }

    private void notePlayed(boolean bl2, int n2, float f2) {
        assert (this.rLM(this.isDocumentThread()));
        if (!this.mNotePlaybackCallbacks.isEmpty()) {
            this.queueCallback(() -> this.notifyNotePlayed(bl2, n2, f2));
        }
        if (!this.mPlayingNotesValue.isInterested()) {
            return;
        }
        if (bl2) {
            this.mPlayingNotes.put(n2, new PlayingNote(n2, (int)(127.0f * f2)));
        } else {
            this.mPlayingNotes.remove(n2);
        }
        this.invalidatePlayingNotes();
    }

    private void invalidatePlayingNotes() {
        assert (this.w2Z(this.isDocumentThread()));
        if (!this.mHasScheduledUpdatePlayingNotes) {
            this.mHasScheduledUpdatePlayingNotes = true;
            this.runAtEndOfEvent(this::updatePlayingNotes);
        }
    }

    private void updatePlayingNotes() {
        assert (this.w2Z(this.isDocumentThread()));
        this.mHasScheduledUpdatePlayingNotes = false;
        PlayingNote[] playingNoteArray = this.mPlayingNotes.values().toArray(new PlayingNote[0]);
        this.mPlayingNotesValue.setValue(playingNoteArray);
    }

    private void notifyNotePlayed(boolean bl2, int n2, float f2) {
        assert (this.rLM(this.isControlSurfaceThread()));
        for (NotePlaybackCallback notePlaybackCallback : this.mNotePlaybackCallbacks) {
            notePlaybackCallback.notePlaybackEventOccurred(bl2, n2, f2);
        }
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    public Pu getColor() {
        di di2 = this.mColor.getEditableValue();
        if (di2 != null) {
            return (Pu)di2.getValue();
        }
        return null;
    }

    protected abstract wL getEditorChannelSelection(rKC var1);

    protected wL getMixerChannelSelection() {
        KcU kcU = this.getDocument();
        if (kcU != null) {
            return kcU.OLz().rLM();
        }
        return null;
    }

    @Override
    public void addIsSelectedInEditorObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.addObserver(new AbstractChannelProxy$1(this, this.getControlSurface(), booleanValueChangedCallback));
    }

    @Override
    public void addIsSelectedInMixerObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.addObserver(new AbstractChannelProxy$2(this, this.getControlSurface(), booleanValueChangedCallback));
    }

    @Override
    public void selectInEditor() {
        assert (this.rLM(this.isControlSurfaceThread()));
        this.exec(this::doSelectInEditor);
    }

    private void doSelectInEditor() {
        wL wL2;
        assert (this.rLM(this.isDocumentThread()));
        Sc sc2 = this.getDocumentGUIWrapper();
        if (sc2 != null && this.getTarget() != null && (wL2 = this.getEditorChannelSelection((rKC)this.getTarget())) != null) {
            wL2.KyJ((vE)this.getTarget());
            this.showSelectionNotification();
        }
    }

    @Override
    public void selectInMixer() {
        assert (this.rLM(this.isControlSurfaceThread()));
        this.exec(this::doSelectInMixer);
    }

    private void doSelectInMixer() {
        wL wL2;
        assert (this.rLM(this.isDocumentThread()));
        Sc sc2 = this.getDocumentGUIWrapper();
        if (sc2 != null && this.getTarget() != null && (wL2 = this.getMixerChannelSelection()) != null) {
            wL2.KyJ((vE)this.getTarget());
            this.showSelectionNotification();
        }
    }

    @Override
    public void makeVisibleInMixer() {
        assert (this.rLM(this.isControlSurfaceThread()));
        this.exec(this::doMakeVisibleInMixer);
    }

    private void doMakeVisibleInMixer() {
        SD sD2;
        assert (this.rLM(this.isDocumentThread()));
        if (this.getTarget() != null && (sD2 = this.getDocumentWidget()) != null) {
            List list = sD2.HaN(aJJ.class, true);
            for (aJJ aJJ2 : list) {
                aJJ2.w2Z((rKC)this.getTarget());
            }
        }
    }

    @Override
    public void makeVisibleInArranger() {
        assert (this.rLM(this.isControlSurfaceThread()));
        this.exec(this::doMakeVisibleInArranger);
    }

    private void doMakeVisibleInArranger() {
        SD sD2;
        assert (this.rLM(this.isDocumentThread()));
        if (this.getTarget() instanceof dfU && (sD2 = this.getDocumentWidget()) != null) {
            List list = sD2.HaN(Wq.class, true);
            for (Wq wq2 : list) {
                wq2.BOK((dfU)this.getTarget());
            }
        }
    }

    @Override
    protected String getName() {
        rKC rKC2 = (rKC)this.getTarget();
        if (rKC2 != null) {
            return rKC2.W23();
        }
        return "(none)";
    }

    protected void connectToTarget(rKC rKC2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(rKC2 != null));
        assert (this.rLM(rKC2.rhV()));
        this.mNameProxy.setTarget(rKC2.eJL(), rKC2.bw_());
        this.mIsActivated.setTarget(rKC2.RvW());
        this.mColor.setTarget(rKC2.Pgb(), rKC2.RTr());
        this.mChannelId.setValue(rKC2.tUG().toString());
        gZN gZN2 = rKC2.Bh1();
        if (gZN2 != null) {
            this.mMute.setTarget(gZN2.JEB());
            this.mSolo.setMixerModule(gZN2);
            this.mVolume.setTargetAtom(gZN2.KyJ());
            this.mPan.setTargetAtom(gZN2.UN3());
            this.mIsMutedBySolo.setTarget(gZN2.jEl());
        }
        this.mPlayingNotes.clear();
        this.invalidatePlayingNotes();
        if (this.mSendBankProxy != null) {
            this.mSendBankProxy.setTarget(rKC2);
        }
        assert (this.rLM(this.mNoteObserverAtom == null));
        this.mNoteObserverAtom = rKC2.Jec();
        if (this.mNoteObserverAtom != null) {
            this.mNoteObserverAtom.HaN(this.mNotePlaybackListener);
            this.mNoteObserverAtom.IdP().w2Z();
        }
        for (erh erh2 : this.getObservers()) {
            if (!(erh2 instanceof AbstractChannelProxy$VuMeterObserver)) continue;
            AbstractChannelProxy$VuMeterObserver abstractChannelProxy$VuMeterObserver = (AbstractChannelProxy$VuMeterObserver)erh2;
            int n2 = abstractChannelProxy$VuMeterObserver.mChannel;
            if (abstractChannelProxy$VuMeterObserver.mPeak) {
                abstractChannelProxy$VuMeterObserver.sendValue(((Iz)gZN2.zxv().rLM().get(n2)).bsM());
                ((Iz)gZN2.zxv().rLM().get(n2)).HaN(abstractChannelProxy$VuMeterObserver);
                continue;
            }
            abstractChannelProxy$VuMeterObserver.sendValue(((Iz)gZN2.zxv().rLM().get(n2)).w2Z());
            ((Iz)gZN2.zxv().rLM().get(n2)).w2Z(abstractChannelProxy$VuMeterObserver);
        }
        this.setDeviceChain(rKC2.zxv());
        this.connectObservers(rKC2);
    }

    protected void disconnectFromTarget(rKC rKC2) {
        assert (this.rLM(this.getTarget() != null));
        if (this.mNoteObserverAtom != null) {
            this.mNoteObserverAtom.rLM(this.mNotePlaybackListener);
            this.mNoteObserverAtom.IdP().rLM();
            this.mNoteObserverAtom = null;
        }
        this.mNameProxy.clearTarget();
        this.disconnectObservers(rKC2);
        this.setDeviceChain(null);
        gZN gZN2 = ((rKC)this.getTarget()).Bh1();
        if (this.mSendBankProxy != null) {
            this.mSendBankProxy.clearTarget();
        }
        for (erh erh2 : this.getObservers()) {
            if (!(erh2 instanceof AbstractChannelProxy$VuMeterObserver)) continue;
            AbstractChannelProxy$VuMeterObserver abstractChannelProxy$VuMeterObserver = (AbstractChannelProxy$VuMeterObserver)erh2;
            int n2 = abstractChannelProxy$VuMeterObserver.mChannel;
            Iz iz2 = (Iz)gZN2.zxv().rLM().get(n2);
            if (abstractChannelProxy$VuMeterObserver.mPeak) {
                iz2.rLM(abstractChannelProxy$VuMeterObserver);
            } else {
                iz2.BOK(abstractChannelProxy$VuMeterObserver);
            }
            abstractChannelProxy$VuMeterObserver.sendValue(0.0);
        }
        this.mChannelId.unassign();
        this.mIsActivated.clearTarget();
        this.mMute.clearTarget();
        this.mSolo.setMixerModule(null);
        this.mVolume.clearTarget();
        this.mPan.clearTarget();
        this.mColor.clearTarget();
        this.mIsMutedBySolo.clearTarget();
        this.mPlayingNotes.clear();
        this.invalidatePlayingNotes();
    }

    protected rKC getChannel() {
        return (rKC)this.getTarget();
    }

    @Override
    public void deleteObject() {
        assert (this.w2Z(this.isControlSurfaceThread()));
        this.newSince(10);
        this.getHost().deleteObjects("Delete Channel From Controller", this);
    }

    @Override
    public DocumentAction deleteObjectAction() {
        assert (this.UN3(this.isControlSurfaceThread()));
        this.newSince(15);
        return this.getHost().deleteObjectsAction((ControlSurfaceObject)this, "Delete Channel From Controller", this);
    }

    @Override
    public void duplicateObject() {
        assert (this.w2Z(this.isControlSurfaceThread()));
        this.newSince(19);
        this.getHost().duplicateObjects("Duplicate Channel From Controller", this);
    }

    @Override
    public HardwareActionBindable duplicateObjectAction() {
        assert (this.w2Z(this.isControlSurfaceThread()));
        this.newSince(19);
        return this.getHost().duplicateObjectsAction((ControlSurfaceObject)this, "Duplicate Channel From Controller", this);
    }
}

