/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.ObjectProxy;
import com.bitwig.extension.controller.api.Subscribable;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DelegatingControlSurfaceObjectProxy;
import com.bitwig.ramona.core.TO;
import com.bitwig.ramona.core.vE;
import java.util.Objects;

public abstract class ControlSurfaceProxy
extends ControlSurfaceObject
implements Subscribable {
    private final c2Q mTarget = new c2Q();
    private int mSubscriptionCountOnDocumentThread;
    private int mSubscriptionCount = 0;
    private boolean mSubscribedToAncestors;

    protected ControlSurfaceProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
        boolean bl2 = this.getControlSurface().zkl().FMt();
        this.mSubscriptionCountOnDocumentThread = this.mSubscriptionCount = bl2 ? 1 : 0;
    }

    public Object getTargetOfType(Class clazz) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(clazz != null));
        if (clazz.isAssignableFrom(this.getTargetType())) {
            return this.getTarget();
        }
        return null;
    }

    public final Object getDeepestTarget() {
        ControlSurfaceProxy controlSurfaceProxy = this.getDeepestProxy();
        assert (this.rLM(controlSurfaceProxy != null));
        assert (this.rLM(!(controlSurfaceProxy instanceof DelegatingControlSurfaceObjectProxy)));
        return controlSurfaceProxy.getTarget();
    }

    public ControlSurfaceProxy getDeepestProxy() {
        return this;
    }

    @Override
    public boolean isConnectedVia(vE vE2) {
        TO tO2;
        assert (this.rLM(vE2 != null));
        if (vE2 == null) {
            return false;
        }
        Object object = this.getTarget();
        if (vE2 == object || vE2 instanceof TO && (tO2 = (TO)vE2).FMt(vE2)) {
            return true;
        }
        return super.isConnectedVia(vE2);
    }

    @Override
    public void subscribe() {
        assert (this.rLM(this.isControlSurfaceThread()));
        assert (this.w2Z(this.mSubscriptionCount >= 0));
        ++this.mSubscriptionCount;
        if (this.mSubscriptionCount == 1) {
            this.exec(this::doSubscribe);
        }
    }

    private void doSubscribe() {
        assert (this.rLM(this.isDocumentThread()));
        ++this.mSubscriptionCountOnDocumentThread;
        if (this.mSubscriptionCountOnDocumentThread == 1) {
            assert (this.rLM(!this.mSubscribedToAncestors));
            Object object = this.mTarget.getValue();
            if (object != null && this.isInterested()) {
                this.connectToTarget(object);
            }
        }
    }

    @Override
    public void unsubscribe() {
        assert (this.rLM(this.isControlSurfaceThread()));
        if (this.mSubscriptionCount == 0) {
            throw new VEr("unsubscribe called more times than subscribe");
        }
        --this.mSubscriptionCount;
        if (this.mSubscriptionCount == 0) {
            this.exec(this::doUnsubscribe);
        }
    }

    private void doUnsubscribe() {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(this.mSubscriptionCountOnDocumentThread > 0));
        --this.mSubscriptionCountOnDocumentThread;
        if (this.mSubscriptionCountOnDocumentThread == 0) {
            Object object = this.mTarget.getValue();
            if (object != null && this.isInterested()) {
                this.disconnectFromTarget(object);
            }
            this.unsubscribeAncestors();
        }
    }

    public abstract Class getTargetType();

    public final Object getTarget() {
        assert (this.rLM(this.isDocumentThread()));
        return this.mTarget.getValue();
    }

    public final boolean hasTarget() {
        return this.getTarget() != null;
    }

    public final c2Q getTargetValue() {
        assert (this.rLM(this.isDocumentThread()));
        return this.mTarget;
    }

    public void setTarget(Object object) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(this.isTargetValid(object)));
        Object object2 = this.mTarget.getValue();
        if (!Objects.equals(object, object2)) {
            if (object2 != null) {
                this.disconnectFromTargetAlways(object2);
                if (this.mSubscriptionCountOnDocumentThread > 0 && this.isInterested()) {
                    this.disconnectFromTarget(object2);
                }
            }
            this.mTarget.setValue(object);
            this.targetChanged();
            if (object != null) {
                this.connectToTargetAlways(object);
                if (this.mSubscriptionCountOnDocumentThread > 0 && this.isInterested()) {
                    this.connectToTarget(object);
                }
            }
        }
    }

    public final void clearTarget() {
        this.setTarget(null);
    }

    protected boolean isTargetValid(Object object) {
        assert (this.rLM(this.isDocumentThread()));
        return true;
    }

    protected void targetChanged() {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(this.isTargetValid(this.mTarget.getValue())));
        this.getHost().targetChanged(this, this.mTarget.getValue());
    }

    public final BooleanValue createEqualsValue(ObjectProxy objectProxy) {
        return this.getHost().createAreProxiesEqualValue(this, (ControlSurfaceProxy)((Object)objectProxy));
    }

    @Override
    public final boolean isSubscribed() {
        assert (this.rLM(this.isControlSurfaceThread()));
        assert (this.w2Z(this.mSubscriptionCount >= 0));
        return this.mSubscriptionCount > 0;
    }

    @Override
    public final void setIsSubscribed(boolean bl2) {
        boolean bl3;
        assert (this.rLM(this.isControlSurfaceThread()));
        this.deprecatedFail(2, 10, "subscription is now counter based, use subscribe and unsubscribe instead");
        boolean bl4 = bl3 = this.mSubscriptionCount > 0;
        if (bl2 != bl3) {
            if (bl2) {
                assert (this.rLM(this.mSubscriptionCount == 0));
                this.mSubscriptionCount = 1;
                this.exec(this::doSubscribe);
            } else {
                assert (this.rLM(this.mSubscriptionCount == 1));
                this.mSubscriptionCount = 0;
                this.exec(this::doUnsubscribe);
            }
        }
    }

    private void subscribeAncestors() {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(!this.mSubscribedToAncestors));
        for (ControlSurfaceObject controlSurfaceObject = this.getParent(); controlSurfaceObject != null; controlSurfaceObject = controlSurfaceObject.getParent()) {
            if (!(controlSurfaceObject instanceof ControlSurfaceProxy)) continue;
            ((ControlSurfaceProxy)controlSurfaceObject).doSubscribe();
        }
        this.mSubscribedToAncestors = true;
    }

    private void unsubscribeAncestors() {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mSubscribedToAncestors) {
            for (ControlSurfaceObject controlSurfaceObject = this.getParent(); controlSurfaceObject != null; controlSurfaceObject = controlSurfaceObject.getParent()) {
                if (!(controlSurfaceObject instanceof ControlSurfaceProxy)) continue;
                ((ControlSurfaceProxy)controlSurfaceObject).doUnsubscribe();
            }
            this.mSubscribedToAncestors = false;
        }
    }

    public final boolean isActiveOnDocumentThread() {
        assert (this.rLM(this.isDocumentThread()));
        return this.mSubscriptionCountOnDocumentThread > 0;
    }

    protected abstract void connectToTarget(Object var1);

    protected abstract void disconnectFromTarget(Object var1);

    protected void connectToTargetAlways(Object object) {
    }

    protected void disconnectFromTargetAlways(Object object) {
    }

    protected boolean isInterested() {
        return true;
    }
}

