/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.CueMarker;
import com.bitwig.extension.controller.api.CueMarkerBank;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BankItemTargetUpdater;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.CueMarkerProxy;
import com.bitwig.flt.document.core.iface.KcU;

public class CueMarkerBankProxy
extends ControlSurfaceDocumentProxy
implements JJJ,
CueMarkerBank {
    private final CueMarkerProxy[] mMarkers;
    private final BankItemTargetUpdater mBankUpdater;

    protected CueMarkerBankProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2) {
        super(controlSurfaceObject);
        this.setKey(string);
        if (n2 < 1) {
            throw new VEr("At least 1 cue marker is required.");
        }
        this.mMarkers = new CueMarkerProxy[n2];
        this.mBankUpdater = new BankItemTargetUpdater(this, this.mMarkers, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            CueMarkerProxy cueMarkerProxy;
            this.mMarkers[i2] = cueMarkerProxy = this.createCueMarkerProxy(controlSurfaceObject, i2, this.getKey());
            this.addChild(cueMarkerProxy);
        }
    }

    private CueMarkerProxy createCueMarkerProxy(ControlSurfaceObject controlSurfaceObject, int n2, String string) {
        CueMarkerProxy cueMarkerProxy = new CueMarkerProxy(controlSurfaceObject);
        cueMarkerProxy.setKey(string + "/" + n2);
        return cueMarkerProxy;
    }

    protected void connectToTarget(KcU kcU) {
        assert (this.bsM(kcU != null));
        LOb lOb = kcU.Xeo().dMX().w2Z();
        this.mBankUpdater.setTarget(lOb.agk());
    }

    protected void disconnectFromTarget(KcU kcU) {
        assert (this.bsM(kcU != null));
        this.mBankUpdater.clearTarget();
    }

    @Override
    public int getSizeOfBank() {
        return this.mBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n2) {
        this.mBankUpdater.setSizeOfBank(n2);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mBankUpdater.getCapacityOfBank();
    }

    @Override
    public CueMarker getItemAt(int n2) {
        return (CueMarker)((Object)this.mBankUpdater.getItemAt(n2));
    }

    @Override
    public IntegerValue itemCount() {
        return this.mBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mBankUpdater.getCursorIndex();
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n2) {
        this.newSince(7);
        this.mBankUpdater.scrollIntoView(n2);
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mBankUpdater.getCanScrollForwards();
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mBankUpdater.getCanScrollBackwards();
    }

    @Override
    public void scrollByPages(int n2) {
        this.mBankUpdater.scrollByPages(n2);
    }

    @Override
    public void scrollPageForwards() {
        this.scrollByPages(1);
    }

    @Override
    public void scrollPageBackwards() {
        this.scrollByPages(-1);
    }

    @Override
    public void scrollBy(int n2) {
        this.mBankUpdater.scrollBy(n2);
    }

    @Override
    public void doStepForwards() {
        this.mBankUpdater.doScrollForwards();
    }

    @Override
    public void doStepBackwards() {
        this.mBankUpdater.doScrollBackwards();
    }

    @Override
    public void scrollForwards() {
        this.scrollBy(1);
    }

    @Override
    public void scrollBackwards() {
        this.scrollBy(-1);
    }

    @Override
    public void scrollToMarker(int n2) {
        this.mBankUpdater.scrollIntoView(n2);
    }

    @Override
    public HardwareActionBindable scrollBackwardsAction() {
        return this.mBankUpdater.scrollBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollForwardsAction() {
        return this.mBankUpdater.scrollForwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageBackwardsAction() {
        return this.mBankUpdater.scrollPageBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageForwardsAction() {
        return this.mBankUpdater.scrollPageForwardsAction();
    }

    @Override
    public void setSkipDisabledItems(boolean bl2) {
    }
}

