/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Device;
import com.bitwig.extension.controller.api.DeviceBank;
import com.bitwig.extension.controller.api.DeviceChain;
import com.bitwig.extension.controller.api.DeviceMatcher;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.app.bay;
import com.bitwig.flt.control_surface.proxy.AbstractDeviceMatcher;
import com.bitwig.flt.control_surface.proxy.ActiveDeviceMatcher;
import com.bitwig.flt.control_surface.proxy.AndDeviceMatcher;
import com.bitwig.flt.control_surface.proxy.BankItemTargetUpdater;
import com.bitwig.flt.control_surface.proxy.BankTarget;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceChainProxy;
import com.bitwig.flt.control_surface.proxy.DeviceProxy;
import com.bitwig.flt.control_surface.proxy.GUIFollowableBank;
import com.bitwig.flt.control_surface.proxy.MatchingPlaybackDevicesBankTarget;
import com.bitwig.flt.document.core.iface.KcU;
import java.util.Objects;

public class DeviceBankProxy
extends ControlSurfaceDocumentObjectProxy
implements JJJ,
DeviceBank,
GUIFollowableBank {
    private final int mNumDevices;
    private final DeviceProxy[] mDeviceProxies;
    private final BankItemTargetUpdater mDeviceBankUpdater;
    private final DeviceChain mDeviceChainSection;
    private boolean mSkipDisabledItems = false;
    private AbstractDeviceMatcher mDeviceMatcher;

    protected DeviceBankProxy(DeviceChainProxy deviceChainProxy, int n2, int n3) {
        super(deviceChainProxy);
        this.setKey("Device Chain");
        if (n2 < 1) {
            throw new VEr("At least 1 device is required.");
        }
        this.mDeviceChainSection = deviceChainProxy;
        this.mNumDevices = n2;
        this.mDeviceProxies = new DeviceProxy[n2];
        for (int i2 = 0; i2 < this.mNumDevices; ++i2) {
            this.mDeviceProxies[i2] = new DeviceProxy(this, this.getKey() + " / Device " + i2, n3, deviceChainProxy);
        }
        this.mDeviceBankUpdater = new BankItemTargetUpdater((ControlSurfaceObject)this, this.mDeviceProxies);
    }

    @Override
    public DeviceChainProxy getParent() {
        return (DeviceChainProxy)super.getParent();
    }

    @Override
    public void followInGUI(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        Tm tm2 = bay.slM().fzc();
        assert (this.rLM(tm2 != null));
        if (tm2 == null) {
            return;
        }
        tm2.HaN(this.mDeviceBankUpdater, bl2);
    }

    @Override
    public Class getTargetType() {
        return urf.class;
    }

    protected KcU getDocumentFromTarget(urf urf2) {
        return urf2.PTW();
    }

    @Override
    public DeviceChain getDeviceChain() {
        return this.mDeviceChainSection;
    }

    @Override
    public IntegerValue itemCount() {
        return this.mDeviceBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mDeviceBankUpdater.getCursorIndex();
    }

    @Override
    public void setSkipDisabledItems(boolean bl2) {
        this.newSince(11);
        this.exec(() -> this.doSetSkipDisabledItems(bl2));
    }

    private void doSetSkipDisabledItems(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mSkipDisabledItems != bl2) {
            this.mSkipDisabledItems = bl2;
            this.updateBankTarget();
        }
    }

    private void updateBankTarget() {
        assert (this.rLM(this.isDocumentThread()));
        urf urf2 = (urf)this.getTarget();
        if (urf2 != null) {
            this.mDeviceBankUpdater.setTarget(this.createBankTarget(urf2));
        }
    }

    private BankTarget createBankTarget(urf urf2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(urf2 != null));
        AbstractDeviceMatcher abstractDeviceMatcher = this.getEffectiveDeviceMatcher();
        return abstractDeviceMatcher != null ? new MatchingPlaybackDevicesBankTarget(urf2, abstractDeviceMatcher) : BankTarget.create(urf2.Pgb());
    }

    private AbstractDeviceMatcher getEffectiveDeviceMatcher() {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mSkipDisabledItems) {
            if (this.mDeviceMatcher == null) {
                return new ActiveDeviceMatcher();
            }
            return new AndDeviceMatcher(new AbstractDeviceMatcher[]{new ActiveDeviceMatcher(), this.mDeviceMatcher});
        }
        return this.mDeviceMatcher;
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mDeviceBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mDeviceBankUpdater.getCanScrollForwards();
    }

    @Override
    public int getSizeOfBank() {
        return this.mDeviceBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n2) {
        this.mDeviceBankUpdater.setSizeOfBank(n2);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mDeviceBankUpdater.getCapacityOfBank();
    }

    @Override
    public Device getItemAt(int n2) {
        return (Device)((Object)this.mDeviceBankUpdater.getItemAt(n2));
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mDeviceBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n2) {
        this.newSince(7);
        this.mDeviceBankUpdater.scrollIntoView(n2);
    }

    @Override
    public void scrollBy(int n2) {
        this.mDeviceBankUpdater.scrollBy(n2);
    }

    @Override
    public void doStepForwards() {
        this.mDeviceBankUpdater.doScrollForwards();
    }

    @Override
    public void doStepBackwards() {
        this.mDeviceBankUpdater.doScrollBackwards();
    }

    @Override
    public void scrollByPages(int n2) {
        this.mDeviceBankUpdater.scrollByPages(n2);
    }

    public void navigateToDeviceLayer(int n2, int n3) {
        this.validIndex(this.mDeviceProxies, n2);
        if (n3 < 0) {
            throw new VEr("layerIndex must be >= 0");
        }
        this.exec(() -> {
            nEd nEd2;
            A3f a3f;
            iQh iQh2;
            DeviceProxy deviceProxy = this.mDeviceProxies[n2];
            hne hne2 = deviceProxy.getDevice();
            if (hne2 instanceof hdD && (iQh2 = (a3f = (A3f)hne2.eJL()).UN3()) instanceof nEd && n3 < (nEd2 = (nEd)iQh2).stE()) {
                hLw hLw2 = nEd2.BOK(n3);
                this.setTarget(hLw2.zxv());
            }
        });
    }

    public void navigateToKeyPad(int n2, int n3) {
        this.validIndex(this.mDeviceProxies, n2);
        if (n3 < 0 || n3 > 127) {
            throw new VEr("Invalid key");
        }
        this.exec(() -> {
            agD agD2;
            zWL zWL2;
            hLw hLw2;
            A3f a3f;
            iQh iQh2;
            DeviceProxy deviceProxy = this.mDeviceProxies[n2];
            hne hne2 = deviceProxy.getDevice();
            if (hne2 instanceof hdD && (iQh2 = (a3f = (A3f)hne2.eJL()).UN3()) instanceof agD && (hLw2 = (zWL2 = (agD2 = (agD)iQh2).w2Z(n3)).rLM()) != null) {
                this.setTarget(hLw2.zxv());
            }
        });
    }

    public void navigateToDeviceSlot(int n2, String string) {
        this.validIndex(this.mDeviceProxies, n2);
        this.notNull(string, "chain");
        this.exec(() -> {
            DeviceProxy deviceProxy = this.mDeviceProxies[n2];
            hne hne2 = deviceProxy.getDevice();
            if (hne2 instanceof hdD) {
                A3f a3f = (A3f)hne2.eJL();
                for (CDR cDR2 : a3f.zxv()) {
                    CrW crW2;
                    if (!(cDR2 instanceof CrW) || !(crW2 = (CrW)cDR2).w2Z().equals(string)) continue;
                    this.setTarget(crW2.UN3().zxv());
                    return;
                }
            }
        });
    }

    @Override
    public void scrollPageUp() {
        this.mDeviceBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageDown() {
        this.mDeviceBankUpdater.scrollByPages(1);
    }

    @Override
    public void scrollUp() {
        this.mDeviceBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollDown() {
        this.mDeviceBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollTo(int n2) {
        this.mDeviceBankUpdater.scrollIntoView(n2);
    }

    @Override
    public Device getDevice(int n2) {
        return (Device)((Object)this.mDeviceBankUpdater.getItemAt(n2));
    }

    protected void connectToTarget(urf urf2) {
        assert (this.w2Z(this.isDocumentThread()));
        assert (this.bsM(urf2 != null));
        this.mDeviceBankUpdater.setTarget(this.createBankTarget(urf2));
        this.connectObservers(urf2);
    }

    protected void disconnectFromTarget(urf urf2) {
        assert (this.w2Z(this.isDocumentThread()));
        this.mDeviceBankUpdater.clearTarget();
    }

    @Override
    public void addScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        this.deprecated(1, 2, "Use scrollPosition() instead");
        this.mDeviceBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback, n2);
    }

    @Override
    public void addCanScrollUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollBackwards() instead");
        this.mDeviceBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanScrollDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollForwards() instead");
        this.mDeviceBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addDeviceCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use itemCount().addValueObserver(callback)");
        this.mDeviceBankUpdater.getListItemCount().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public HardwareActionBindable scrollBackwardsAction() {
        return this.mDeviceBankUpdater.scrollBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollForwardsAction() {
        return this.mDeviceBankUpdater.scrollForwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageBackwardsAction() {
        return this.mDeviceBankUpdater.scrollPageBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageForwardsAction() {
        return this.mDeviceBankUpdater.scrollPageForwardsAction();
    }

    @Override
    public void browseToInsertDevice(int n2) {
        assert (this.rLM(this.isControlSurfaceThread()));
        this.inRange(n2, 0, this.getSizeOfBank(), "index");
        this.exec(() -> this.doBrowseToInsertDevice(n2));
    }

    private void doBrowseToInsertDevice(int n2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(n2 >= 0 && n2 <= this.getSizeOfBank()));
        urf urf2 = (urf)this.getTarget();
        if (urf2 != null) {
            int n3 = nBT.w2Z(this.mDeviceBankUpdater.getScrollPositionValue() + n2, 0, urf2.RTr());
            if (n3 > 0) {
                hne hne2 = urf2.BOK(n3 - 1);
                anz.w2Z(null, new anu(hne2));
            } else {
                anz.w2Z(null, new anw(urf2));
            }
        }
    }

    @Override
    public void setDeviceMatcher(DeviceMatcher deviceMatcher) {
        this.newSince(12);
        AbstractDeviceMatcher abstractDeviceMatcher = AbstractDeviceMatcher.get(deviceMatcher);
        if (this.isInitializingDriver()) {
            this.mDeviceMatcher = abstractDeviceMatcher;
        } else {
            this.exec(() -> this.doSetDeviceMatcher(abstractDeviceMatcher));
        }
    }

    private void doSetDeviceMatcher(AbstractDeviceMatcher abstractDeviceMatcher) {
        assert (this.rLM(this.isDocumentThread()));
        if (!Objects.equals(abstractDeviceMatcher, this.mDeviceMatcher)) {
            this.mDeviceMatcher = abstractDeviceMatcher;
            this.updateBankTarget();
        }
    }
}

