/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.Arpeggiator;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.NoteInput$NoteExpression;
import com.bitwig.extension.controller.api.NoteLatch;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.flt.control_surface.proxy.ArpeggiatorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject$AllowedCreationTime;
import com.bitwig.flt.control_surface.proxy.DirectNoteInput$1;
import com.bitwig.flt.control_surface.proxy.MIDIEventFilter;
import com.bitwig.flt.control_surface.proxy.NoteLatchProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.document.core.iface.KcU;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DirectNoteInput
extends ControlSurfaceObject
implements JT3,
NoteInput {
    private int mEngineNoteInputId;
    private boolean mShouldConsumeEvents;
    private final List mFilters;
    private final String mName;
    private final ArpeggiatorProxy mArpeggiatorProxy;
    private final NoteLatchProxy mNoteLatchProxy;
    private sIe mNoteSource;
    private final SettableBooleanValueProxy mIncludeInAllInputsProxy;
    private boolean mShouldIncludeInAllInputs;
    private byte[] mKeyTranslationTable;
    private byte[] mKeyTranslationTableOnEventThread;
    private UHG mNoteInputSettings;
    private XmJ mNoteSettingsNoteInputListener;

    public DirectNoteInput(ControlSurfaceObject controlSurfaceObject, String string, String[] stringArray, boolean bl2) {
        super(controlSurfaceObject, ControlSurfaceObject$AllowedCreationTime.INIT);
        this.mName = string;
        try {
            this.mEngineNoteInputId = this.getMidiProviderConnection().w2Z(this.getControlSurface(), bl2);
        }
        catch (IOException iOException) {
            throw new Bjx(this.getControlSurface(), "Could not create note input", iOException);
        }
        this.mShouldIncludeInAllInputs = bl2;
        this.mIncludeInAllInputsProxy = new DirectNoteInput$1(this, this, bl2);
        this.mNoteLatchProxy = new NoteLatchProxy(this);
        this.mArpeggiatorProxy = new ArpeggiatorProxy(this);
        this.mFilters = new ArrayList(stringArray.length);
        for (String string2 : stringArray) {
            try {
                MIDIEventFilter mIDIEventFilter = new MIDIEventFilter(string2);
                this.mFilters.add(mIDIEventFilter);
            }
            catch (VEr vEr) {
                bTm.bsM.HaN("Could not parse note input mask", vEr);
            }
        }
        try {
            this.sendNoteInputMasks();
        }
        catch (IOException iOException) {
            throw new Bjx(this.getControlSurface(), "Could not send note input masks", iOException);
        }
    }

    public int getEngineNoteInputId() {
        return this.mEngineNoteInputId;
    }

    public void destroy() {
        assert (this.rLM(this.isControlSurfaceThread()));
        try {
            assert (this.HaN(this.mEngineNoteInputId >= 0));
            this.getMidiProviderConnection().w2Z(this.mEngineNoteInputId);
            this.mEngineNoteInputId = -1;
        }
        catch (IOException iOException) {
            bTm.bsM.BOK(iOException);
        }
    }

    private void sendNoteInputMasks() {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        int n2 = this.mFilters.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            nArray[n3] = mIDIEventFilter.getCheckMask();
            nArray2[n3] = mIDIEventFilter.getMatchMask();
            ++n3;
        }
        this.getMidiProviderConnection().w2Z(this.mEngineNoteInputId, nArray, nArray2);
    }

    private void sendKeyMap(byte[] byArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        assert (this.rLM(byArray.length == 128));
        this.getMidiProviderConnection().w2Z(this.mEngineNoteInputId, byArray);
    }

    private void sendVelocityMap(byte[] byArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        assert (this.rLM(byArray.length == 128));
        this.getMidiProviderConnection().BOK(this.mEngineNoteInputId, byArray);
    }

    private vJr getMidiProviderConnection() {
        return this.getControlSurface().agk();
    }

    public boolean shouldConsumeEvents() {
        return this.mShouldConsumeEvents;
    }

    @Override
    public void setShouldConsumeEvents(boolean bl2) {
        this.mShouldConsumeEvents = bl2;
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        try {
            this.getMidiProviderConnection().w2Z(this.mEngineNoteInputId, bl2);
        }
        catch (IOException iOException) {
            throw new Bjx(this.getControlSurface(), (Throwable)iOException);
        }
    }

    private byte[] convertJavaScriptArrayToByteArray(Object[] objectArray) {
        byte[] byArray = new byte[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!(objectArray[i2] instanceof Number)) {
                throw new VEr("Object in array not instance of Number");
            }
            Number number = (Number)objectArray[i2];
            if (number.intValue() < -128 || number.intValue() > 127) {
                throw new VEr("Value out of range");
            }
            byArray[i2] = number.byteValue();
        }
        return byArray;
    }

    @Override
    public void setKeyTranslationTable(Object[] objectArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new VEr("Map must have a length of 128");
        }
        byte[] byArray = this.convertJavaScriptArrayToByteArray(objectArray);
        if (Arrays.equals(byArray, this.mKeyTranslationTable)) {
            return;
        }
        this.mKeyTranslationTable = byArray;
        this.exec(() -> this.setKeyTranslationTableOnDocumentThread(byArray));
        try {
            this.sendKeyMap(this.mKeyTranslationTable);
        }
        catch (IOException iOException) {
            throw new Bjx(this.getControlSurface(), (Throwable)iOException);
        }
    }

    private void setKeyTranslationTableOnDocumentThread(byte[] byArray) {
        assert (this.rLM(this.isDocumentThread()));
        this.mKeyTranslationTableOnEventThread = byArray;
        this.getHost().getHardwareControllerProxy().bsM();
    }

    @Override
    public void setVelocityTranslationTable(Object[] objectArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new VEr("Map must have a length of 128");
        }
        try {
            this.sendVelocityMap(this.convertJavaScriptArrayToByteArray(objectArray));
        }
        catch (IOException iOException) {
            throw new Bjx(this.getControlSurface(), (Throwable)iOException);
        }
    }

    @Override
    public void assignPolyphonicAftertouchToExpression(int n2, NoteInput$NoteExpression noteInput$NoteExpression, int n3) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        try {
            this.getMidiProviderConnection().w2Z(this.mEngineNoteInputId, n2, noteInput$NoteExpression, n3);
        }
        catch (IOException iOException) {
            throw new Bjx(this.getControlSurface(), (Throwable)iOException);
        }
    }

    @Override
    public void setUseExpressiveMidi(boolean bl2, int n2, int n3) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (n2 != 0 && n2 != 15) {
            throw new VEr("baseChannel must be either 0 or 15");
        }
        if (n3 < 0 || n3 > 96) {
            throw new VEr("pitchBendRange must be between 0 or 96");
        }
        try {
            this.getMidiProviderConnection().w2Z(this.mEngineNoteInputId, bl2, n2, n3);
        }
        catch (IOException iOException) {
            throw new Bjx(this.getControlSurface(), (Throwable)iOException);
        }
    }

    @Override
    public void setUseMultidimensionalPolyphonicExpression(boolean bl2, int n2) {
        this.deprecated(1, 2);
        this.setUseExpressiveMidi(bl2, n2, 48);
    }

    @Override
    public void sendRawMidiEvent(int n2, int n3, int n4) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (n2 < 128 || n2 > 255) {
            throw new VEr("Status byte out of range");
        }
        if (n3 < 0 || n3 > 127) {
            throw new VEr("data0 byte out of range");
        }
        if (n4 < 0 || n4 > 127) {
            throw new VEr("data1 byte out of range");
        }
        try {
            this.getMidiProviderConnection().w2Z(this.mEngineNoteInputId, n2, n3, n4);
        }
        catch (IOException iOException) {
            throw new Bjx(this.getControlSurface(), (Throwable)iOException);
        }
    }

    @Override
    public NoteLatch noteLatch() {
        this.newSince(10);
        return this.mNoteLatchProxy;
    }

    public boolean isMatchAll() {
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            if (!mIDIEventFilter.isMatchAll()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public Arpeggiator arpeggiator() {
        this.newSince(10);
        return this.mArpeggiatorProxy;
    }

    public void connectToDocument(KcU kcU) {
        assert (this.rLM(this.mNoteSource == null));
        assert (this.rLM(!kcU.Jec()));
        this.mNoteSource = kcU.w2Z(this.mEngineNoteInputId);
        this.mNoteSource.w2Z(this.mShouldIncludeInAllInputs);
        this.mIncludeInAllInputsProxy.setTarget(this.mNoteSource.KyJ());
        this.mNoteLatchProxy.setTarget(this.mNoteSource.rLM());
        this.mArpeggiatorProxy.setTarget(this.mNoteSource.bsM());
    }

    public void disconnectFromDocument() {
        assert (this.rLM(this.mNoteSource != null));
        this.mNoteLatchProxy.clearTarget();
        this.mArpeggiatorProxy.clearTarget();
        this.mIncludeInAllInputsProxy.clearTarget();
        this.mNoteSource = null;
    }

    sIe getNoteSource() {
        return this.mNoteSource;
    }

    @Override
    public SettableBooleanValue includeInAllInputs() {
        this.newSince(10);
        return this.mIncludeInAllInputsProxy;
    }

    public boolean shouldProcessEvent(qzq qzq2) {
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            if (!mIDIEventFilter.matches(qzq2)) continue;
            return true;
        }
        return false;
    }

    public qzq getTransformedEvent(qzq qzq2) {
        assert (this.rLM(this.isControlSurfaceThread()));
        assert (this.rLM(this.shouldProcessEvent(qzq2)));
        return this.getTransformedEvent(qzq2, this.mKeyTranslationTable);
    }

    public boolean checkIfEventIsNoteInputOnDocumentThread(qzq qzq2) {
        assert (this.rLM(this.isDocumentThread()));
        if (!this.shouldProcessEvent(qzq2)) {
            return false;
        }
        return this.getTransformedEvent(qzq2, this.mKeyTranslationTableOnEventThread) != null;
    }

    public qzq getTransformedEvent(qzq qzq2, byte[] byArray) {
        assert (this.rLM(this.shouldProcessEvent(qzq2)));
        if (qzq2.HaN()) {
            int n2 = qzq2.bsM();
            if (byArray != null) {
                if ((n2 = byArray[n2]) == -1) {
                    return null;
                }
                return new qzq(qzq2.Gox(), n2, qzq2.GvW());
            }
        }
        return qzq2;
    }

    public void connectToNoteInputSettings(UHG uHG) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(this.mNoteInputSettings == null));
        this.mNoteInputSettings = uHG;
        this.mNoteSettingsNoteInputListener = xxR2 -> {
            int n2 = xxR2.HaN();
            int n3 = xxR2.rLM();
            int n4 = xxR2.bsM();
            this.sendRawMidiEvent(n2, n3, n4);
        };
        uHG.HaN(this.mNoteSettingsNoteInputListener);
    }

    public void disconnectFromNoteInputSettings() {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mNoteInputSettings != null) {
            this.mNoteInputSettings.rLM(this.mNoteSettingsNoteInputListener);
            this.mNoteInputSettings = null;
            this.mNoteSettingsNoteInputListener = null;
        }
    }
}

