/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.DrumPadBank;
import com.bitwig.flt.control_surface.proxy.BankTarget;
import com.bitwig.flt.control_surface.proxy.ChannelBankProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.DrumPadProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.document.core.iface.KcU;
import java.util.ArrayList;
import java.util.List;

public class DrumPadBankProxy
extends ChannelBankProxy
implements DrumPadBank {
    private final boolean mIsIndicating = true;
    private final int mNumLanes;
    private final List mPads;
    private final BooleanValueProxy mHasMutedPads;
    private final BooleanValueProxy mHasSoloedPads;

    public DrumPadBankProxy(ControlSurfaceObject controlSurfaceObject, int n2, int n3) {
        super(controlSurfaceObject, "DrumPadBank-" + n2, n2, n3);
        if (n2 < 1) {
            throw new VEr("At least 1 track is required.");
        }
        this.mNumLanes = n2;
        this.mPads = new ArrayList(n2);
        this.mChannelScrollStepSize = 4;
        this.mHasMutedPads = new BooleanValueProxy((ControlSurfaceObject)this, false);
        this.mHasSoloedPads = new BooleanValueProxy((ControlSurfaceObject)this, false);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.getKey() + "/Pad" + i2;
            DrumPadProxy drumPadProxy = new DrumPadProxy(this, string, i2, n3, true);
            this.mPads.add(drumPadProxy);
            this.addChild(drumPadProxy);
        }
        this.initChannelProxies();
    }

    @Override
    public Class getTargetType() {
        return agD.class;
    }

    protected KcU getDocumentFromTarget(agD agD2) {
        return agD2.PTW();
    }

    @Override
    public void setIndication(boolean bl2) {
        assert (this.rLM(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetIndication(bl2));
    }

    private void doSetIndication(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            DrumPadProxy drumPadProxy = (DrumPadProxy)controlSurfaceProxy;
            drumPadProxy.setIndicating(bl2);
        }
    }

    @Override
    protected int getScrollPositionThatPageShouldAlignTo() {
        return 36;
    }

    @Override
    protected DrumPadProxy createChannelProxy(int n2, int n3, String string) {
        return new DrumPadProxy(this, string + n3, n3, n2, true);
    }

    protected BankTarget createBankTarget(agD agD2, boolean bl2) {
        return BankTarget.create(agD2.w2Z());
    }

    protected void connectToTarget(agD agD2) {
        int n2 = Integer.MAX_VALUE;
        boolean bl2 = agD2.stE() > 0;
        int n3 = this.mChannelBankUpdater.getScrollPositionValue();
        boolean bl3 = false;
        for (hLw hLw2 : agD2.Jec()) {
            assert (this.rLM(bl2));
            int n4 = hLw2.UN3().KyJ();
            n2 = Math.min(n4, n2);
            if (n4 < n3 || n4 > n3 + this.getSizeOfBank() - 1) continue;
            bl3 = true;
        }
        if (bl2) {
            if (!bl3) {
                this.mChannelBankUpdater.doScrollIntoView(n2);
            }
        } else {
            this.mChannelBankUpdater.doScrollTo(this.getScrollPositionThatPageShouldAlignTo(), true);
        }
        this.mHasMutedPads.setTarget(agD2.zkl());
        this.mHasSoloedPads.setTarget(agD2.CKO());
    }

    protected void disconnectFromTarget(agD agD2) {
        this.mHasMutedPads.clearTarget();
        this.mHasSoloedPads.clearTarget();
    }

    @Override
    public void clearMutedPads() {
        assert (this.w2Z(this.isControlSurfaceThread()));
        this.newSince(10);
        this.exec(this::doClearMute);
    }

    private void doClearMute() {
        assert (this.w2Z(this.isDocumentThread()));
        agD agD2 = (agD)this.getTarget();
        if (agD2 == null) {
            return;
        }
        agD2.tBx();
    }

    @Override
    public void clearSoloedPads() {
        assert (this.w2Z(this.isControlSurfaceThread()));
        this.newSince(10);
        this.exec(this::doClearSolo);
    }

    private void doClearSolo() {
        assert (this.w2Z(this.isDocumentThread()));
        agD agD2 = (agD)this.getTarget();
        if (agD2 == null) {
            return;
        }
        agD2.OyU();
    }

    @Override
    public BooleanValue hasMutedPads() {
        this.newSince(10);
        return this.mHasMutedPads;
    }

    @Override
    public BooleanValue hasSoloedPads() {
        this.newSince(10);
        return this.mHasSoloedPads;
    }
}

