/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.ShortMidiDataReceivedCallback;
import com.bitwig.extension.callback.SysexMidiDataReceivedCallback;
import com.bitwig.extension.controller.api.AbsoluteHardwareValueMatcher;
import com.bitwig.extension.controller.api.HardwareActionMatcher;
import com.bitwig.extension.controller.api.MidiExpressions;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.RelativeHardwareValueMatcher;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject$AllowedCreationTime;
import com.bitwig.flt.control_surface.proxy.DirectNoteInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MidiInPort
extends ControlSurfaceObject
implements JT3,
MidiIn {
    private final int mIndex;
    private final List mNoteInputsToSendTo = new ArrayList();

    public MidiInPort(ControlSurfaceObject controlSurfaceObject, int n2) {
        super(controlSurfaceObject, ControlSurfaceObject$AllowedCreationTime.DRIVER_SETUP);
        this.mIndex = n2;
    }

    @Override
    public void setMidiCallback(ShortMidiDataReceivedCallback shortMidiDataReceivedCallback) {
        assert (this.rLM(this.isControlSurfaceThread()));
        this.getControlSurface().w2Z(this.mIndex, shortMidiDataReceivedCallback);
    }

    @Override
    public void setSysexCallback(SysexMidiDataReceivedCallback sysexMidiDataReceivedCallback) {
        assert (this.rLM(this.isControlSurfaceThread()));
        this.getControlSurface().w2Z(this.mIndex, sysexMidiDataReceivedCallback);
    }

    @Override
    public NoteInput createNoteInput(String string, String ... stringArray) {
        this.notNull(string, "name");
        this.checkIsInitializingDriver();
        boolean bl2 = true;
        for (DirectNoteInput directNoteInput : this.mNoteInputsToSendTo) {
            if (!directNoteInput.isMatchAll()) continue;
            bl2 = false;
            break;
        }
        DirectNoteInput directNoteInput = this.getControlSurface().w2Z(this.getHost(), string, bl2, stringArray);
        this.sendToNoteInputImpl(directNoteInput);
        return directNoteInput;
    }

    private void sendToNoteInputImpl(DirectNoteInput directNoteInput) {
        assert (this.rLM(this.isControlSurfaceThread()));
        try {
            if (!this.mNoteInputsToSendTo.contains(directNoteInput)) {
                String string = ((kK)this.getControlSurface().tUG().get(this.mIndex)).rLM().KyJ();
                this.getControlSurface().agk().BOK(string, directNoteInput.getEngineNoteInputId());
                this.mNoteInputsToSendTo.add(directNoteInput);
            }
        }
        catch (IOException iOException) {
            throw new Bjx(this.getControlSurface(), "Could not connect MIDI input to note input", iOException);
        }
    }

    private void stopSendingToNoteInputImpl(DirectNoteInput directNoteInput) {
        assert (this.rLM(this.isControlSurfaceThread()));
        try {
            if (this.mNoteInputsToSendTo.contains(directNoteInput)) {
                String string = ((kK)this.getControlSurface().tUG().get(this.mIndex)).rLM().KyJ();
                this.getControlSurface().agk().HaN(string, directNoteInput.getEngineNoteInputId());
                this.mNoteInputsToSendTo.remove(directNoteInput);
            }
        }
        catch (IOException iOException) {
            throw new Bjx(this.getControlSurface(), "Could not disconnect MIDI input to note input", iOException);
        }
    }

    public boolean checkIfEventIsNoteInputOnDocumentThread(qzq qzq2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(qzq2 != null));
        for (DirectNoteInput directNoteInput : this.mNoteInputsToSendTo) {
            if (!directNoteInput.checkIfEventIsNoteInputOnDocumentThread(qzq2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbsoluteHardwareValueMatcher createAbsolutePitchBendValueMatcher(int n2) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsPitchBendExpression(n2), "data2 << 7 | data1", 14);
    }

    @Override
    public AbsoluteHardwareValueMatcher createSequencedValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher2, boolean bl2) {
        this.checkMatcherIsForThisMidiIn("firstValueMatcher", absoluteHardwareValueMatcher);
        this.checkMatcherIsForThisMidiIn("secondValueMatcher", absoluteHardwareValueMatcher2);
        return new TcY((nsO)((Object)absoluteHardwareValueMatcher), (nsO)((Object)absoluteHardwareValueMatcher2), bl2);
    }

    @Override
    public Crk createAbsoluteValueMatcher(String string, String string2, int n2) {
        return new Crk(this.createActionMatcher(string), this.parseExpression(string2), n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeValueMatcher(String string, double d2) {
        return new Okz(this, this.parseExpression(string), d2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelativeSignedBitValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new fpP((NTG)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2ValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelativeSignedBit2ValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2ValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new yss((NTG)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelativeBinOffsetValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new oxZ((NTG)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelative2sComplementValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new Jrc((NTG)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public FRQ createActionMatcher(String string) {
        return new FRQ(this, this.parseExpression(string));
    }

    @Override
    public String hardwareAddress() {
        this.newSince(21);
        String string = this.getMidiReceiver().rLM().KyJ();
        return this.getControlSurface().agk().w2Z(string, true);
    }

    @Override
    public HardwareActionMatcher createCCActionMatcher(int n2, int n3, int n4) {
        return this.createActionMatcher(this.midiExpressions().createIsCCValueExpression(n2, n3, n4));
    }

    @Override
    public HardwareActionMatcher createCCActionMatcher(int n2, int n3) {
        return this.createActionMatcher(this.midiExpressions().createIsCCExpression(n2, n3));
    }

    @Override
    public HardwareActionMatcher createNoteOnActionMatcher(int n2, int n3) {
        return this.createActionMatcher(this.midiExpressions().createIsNoteOnExpression(n2, n3));
    }

    @Override
    public AbsoluteHardwareValueMatcher createNoteOnVelocityValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsNoteOnExpression(n2, n3), "data2", 7);
    }

    @Override
    public AbsoluteHardwareValueMatcher createNoteOffVelocityValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsNoteOffExpression(n2, n3), "data2", 7);
    }

    @Override
    public HardwareActionMatcher createNoteOffActionMatcher(int n2, int n3) {
        return this.createActionMatcher(this.midiExpressions().createIsNoteOffExpression(n2, n3));
    }

    @Override
    public AbsoluteHardwareValueMatcher createAbsoluteCCValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7);
    }

    @Override
    public AbsoluteHardwareValueMatcher createAbsoluteCCValueMatcher(int n2) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsCCExpression(n2), "data2", 7);
    }

    @Override
    public AbsoluteHardwareValueMatcher createPolyAftertouchValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsPolyAftertouch(n2, n3), "data2", 7);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitCCValueMatcher(int n2, int n3, int n4) {
        return this.createRelativeSignedBitValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2CCValueMatcher(int n2, int n3, int n4) {
        return this.createRelativeSignedBit2ValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetCCValueMatcher(int n2, int n3, int n4) {
        return this.createRelativeBinOffsetValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementCCValueMatcher(int n2, int n3, int n4) {
        return this.createRelative2sComplementValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    private jk parseExpression(String string) {
        try {
            return jk.BOK(string);
        }
        catch (jr jr2) {
            throw new VEr("Invalid MIDI event expression", jr2);
        }
    }

    public int getIndex() {
        return this.mIndex;
    }

    public kK getMidiReceiver() {
        return (kK)this.getControlSurface().tUG().get(this.mIndex);
    }

    private MidiExpressions midiExpressions() {
        return this.getHost().midiExpressions();
    }

    private void checkMatcherIsForThisMidiIn(String string, AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher) {
        if (!(absoluteHardwareValueMatcher instanceof NTG)) {
            throw new VEr(string + " is not a MIDI value matcher for this MidiIn");
        }
        if (((NTG)absoluteHardwareValueMatcher).rLM() != this) {
            throw new VEr(string + " is not a MIDI value matcher for this MidiIn");
        }
    }

    public List getNoteInputsToSendTo() {
        return this.mNoteInputsToSendTo;
    }

    public void close() {
        assert (this.rLM(this.isControlSurfaceThread()));
        for (DirectNoteInput directNoteInput : new ArrayList(this.mNoteInputsToSendTo)) {
            try {
                this.stopSendingToNoteInputImpl(directNoteInput);
            }
            catch (Bjx bjx2) {
                bTm.bsM.HaN("Error closing MIDI in", bjx2);
            }
        }
    }

    public int getHarwareInputSourceId() {
        return this.getControlSurface().SUJ();
    }

    @Override
    public void sendRawMidiEvent(int n2, int n3, int n4) {
        kK kK2 = this.getMidiReceiver();
        try {
            kK2.w2Z(0L, n2, n3, n4);
        }
        catch (IOException iOException) {
            bTm.bsM.BOK(iOException);
        }
    }
}

