/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IndexedStringValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.CursorDevice;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.Device;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.InsertionPoint;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.extension.controller.api.SourceSelector;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.flt.control_surface.proxy.AbstractChannelProxy;
import com.bitwig.flt.control_surface.proxy.AbstractTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.BankItemWithPosition;
import com.bitwig.flt.control_surface.proxy.ChannelBankProxy;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotBankProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.CursorDeviceProxy;
import com.bitwig.flt.control_surface.proxy.DeviceCursorRemoteControlsPageProxy;
import com.bitwig.flt.control_surface.proxy.DirectNoteInput;
import com.bitwig.flt.control_surface.proxy.DocumentAction;
import com.bitwig.flt.control_surface.proxy.EffectTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.IndependentDeviceCursorRemoteControlsPageProxy;
import com.bitwig.flt.control_surface.proxy.MainDeviceCursorRemoteControlsPageProxy;
import com.bitwig.flt.control_surface.proxy.MainTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.MasterTrackProxy;
import com.bitwig.flt.control_surface.proxy.SiblingTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.SourceSelectorProxy;
import com.bitwig.flt.control_surface.proxy.TrackBankProxy;
import com.bitwig.flt.control_surface.proxy.TrackProxy$PitchNamesObserver;
import com.bitwig.flt.control_surface.proxy.TracksBankTarget;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.control_surface.values.ComputedStringValue;
import com.bitwig.flt.control_surface.values.EnumValueAtomProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableEnumAttributeProxy;
import com.bitwig.flt.document.core.iface.KcU;
import com.bitwig.flt.document.core.iface.dfU;
import com.bitwig.flt.document.core.iface.lD;
import java.util.ArrayList;
import java.util.List;

public class TrackProxy
extends AbstractChannelProxy
implements Track,
BankItemWithPosition {
    private static final int DEFAULT_MIDI_CHANNEL = 0;
    private static final String DEFAULT_CURSOR_DEVICE_ID = "DeviceSelection";
    private final lC mTrackTypeListener = tmd2 -> this.updateTrackTypeString(this.getChannel());
    private final int mSlotCount;
    private final ComputedStringValue mTrackType;
    protected final SettableBooleanValueProxy mCanHoldNoteData;
    protected final SettableBooleanValueProxy mCanHoldAudioData;
    private final SettableBooleanValueProxy mArm;
    private final SettableEnumAttributeProxy mMonitorModeProxy;
    private final BooleanValueProxy mIsMonitoring;
    private final EnumValueAtomProxy mCrossFadeMode;
    private final BooleanValueProxy mIsMatrixStopped;
    private final BooleanValueProxy mIsMatrixQueuedForStop;
    private final SourceSelectorProxy mSourceSelector;
    private ClipLauncherSlotBankProxy mSlotBank;
    private final ComputedIntegerValue mPosition;
    private TracksBankTarget mBankTargetToUseForPosition;
    private boolean mHasScheduledUpdateToPositionWhenNotInBank;
    private final List mCursorDevices = new ArrayList(3);
    private CursorDeviceProxy mPrimaryDevice;
    private final ComputedBooleanValue mIsGroupValue;
    private final SettableBooleanValueProxy mIsGroupExpandedValue;
    private final SettableBooleanValueProxy mIsPreFader;
    private final W3o mAfterTrackInsertionPoint = new W3o(this);
    private final goq mBeforeTrackInsertionPoint = new goq(this);
    private final List mParentTrackProxies = new ArrayList(1);
    private final List mDirectNoteInputs = new ArrayList();
    private final SettableBooleanValueProxy mLegacyMonitorProxy = new SettableBooleanValueProxy((ControlSurfaceObject)this, false);
    private final SettableBooleanValueProxy mLegacyAutomonitorProxy = new SettableBooleanValueProxy((ControlSurfaceObject)this, false);
    private final SettableEnumAttributeProxy mLaunchQuantizationHelper = new SettableEnumAttributeProxy((ControlSurfaceObject)this, DVC.w2Z);
    private final SettableEnumAttributeProxy mLaunchModeHelper = new SettableEnumAttributeProxy((ControlSurfaceObject)this, tVf.BOK);
    private MainDeviceCursorRemoteControlsPageProxy mMainRemoteControlsSection;
    private List mIndependentRemoteControlsSections;

    public TrackProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3, int n4) {
        super(controlSurfaceObject, string, n2, n3);
        this.mTrackType = new ComputedStringValue(this);
        this.mPosition = new ComputedIntegerValue((ControlSurfaceObject)this, -1);
        this.mArm = new SettableBooleanValueProxy(this);
        this.mMonitorModeProxy = new SettableEnumAttributeProxy((ControlSurfaceObject)this, qvp.BOK);
        this.mIsMonitoring = new BooleanValueProxy(this);
        this.mIsPreFader = new SettableBooleanValueProxy(this);
        this.mCrossFadeMode = new EnumValueAtomProxy((ControlSurfaceObject)this, mKd.BOK);
        this.mIsMatrixStopped = new BooleanValueProxy(this);
        this.mIsMatrixQueuedForStop = new BooleanValueProxy(this);
        this.mCanHoldNoteData = new SettableBooleanValueProxy(this);
        this.mCanHoldAudioData = new SettableBooleanValueProxy(this);
        this.mSourceSelector = new SourceSelectorProxy((ControlSurfaceObject)this, this.getKey() + "/SourceSelector");
        this.mIsGroupValue = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mIsGroupExpandedValue = new SettableBooleanValueProxy(this);
        this.addChild(this.mArm);
        this.addChild(this.mIsMatrixStopped);
        this.addChild(this.mIsMatrixQueuedForStop);
        this.addChild(this.mCanHoldNoteData);
        this.addChild(this.mCanHoldAudioData);
        this.addChild(this.mSourceSelector);
        this.mSlotCount = n4;
        if (n4 > 0) {
            this.mSlotBank = new ClipLauncherSlotBankProxy((ControlSurfaceObject)this, n4);
            this.addChild(this.mSlotBank);
        }
    }

    @Override
    public ComputedIntegerValue getBankItemPosition() {
        return this.mPosition;
    }

    @Override
    public Class getTargetType() {
        return dfU.class;
    }

    protected KcU getDocumentFromTarget(dfU dfU2) {
        return dfU2.PTW();
    }

    protected PQ getEditorChannelSelection(dfU dfU2) {
        KcU kcU = dfU2.PTW();
        if (kcU != null) {
            return kcU.OLz().bsM();
        }
        return null;
    }

    @Override
    protected String getAutomaticNotificationPrefix() {
        return "Track";
    }

    @Override
    public IntegerValue position() {
        this.newSince(2);
        return this.mPosition;
    }

    @Override
    public void addPositionObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use position() instead");
        this.mPosition.addValueObserver(integerValueChangedCallback);
    }

    @Override
    public ClipLauncherSlotBankProxy getClipLauncher() {
        this.deprecated(1, 2);
        return this.getClipLauncherSlots();
    }

    @Override
    public ClipLauncherSlotBankProxy getClipLauncherSlots() {
        return this.mSlotBank;
    }

    public int getSlotCount() {
        return this.mSlotCount;
    }

    @Override
    public ClipLauncherSlotBankProxy clipLauncherSlotBank() {
        return this.mSlotBank;
    }

    @Override
    public SettableBooleanValue getArm() {
        this.deprecated(1, 5, "Use arm() instead");
        return this.mArm;
    }

    @Override
    public SettableBooleanValue arm() {
        this.newSince(5);
        return this.mArm;
    }

    @Override
    public SettableBooleanValue getMonitor() {
        this.deprecated(1, 5, "Use monitor() instead");
        return this.mLegacyMonitorProxy;
    }

    @Override
    public SettableBooleanValue monitor() {
        this.deprecated(5, 14, "Use isMonitoring or monitorMode instead");
        return this.mLegacyMonitorProxy;
    }

    @Override
    public SettableBooleanValue getAutoMonitor() {
        this.deprecated(1, 14, "Use monitorMode instead");
        return this.mLegacyAutomonitorProxy;
    }

    @Override
    public SettableBooleanValue autoMonitor() {
        this.deprecated(5, 14, "Use monitorMode instead");
        return this.mLegacyAutomonitorProxy;
    }

    @Override
    public SettableEnumValue monitorMode() {
        this.newSince(14);
        return this.mMonitorModeProxy;
    }

    @Override
    public BooleanValue isMonitoring() {
        this.newSince(14);
        return this.mIsMonitoring;
    }

    @Override
    public SettableEnumValue getCrossFadeMode() {
        this.deprecated(1, 5, "Use crossFadeMode() instead");
        return this.mCrossFadeMode;
    }

    @Override
    public SettableEnumValue crossFadeMode() {
        this.newSince(5);
        return this.mCrossFadeMode;
    }

    @Override
    public BooleanValue isStopped() {
        this.newSince(2);
        return this.mIsMatrixStopped;
    }

    @Override
    public BooleanValue getIsMatrixStopped() {
        this.deprecated(1, 2, "Use isStopped() instead");
        return this.mIsMatrixStopped;
    }

    @Override
    public BooleanValue isQueuedForStop() {
        this.newSince(2);
        return this.mIsMatrixQueuedForStop;
    }

    @Override
    public BooleanValue getIsMatrixQueuedForStop() {
        this.deprecated(1, 2, "Use isQueuedForStop() instead");
        return this.mIsMatrixQueuedForStop;
    }

    @Override
    public SourceSelector getSourceSelector() {
        this.deprecated(1, 5, "Use sourceSelector() instead");
        return this.mSourceSelector;
    }

    @Override
    public SourceSelector sourceSelector() {
        this.newSince(5);
        return this.mSourceSelector;
    }

    @Override
    public void stop() {
        this.exec(() -> this.doStop(false));
    }

    @Override
    public void stopAlt() {
        this.newSince(18);
        this.exec(() -> this.doStop(true));
    }

    private void doStop(boolean bl2) {
        dfU dfU2 = this.getChannel();
        if (dfU2 != null) {
            dfU2.w2Z(DVC.w2Z, bl2);
        }
    }

    @Override
    public HardwareActionBindable stopAction() {
        this.newSince(10);
        return new DocumentAction((ControlSurfaceObject)this, () -> this.doStop(false));
    }

    @Override
    public HardwareActionBindable stopAltAction() {
        this.newSince(18);
        return new DocumentAction((ControlSurfaceObject)this, () -> this.doStop(true));
    }

    @Override
    public void returnToArrangement() {
        this.exec(() -> {
            dfU dfU2 = this.getChannel();
            if (dfU2 != null) {
                dfU2.JYy();
            }
        });
    }

    @Override
    public void playNote(int n2, int n3) {
        if (n2 >= 0 && n2 < 128 && n3 >= 0 && n3 < 128) {
            this.exec(() -> {
                if (this.getChannel() instanceof NgE) {
                    NgE ngE = (NgE)this.getTarget();
                    ngE.FpH().w2Z(0, n2, syt.w2Z(n3), 0.5f, 100L);
                }
            });
        }
    }

    @Override
    public void startNote(int n2, int n3) {
        if (n2 >= 0 && n2 < 128 && n3 >= 0 && n3 < 128) {
            this.exec(() -> {
                if (this.getTarget() instanceof NgE) {
                    NgE ngE = (NgE)this.getTarget();
                    ngE.FpH().w2Z(0, n2, syt.w2Z(n3));
                }
            });
        }
    }

    @Override
    public void stopNote(int n2, int n3) {
        if (n2 >= 0 && n2 < 128 && n3 >= 0 && n3 < 128) {
            this.exec(() -> {
                if (this.getTarget() instanceof NgE) {
                    NgE ngE = (NgE)this.getTarget();
                    ngE.FpH().BOK(0, n2, syt.w2Z(n3));
                }
            });
        }
    }

    @Override
    public void sendMidi(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 127 || n3 < 0 || n3 > 127 || n4 < 0 || n4 > 127) {
            this.exec(() -> {
                if (!(this.getTarget() instanceof NgE)) {
                    return;
                }
                NgE ngE = (NgE)this.getTarget();
                ngE.FpH().w2Z(n2, n3, n4);
            });
        }
    }

    @Override
    public CursorDevice createCursorDevice() {
        this.checkIsInitializingDriver();
        return this.createCursorDevice(DEFAULT_CURSOR_DEVICE_ID, this.getNumSends());
    }

    @Deprecated
    public CursorDevice createEditorDeviceSelection(boolean bl2) {
        return this.createCursorDevice();
    }

    protected void connectToTarget(dfU dfU2) {
        Object object2;
        super.connectToTarget(dfU2);
        NgE ngE = dfU2.JEB();
        assert (this.bsM(ngE != null));
        assert (this.rLM(this.mBankTargetToUseForPosition == null));
        this.updateParentTrackProxiesTarget(dfU2);
        for (Object object2 : this.mCursorDevices) {
            ((ControlSurfaceProxy)object2).setTarget(ngE);
        }
        this.updateTrackTypeString(dfU2);
        boolean bl2 = dfU2 instanceof lD;
        this.mIsGroupValue.setBoolValue(bl2);
        if (bl2) {
            object2 = (lD)dfU2;
            this.mIsGroupExpandedValue.setTarget(object2.k1w().bsM());
        } else {
            this.mIsGroupExpandedValue.clearTarget();
        }
        this.mArm.setTarget(ngE.dMX());
        this.mMonitorModeProxy.setTarget(ngE.GW1());
        this.mIsMonitoring.setTarget(ngE.k1w());
        this.mIsPreFader.setTarget(ngE.KAO());
        this.mCrossFadeMode.setTarget(ngE.eN1().rLM());
        this.mIsMatrixStopped.setTarget(dfU2.DYI());
        this.mIsMatrixQueuedForStop.setTarget(dfU2.tZS());
        this.mCanHoldNoteData.setTarget(ngE.xdL());
        this.mCanHoldAudioData.setTarget(ngE.wiI());
        this.mSourceSelector.setTarget(ngE.vlq());
        if (this.mSlotBank != null) {
            this.mSlotBank.setTarget(dfU2);
        }
        this.addAllNoteSources();
        ngE.zxv(this.mTrackTypeListener);
        for (ControlSurfaceObject controlSurfaceObject : this.getChildren()) {
            ControlSurfaceDocumentObjectProxy controlSurfaceDocumentObjectProxy;
            if (controlSurfaceObject instanceof SiblingTrackBankProxy) {
                SiblingTrackBankProxy siblingTrackBankProxy = (SiblingTrackBankProxy)controlSurfaceObject;
                siblingTrackBankProxy.setTrackOrGroup(dfU2);
                continue;
            }
            if (!bl2) continue;
            lD lD2 = (lD)dfU2;
            if (controlSurfaceObject instanceof TrackProxy) {
                controlSurfaceDocumentObjectProxy = (TrackProxy)controlSurfaceObject;
                controlSurfaceDocumentObjectProxy.setTarget(lD2.TNL());
                continue;
            }
            if (!(controlSurfaceObject instanceof AbstractTrackBankProxy)) continue;
            controlSurfaceDocumentObjectProxy = (AbstractTrackBankProxy)controlSurfaceObject;
            ((ChannelBankProxy)controlSurfaceDocumentObjectProxy).setTarget(lD2);
        }
        if (!this.isInBank()) {
            object2 = dfU2.tBx();
            assert (this.rLM(this.mBankTargetToUseForPosition == null));
            if (object2 != null) {
                this.mBankTargetToUseForPosition = new TracksBankTarget((lD)object2, true, true, true, false);
                this.mBankTargetToUseForPosition.setItemsChangedListener(this::scheduleUpdatePositionWhenNotInBank);
                this.updatePositionWhenNotInBank();
            } else {
                this.mPosition.setIntegerValue(-1);
            }
        }
        this.setRemoteControls(dfU2.DH3().UN3());
    }

    private void updateParentTrackProxiesTarget(dfU dfU2) {
        lD lD2 = dfU2 != null ? dfU2.tBx() : null;
        for (TrackProxy trackProxy : this.mParentTrackProxies) {
            trackProxy.setTarget(lD2);
        }
    }

    public void disconnectFromTarget(dfU dfU2) {
        super.disconnectFromTarget(dfU2);
        this.removeAllNoteSources();
        this.updateParentTrackProxiesTarget(null);
        for (Object object : this.getChildren()) {
            if (!(object instanceof ControlSurfaceProxy)) continue;
            ((ControlSurfaceProxy)object).clearTarget();
        }
        this.mIsGroupValue.setBoolValue(false);
        this.mIsGroupExpandedValue.clearTarget();
        NgE ngE = dfU2.JEB();
        assert (this.bsM(ngE != null));
        ngE.Bh1(this.mTrackTypeListener);
        this.mArm.clearTarget();
        this.mMonitorModeProxy.clearTarget();
        this.mIsMonitoring.clearTarget();
        this.mIsPreFader.clearTarget();
        this.mCrossFadeMode.clearTarget();
        this.mIsMatrixStopped.clearTarget();
        this.mIsMatrixQueuedForStop.clearTarget();
        this.mCanHoldNoteData.clearTarget();
        this.mCanHoldAudioData.clearTarget();
        this.mSourceSelector.clearTarget();
        for (CursorDeviceProxy cursorDeviceProxy : this.mCursorDevices) {
            cursorDeviceProxy.clearTarget();
        }
        if (this.mSlotBank != null) {
            this.mSlotBank.clearTarget();
        }
        this.updateTrackTypeString(null);
        if (this.mBankTargetToUseForPosition != null) {
            this.mBankTargetToUseForPosition.setItemsChangedListener(null);
            this.mBankTargetToUseForPosition = null;
        }
        this.mPosition.setIntegerValue(-1);
        this.setRemoteControls(null);
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        dfU dfU2 = (dfU)this.getTarget();
        for (ControlSurfaceObject controlSurfaceObject : this.getChildren()) {
            if (!(controlSurfaceObject instanceof SiblingTrackBankProxy)) continue;
            SiblingTrackBankProxy siblingTrackBankProxy = (SiblingTrackBankProxy)controlSurfaceObject;
            siblingTrackBankProxy.setTrackOrGroup(dfU2);
        }
    }

    @Override
    protected void connectObservers(Object object) {
        NgE ngE;
        super.connectObservers(object);
        NgE ngE2 = ngE = object instanceof NgE ? (NgE)object : null;
        if (ngE != null) {
            for (erh erh2 : this.getObservers()) {
                if (!(erh2 instanceof TrackProxy$PitchNamesObserver)) continue;
                ngE.nwv().w2Z((TrackProxy$PitchNamesObserver)erh2);
            }
        }
    }

    @Override
    protected void disconnectObservers(Object object) {
        NgE ngE;
        super.disconnectObservers(object);
        NgE ngE2 = ngE = object instanceof NgE ? (NgE)object : null;
        if (ngE != null) {
            for (erh erh2 : this.getObservers()) {
                if (!(erh2 instanceof TrackProxy$PitchNamesObserver)) continue;
                ngE.nwv().BOK((TrackProxy$PitchNamesObserver)erh2);
            }
        }
    }

    private void updateTrackTypeString(dfU dfU2) {
        if (dfU2 instanceof lD) {
            this.mTrackType.setValue("Group");
        } else if (dfU2 instanceof NgE) {
            NgE ngE = (NgE)dfU2;
            if (ngE.Gc1()) {
                switch (ngE.UN3()) {
                    case w2Z: {
                        this.mTrackType.setValue("Instrument");
                        break;
                    }
                    case BOK: {
                        this.mTrackType.setValue("Audio");
                        break;
                    }
                    case HaN: {
                        this.mTrackType.setValue("Hybrid");
                    }
                }
            } else if (ngE.mzu()) {
                this.mTrackType.setValue("Effect");
            } else if (ngE.U3m()) {
                this.mTrackType.setValue("Master");
            }
        } else {
            this.mTrackType.setValue("");
        }
    }

    @Override
    public void setName(String string) {
        this.exec(() -> {
            if (this.getTarget() instanceof NgE) {
                ((dfU)this.getTarget()).e_(string);
            }
        });
    }

    @Override
    public SettableBooleanValue getCanHoldNoteData() {
        this.deprecated(1, 5, "Use canHoldNoteData() instead");
        return this.mCanHoldNoteData;
    }

    @Override
    public SettableBooleanValue canHoldNoteData() {
        this.newSince(5);
        return this.mCanHoldNoteData;
    }

    @Override
    public SettableBooleanValue getCanHoldAudioData() {
        this.deprecated(1, 5, "Use canHoldAudioData() instead");
        return this.mCanHoldAudioData;
    }

    @Override
    public SettableBooleanValue canHoldAudioData() {
        this.newSince(5);
        return this.mCanHoldAudioData;
    }

    @Override
    public void addPitchNamesObserver(IndexedStringValueChangedCallback indexedStringValueChangedCallback) {
        this.addObserver(new TrackProxy$PitchNamesObserver(this.getControlSurface(), indexedStringValueChangedCallback));
    }

    @Override
    public StringValue trackType() {
        this.newSince(2);
        return this.mTrackType;
    }

    @Override
    public void addTrackTypeObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.deprecated(1, 2, "Use trackType() instead");
        this.mTrackType.addValueObserver(n2, string, stringValueChangedCallback);
    }

    @Override
    public BooleanValue isGroup() {
        this.newSince(2);
        return this.mIsGroupValue;
    }

    @Override
    public SettableBooleanValue isGroupExpanded() {
        this.newSince(15);
        return this.mIsGroupExpandedValue;
    }

    @Override
    public SettableBooleanValue getIsPreFader() {
        this.newSince(10);
        return this.mIsPreFader;
    }

    @Override
    public void addIsGroupObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use isGroup() instead");
        this.mIsGroupValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addIsQueuedForStopObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use isQueuedForStop() instead");
        this.mIsMatrixQueuedForStop.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    protected dfU getChannel() {
        return (dfU)super.getChannel();
    }

    @Override
    public CursorDevice createCursorDevice(String string) {
        return this.createCursorDevice(string, this.getNumSends());
    }

    @Override
    public CursorDevice createCursorDevice(String string, int n2) {
        String string2 = string == null || string.isEmpty() ? DEFAULT_CURSOR_DEVICE_ID : string;
        assert (this.rLM(this.getKey() != null));
        assert (this.rLM(!this.getKey().isEmpty()));
        CursorDeviceProxy cursorDeviceProxy = CursorDeviceProxy.create(this, this.getKey() + "/" + string2, n2);
        this.mCursorDevices.add(cursorDeviceProxy);
        return cursorDeviceProxy;
    }

    @Deprecated
    public CursorDevice createDeviceSelection(String string, boolean bl2) {
        return this.createCursorDevice(string);
    }

    protected String getChannelSelectionName() {
        return null;
    }

    @Override
    @Deprecated
    public Device getPrimaryInstrument() {
        this.deprecated(1, 2);
        return this.getPrimaryDevice();
    }

    @Override
    public Device getPrimaryDevice() {
        this.deprecatedFail(1, 2, "Use createCursorDevice instead");
        this.checkIsInitializingDriver();
        if (this.mPrimaryDevice == null) {
            this.mPrimaryDevice = CursorDeviceProxy.create(this, this.getKey() + " / Primary Device", this.getNumSends());
            this.mCursorDevices.add(this.mPrimaryDevice);
        }
        assert (this.rLM(this.mPrimaryDevice != null));
        return this.mPrimaryDevice;
    }

    @Override
    public AbstractTrackBankProxy createTrackBank(int n2, int n3, int n4, boolean bl2) {
        TrackBankProxy trackBankProxy = new TrackBankProxy(this, "TrackBank", n2, n3, n4, bl2);
        this.addChild(trackBankProxy);
        return trackBankProxy;
    }

    @Override
    public AbstractTrackBankProxy createMainTrackBank(int n2, int n3, int n4, boolean bl2) {
        MainTrackBankProxy mainTrackBankProxy = new MainTrackBankProxy(this, "MainTrackBank", n2, n3, n4, bl2);
        this.addChild(mainTrackBankProxy);
        return mainTrackBankProxy;
    }

    @Override
    public AbstractTrackBankProxy createEffectTrackBank(int n2, int n3, boolean bl2) {
        EffectTrackBankProxy effectTrackBankProxy = new EffectTrackBankProxy(this, "EffectTrackBank", n2, n3, bl2);
        this.addChild(effectTrackBankProxy);
        return effectTrackBankProxy;
    }

    @Override
    public TrackBank createEffectTrackBank(int n2, int n3, int n4, boolean bl2) {
        EffectTrackBankProxy effectTrackBankProxy = new EffectTrackBankProxy(this, "EffectTrackBank", n2, n3, n4, bl2);
        this.addChild(effectTrackBankProxy);
        return effectTrackBankProxy;
    }

    @Override
    public MasterTrackProxy createMasterTrack(int n2) {
        MasterTrackProxy masterTrackProxy = new MasterTrackProxy((ControlSurfaceObject)this, n2);
        this.addChild(masterTrackProxy);
        return masterTrackProxy;
    }

    @Override
    public TrackBank createSiblingsTrackBank(int n2, int n3, int n4, boolean bl2, boolean bl3) {
        SiblingTrackBankProxy siblingTrackBankProxy = new SiblingTrackBankProxy(this, "SiblingTrackBank", n2, n3, n4, bl2, bl3);
        this.addChild(siblingTrackBankProxy);
        return siblingTrackBankProxy;
    }

    @Override
    public InsertionPoint afterTrackInsertionPoint() {
        return this.mAfterTrackInsertionPoint;
    }

    @Override
    public InsertionPoint beforeTrackInsertionPoint() {
        return this.mBeforeTrackInsertionPoint;
    }

    public cxq createNotificationWidget() {
        Object object;
        assert (this.w2Z(this.isDocumentThread()));
        cYC cYC2 = cYC.rLM(12);
        cwE cwE2 = cwE.bsM(this.getName());
        cwE2.UN3(0.5f);
        cwE2.w2Z((dlT)cwE2.gK_().ZTj().jEl());
        cYC2.i2U(cwE2);
        if (this.mCursorDevices != null) {
            for (CursorDeviceProxy cursorDeviceProxy : this.mCursorDevices) {
                cxq cxq2 = cursorDeviceProxy.createNotificationWidget();
                cYC2.i2U(cxq2);
            }
        }
        if (this.mSendBankProxy != null) {
            object = this.mSendBankProxy.createNotificationWidget();
            cYC2.i2U((cxq)object);
        }
        if (this.mPan.shouldIndicate()) {
            object = this.mPan.createVisualizationWidget();
            cYC2.i2U((cxq)object);
        }
        if (this.mVolume.shouldIndicate()) {
            object = this.mVolume.createVisualizationWidget();
            cYC2.i2U((cxq)object);
        }
        return cYC2;
    }

    @Override
    public Track createParentTrack(int n2, int n3) {
        this.newSince(10);
        TrackProxy trackProxy = new TrackProxy(this, this.getKey() + "/parent", -1, n2, n3);
        this.addChild(trackProxy);
        this.mParentTrackProxies.add(trackProxy);
        return trackProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNoteSource(NoteInput noteInput) {
        this.newSince(10);
        this.notNull(noteInput, "noteInput");
        DirectNoteInput directNoteInput = (DirectNoteInput)noteInput;
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            if (this.mDirectNoteInputs.contains(directNoteInput)) {
                return;
            }
            this.mDirectNoteInputs.add(directNoteInput);
        }
        this.exec(() -> this.doAddNoteSource(directNoteInput));
    }

    private void doAddNoteSource(DirectNoteInput directNoteInput) {
        assert (this.w2Z(this.isDocumentThread()));
        dfU dfU2 = (dfU)this.getTarget();
        if (dfU2 == null) {
            return;
        }
        NgE ngE = dfU2.JEB();
        HCe hCe = ngE.Euc();
        sIe sIe2 = directNoteInput.getNoteSource();
        assert (this.w2Z(sIe2 != null));
        if (sIe2 != null && !hCe.KyJ().contains(sIe2)) {
            hCe.w2Z(sIe2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNoteSource(NoteInput noteInput) {
        this.newSince(10);
        this.notNull(noteInput, "noteInput");
        DirectNoteInput directNoteInput = (DirectNoteInput)noteInput;
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            if (!this.mDirectNoteInputs.contains(directNoteInput)) {
                return;
            }
            this.mDirectNoteInputs.remove(directNoteInput);
        }
        this.exec(() -> this.doRemoveNoteSource(directNoteInput));
    }

    private void doRemoveNoteSource(DirectNoteInput directNoteInput) {
        assert (this.w2Z(this.isDocumentThread()));
        dfU dfU2 = (dfU)this.getTarget();
        if (dfU2 == null) {
            return;
        }
        NgE ngE = dfU2.JEB();
        HCe hCe = ngE.Euc();
        sIe sIe2 = directNoteInput.getNoteSource();
        assert (this.w2Z(sIe2 != null));
        if (sIe2 != null && hCe.KyJ().contains(sIe2)) {
            hCe.BOK(sIe2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllNoteSources() {
        assert (this.w2Z(this.isDocumentThread()));
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            for (DirectNoteInput directNoteInput : this.mDirectNoteInputs) {
                this.doRemoveNoteSource(directNoteInput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllNoteSources() {
        assert (this.w2Z(this.isDocumentThread()));
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            for (DirectNoteInput directNoteInput : this.mDirectNoteInputs) {
                this.doAddNoteSource(directNoteInput);
            }
        }
    }

    @Override
    public void selectSlot(int n2) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.exec(() -> this.doSelectSlot(n2));
    }

    private void doSelectSlot(int n2) {
        assert (this.w2Z(this.isDocumentThread()));
        dfU dfU2 = (dfU)this.getTarget();
        if (dfU2 == null) {
            return;
        }
        if (n2 >= dfU2.JAw()) {
            return;
        }
        Sc sc2 = this.getDocumentGUIWrapper();
        if (sc2 == null) {
            return;
        }
        axm axm2 = sc2.Pgb();
        axm2.bsM(dfU2.UN3(n2));
        axm2.OyU();
    }

    @Override
    public void launchLastClipWithOptions(String string, String string2) {
        this.newSince(16);
        DVC dVC2 = (DVC)this.mLaunchQuantizationHelper.validateValueFromController(string);
        tVf tVf2 = (tVf)this.mLaunchModeHelper.validateValueFromController(string2);
        this.exec(() -> this.doLaunchLastClipWithOptions(dVC2, tVf2));
    }

    @Override
    public HardwareActionBindable launchLastClipWithOptionsAction(String string, String string2) {
        this.newSince(16);
        DVC dVC2 = (DVC)this.mLaunchQuantizationHelper.validateValueFromController(string);
        tVf tVf2 = (tVf)this.mLaunchModeHelper.validateValueFromController(string2);
        return new DocumentAction((ControlSurfaceObject)this, () -> this.doLaunchLastClipWithOptions(dVC2, tVf2));
    }

    @Override
    public CursorRemoteControlsPage createCursorRemoteControlsPage(int n2) {
        this.newSince(18);
        this.checkIsInitializingDriver();
        if (this.mMainRemoteControlsSection != null) {
            throw new VEr("Can only create one set of main remote controls that follow the selection");
        }
        assert (this.rLM(this.isControlSurfaceThread()));
        assert (this.rLM(this.isInitializingDriver()));
        this.mMainRemoteControlsSection = new MainDeviceCursorRemoteControlsPageProxy(this, this.getKey() + "/RemoteControls/Parameter", n2);
        return this.mMainRemoteControlsSection;
    }

    @Override
    public CursorRemoteControlsPage createCursorRemoteControlsPage(String string, int n2, String string2) {
        String string3;
        this.newSince(18);
        this.checkIsInitializingDriver();
        String string4 = string3 = string2 != null ? string2 : "";
        assert (this.rLM(this.isControlSurfaceThread()));
        assert (this.rLM(this.isInitializingDriver()));
        if (string == null || string.isEmpty()) {
            throw new VEr("Name must be provided");
        }
        if (n2 < 1) {
            throw new VEr("parameterCount must be >= 1");
        }
        int n3 = 0;
        if (this.mIndependentRemoteControlsSections == null) {
            this.mIndependentRemoteControlsSections = new ArrayList(2);
        } else {
            for (IndependentDeviceCursorRemoteControlsPageProxy independentDeviceCursorRemoteControlsPageProxy : this.mIndependentRemoteControlsSections) {
                if (!independentDeviceCursorRemoteControlsPageProxy.getFilter().equals(string3)) continue;
                ++n3;
            }
        }
        IndependentDeviceCursorRemoteControlsPageProxy independentDeviceCursorRemoteControlsPageProxy = new IndependentDeviceCursorRemoteControlsPageProxy(this, this.getKey() + "/RemoteControls/" + string + "/Parameter", n2, string3, n3);
        this.mIndependentRemoteControlsSections.add(independentDeviceCursorRemoteControlsPageProxy);
        return independentDeviceCursorRemoteControlsPageProxy;
    }

    private void doLaunchLastClipWithOptions(DVC dVC2, tVf tVf2) {
        assert (this.w2Z(this.isDocumentThread()));
        dfU dfU2 = (dfU)this.getTarget();
        if (dfU2 == null) {
            return;
        }
        dfU2.w2Z(true, dVC2, tVf2);
    }

    @Override
    public void recordNewLauncherClip(int n2) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.exec(() -> this.doRecordNewLauncherClip(n2, true));
    }

    int doRecordNewLauncherClip(int n2, boolean bl2) {
        assert (this.w2Z(this.isDocumentThread()));
        dfU dfU2 = (dfU)this.getTarget();
        if (dfU2 == null) {
            return -1;
        }
        this.ensureSceneCount(n2);
        ClJ clJ2 = this.findOrCreateFreeSlot(n2);
        if (!(clJ2 instanceof QjN)) {
            return -1;
        }
        dfU2.JEB().BOK(true);
        QjN qjN = (QjN)clJ2;
        qjN.X3Z();
        qjN.w2Z(true, false);
        if (bl2) {
            int n3 = qjN.i2U();
            this.doSelectSlot(n3);
        }
        return qjN.i2U();
    }

    @Override
    public void createNewLauncherClip(int n2, int n3) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.atLeast(n3, 1, "lengthInBeats");
        this.exec(() -> this.doCreateNewLauncherClip(n2, n3, true));
    }

    @Override
    public void createNewLauncherClip(int n2) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.exec(() -> this.doCreateNewLauncherClip(n2, -1, true));
    }

    UwT doCreateNewLauncherClip(int n2, int n3, boolean bl2) {
        assert (this.w2Z(this.isDocumentThread()));
        dfU dfU2 = (dfU)this.getTarget();
        if (dfU2 == null) {
            return null;
        }
        this.ensureSceneCount(n2);
        ClJ clJ2 = this.findOrCreateFreeSlot(n2);
        if (!(clJ2 instanceof QjN)) {
            return null;
        }
        QjN qjN = (QjN)clJ2;
        if (n3 > 0) {
            qjN.w2Z(n3);
        } else {
            qjN.gFf();
        }
        if (bl2) {
            int n4 = qjN.i2U();
            this.doSelectSlot(n4);
        }
        return qjN.bsM();
    }

    private ClJ findOrCreateFreeSlot(int n2) {
        dfU dfU2 = (dfU)this.getTarget();
        assert (this.w2Z(dfU2 != null));
        int n3 = dfU2.JAw();
        for (int i2 = n2; i2 < n3; ++i2) {
            ClJ clJ2 = dfU2.UN3(i2);
            if (!clJ2.agk()) continue;
            return clJ2;
        }
        lD lD2 = this.getDocument().Xeo();
        lD2.HaN(n3, null);
        return dfU2.UN3(n3);
    }

    private void ensureSceneCount(int n2) {
        dfU dfU2 = (dfU)this.getTarget();
        assert (this.w2Z(dfU2 != null));
        int n3 = dfU2.JAw();
        if (n3 < n2) {
            KcU kcU = this.getDocument();
            lD lD2 = kcU.Xeo();
            for (int i2 = n3; i2 < n2; ++i2) {
                lD2.HaN(i2, null);
            }
        }
    }

    public boolean isInBank() {
        return false;
    }

    private void scheduleUpdatePositionWhenNotInBank() {
        assert (this.rLM(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateToPositionWhenNotInBank) {
            this.mHasScheduledUpdateToPositionWhenNotInBank = true;
            this.runAtEndOfEvent(this::updatePositionWhenNotInBank);
        }
    }

    private void updatePositionWhenNotInBank() {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(!this.isInBank()));
        this.mHasScheduledUpdateToPositionWhenNotInBank = false;
        int n2 = -1;
        if (this.mBankTargetToUseForPosition != null) {
            dfU dfU2 = (dfU)this.getTarget();
            assert (this.rLM(dfU2 != null));
            if (dfU2 != null) {
                List list = this.mBankTargetToUseForPosition.listItems();
                n2 = list.indexOf(dfU2);
            }
        }
        this.mPosition.setIntegerValue(n2);
    }

    private void setRemoteControls(amO amO2) {
        if (this.mMainRemoteControlsSection != null) {
            this.mMainRemoteControlsSection.setTarget(amO2);
        }
        if (this.mIndependentRemoteControlsSections != null) {
            for (DeviceCursorRemoteControlsPageProxy deviceCursorRemoteControlsPageProxy : this.mIndependentRemoteControlsSections) {
                deviceCursorRemoteControlsPageProxy.setTarget(amO2);
            }
        }
    }
}

