/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.UsbInterfaceMatcher;
import com.bitwig.extension.controller.api.UsbInterface;
import com.bitwig.extension.controller.api.UsbPipe;
import com.bitwig.flt.control_surface.proxy.UsbBulkInputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbBulkOutputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbDeviceImpl;
import com.bitwig.flt.control_surface.proxy.UsbInterruptInputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbInterruptOutputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbPipeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UsbInterfaceImpl
implements UsbInterface {
    private final UsbDeviceImpl mDevice;
    private cmu mClaimedInterface;
    private final KB3 mMatchResult;
    private final List mPipes;

    UsbInterfaceImpl(UsbDeviceImpl usbDeviceImpl, KB3 kB3) {
        this.mDevice = usbDeviceImpl;
        this.mMatchResult = kB3;
        this.mPipes = new ArrayList(kB3.HaN().size());
        for (FWI fWI : kB3.HaN()) {
            UsbPipeImpl usbPipeImpl = UsbInterfaceImpl.createUsbPipe(usbDeviceImpl, fWI);
            this.mPipes.add(usbPipeImpl);
        }
    }

    private static UsbPipeImpl createUsbPipe(UsbDeviceImpl usbDeviceImpl, FWI fWI) {
        cmB cmB2 = fWI.w2Z().w2Z();
        boolean bl2 = fWI.w2Z().BOK();
        switch (cmB2) {
            case HaN: {
                return bl2 ? new UsbBulkOutputPipeImpl(usbDeviceImpl, fWI) : new UsbBulkInputPipeImpl(usbDeviceImpl, fWI);
            }
            case rLM: {
                return bl2 ? new UsbInterruptOutputPipeImpl(usbDeviceImpl, fWI) : new UsbInterruptInputPipeImpl(usbDeviceImpl, fWI);
            }
        }
        throw new IllegalStateException("Unknown matcher transfer type " + String.valueOf((Object)cmB2));
    }

    @Override
    public UsbInterfaceMatcher interfaceMatcher() {
        return this.mMatchResult.BOK();
    }

    @Override
    public List pipes() {
        return Collections.unmodifiableList(this.mPipes);
    }

    @Override
    public UsbPipe pipe(int n2) {
        return (UsbPipe)this.mPipes.get(n2);
    }

    @Override
    public int pipeCount() {
        return this.mPipes.size();
    }

    void claim() {
        this.mClaimedInterface = this.mDevice.getDeviceHandle().BOK(this.mMatchResult.w2Z().HaN);
    }

    void release() {
        if (this.mClaimedInterface != null) {
            this.mClaimedInterface.w2Z();
            this.mClaimedInterface = null;
        }
    }
}

