/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.api.Color;
import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.prefs.gCH;
import com.bitwig.ramona.core.vE;

public class ColorSetting
extends SettableColorValueProxy
implements Setting {
    private final String mLabel;
    private final String mCategory;
    private XF mIsEnabled;
    private XF mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private vE mSetting;

    public ColorSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, Color color) {
        super(controlSurfaceObject, (float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(MOM mOM) {
        assert (this.w2Z(this.isDocumentThread()));
        assert (this.w2Z(mOM != null));
        assert (this.w2Z(this.mSetting == null));
        this.mSetting = mOM;
        this.setTarget(mOM.w2Z());
        this.connectEnableAndVisibleValues(mOM.zxv(), mOM.Bh1());
    }

    public void disconnectFromSetting(MOM mOM) {
        assert (this.w2Z(this.isDocumentThread()));
        assert (this.w2Z(mOM != null));
        assert (this.w2Z(this.mSetting == mOM));
        this.disconnectEnableAndVisibleValues(mOM.zxv(), mOM.Bh1());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(pZ pZ2) {
        assert (this.w2Z(this.isDocumentThread()));
        assert (this.w2Z(pZ2 != null));
        assert (this.w2Z(this.mSetting == null));
        this.mSetting = pZ2;
        this.setTarget(pZ2.zxv());
        this.connectEnableAndVisibleValues(pZ2.IL(), pZ2.SUJ());
    }

    public void disconnectFromSetting(gCH gCH2) {
        assert (this.w2Z(this.isDocumentThread()));
        assert (this.w2Z(gCH2 != null));
        assert (this.w2Z(this.mSetting == gCH2));
        this.disconnectEnableAndVisibleValues(gCH2.IL(), gCH2.SUJ());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(XF xF2, XF xF3) {
        this.mIsEnabled = xF2;
        this.mIsVisible = xF3;
    }

    private void disconnectEnableAndVisibleValues(XF xF2, XF xF3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (this.w2Z(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public vE getSetting() {
        return this.mSetting;
    }
}

