/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.controller.api.ColorValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;

public class ComputedColorValue
extends ComputedValue
implements ColorValue {
    private Pu mValue;
    private Pu mDocumentValue;

    public ComputedColorValue(ControlSurfaceObject controlSurfaceObject, Pu pu2) {
        super(controlSurfaceObject);
        this.mValue = pu2;
        this.mDocumentValue = pu2;
    }

    @Override
    public float red() {
        assert (this.w2Z(this.isControlSurfaceThread()));
        return this.mValue.rLM();
    }

    @Override
    public float green() {
        assert (this.w2Z(this.isControlSurfaceThread()));
        return this.mValue.bsM();
    }

    @Override
    public float blue() {
        assert (this.w2Z(this.isControlSurfaceThread()));
        return this.mValue.KyJ();
    }

    @Override
    public float alpha() {
        assert (this.w2Z(this.isControlSurfaceThread()));
        this.newSince(5);
        return this.mValue.UN3();
    }

    public Pu getValue() {
        assert (this.w2Z(this.isDocumentThread()));
        return this.mDocumentValue;
    }

    public void setValue(Pu pu2) {
        assert (this.w2Z(this.isDocumentThread()));
        if (!pu2.w2Z(this.mDocumentValue)) {
            this.mDocumentValue = pu2;
            if (this.isInterested()) {
                this.queueNotifyObservers(pu2);
            }
        }
    }

    public void addValueObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.doAddValueObserver(colorValueChangedCallback);
    }

    protected void sendInitialValue(ColorValueChangedCallback colorValueChangedCallback) {
        colorValueChangedCallback.valueChanged(this.mValue.rLM(), this.mValue.bsM(), this.mValue.KyJ());
    }

    private void queueNotifyObservers(Pu pu2) {
        assert (this.w2Z(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(pu2));
    }

    private void notifyObservers(Pu pu2) {
        assert (this.w2Z(this.isControlSurfaceThread()));
        assert (this.w2Z(this.isInterested()));
        if (!pu2.w2Z(this.mValue)) {
            this.mValue = pu2;
            if (this.mObservers != null) {
                for (ColorValueChangedCallback colorValueChangedCallback : this.mObservers) {
                    colorValueChangedCallback.valueChanged(pu2.rLM(), pu2.bsM(), pu2.KyJ());
                }
            }
        }
    }
}

