/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;

public class ComputedStringValue
extends ComputedValue
implements StringValue {
    private bkO mValue;
    private bkO mDocumentValue;
    private final bkO mDefaultValue;

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject, bkO bkO2) {
        super(controlSurfaceObject);
        assert (this.rLM(bkO2 != null));
        this.mValue = bkO2;
        this.mDocumentValue = bkO2;
        this.mDefaultValue = bkO2;
    }

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, bkO.EMPTY);
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        return this.mValue.getLimited(n2);
    }

    public String getValue() {
        assert (this.rLM(this.isDocumentThread()));
        return this.mDocumentValue.get();
    }

    public void setValue(bkO bkO2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(bkO2 != null));
        if (!bkO2.equals(this.mDocumentValue)) {
            this.mDocumentValue = bkO2;
            if (this.isInterested()) {
                this.queueNotifyObservers(bkO2);
            }
        }
    }

    public final void setValue(String string) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(string != null));
        this.setValue(this.createControlSurfaceStringValue(string));
    }

    public void unassign() {
        assert (this.rLM(this.isDocumentThread()));
        this.setValue(this.mDefaultValue);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(bkO2 -> stringValueChangedCallback.valueChanged(bkO2.get()));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(bkO2 -> {
            if (bkO2 == this.mDefaultValue) {
                stringValueChangedCallback.valueChanged(string);
            } else {
                stringValueChangedCallback.valueChanged(bkO2.getLimited(n2));
            }
        });
    }

    protected void sendInitialValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        controlSurfaceStringValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(bkO bkO2) {
        assert (this.rLM(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(bkO2));
    }

    private void notifyObservers(bkO bkO2) {
        assert (this.rLM(this.isControlSurfaceThread()));
        assert (this.rLM(this.isInterested()));
        if (!bkO2.equals(this.mValue)) {
            this.mValue = bkO2;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(bkO2);
                }
            }
        }
    }

    protected bkO createControlSurfaceStringValue(String string) {
        assert (this.rLM(this.isDocumentThread() || this.isInitializingDriver()));
        assert (this.rLM(string != null));
        if (string.isEmpty()) {
            return bkO.EMPTY;
        }
        return new mhx(string);
    }

    protected bkO getControlSurfaceString() {
        assert (this.rLM(this.isControlSurfaceThread()));
        assert (this.rLM(this.mValue != null));
        return this.mValue;
    }
}

