/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.controller.api.DoubleValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class DoubleValueProxy
extends ValueProxy
implements DoubleValue,
lC {
    private double mValue;
    private final double mDefaultValue;

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject, double d2) {
        super(controlSurfaceObject);
        this.mValue = d2;
        this.mDefaultValue = d2;
    }

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0.0);
    }

    @Override
    public Class getTargetType() {
        return KIN.class;
    }

    @Override
    public double get() {
        assert (this.rLM(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public double getControlSurfaceValue() {
        assert (this.rLM(this.isControlSurfaceThread()));
        assert (this.rLM(this.isInterested()));
        return this.mValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        doubleValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(KIN kIN) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(kIN != null));
        kIN.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(KIN kIN) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(kIN != null));
        assert (this.rLM(this.isInterested()));
        assert (this.rLM(this.isActiveOnDocumentThread()));
        kIN.addListener(this);
        this.queueNotifyObservers(kIN.getDoubleValue());
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(tmd tmd2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(this.getTarget() != null));
        assert (this.rLM(this.isInterested()));
        assert (this.rLM(Objects.equals(tmd2.w2Z(), this.getTarget())));
        double d2 = ((KIN)this.getTarget()).getDoubleValue();
        this.queueNotifyObservers(d2);
    }

    private void queueNotifyObservers(double d2) {
        assert (this.rLM(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(d2));
    }

    private void notifyObservers(double d2) {
        assert (this.rLM(this.isControlSurfaceThread()));
        assert (this.rLM(this.isInterested()));
        if (d2 != this.mValue) {
            this.mValue = d2;
            if (this.mObservers != null) {
                for (DoubleValueChangedCallback doubleValueChangedCallback : this.mObservers) {
                    doubleValueChangedCallback.valueChanged(d2);
                }
            }
        }
    }
}

