/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.flt.control_surface.values.DoubleValueWithValueTypeRangedValueTarget;
import com.bitwig.flt.control_surface.values.RangedValueTarget;
import com.bitwig.ramona.core.l2R;

public class DoubleValueRangedValueTarget
extends RangedValueTarget {
    private final String mName;
    private final KIN mDoubleValue;
    private final double mMin;
    private final double mMax;

    public static RangedValueTarget createForAttribute(l2R l2R2) {
        assert (bTm.rLM(l2R2 != null));
        XzD xzD = LjI.w2Z(l2R2);
        assert (bTm.rLM(xzD != null ? xzD instanceof RnE : true));
        if (xzD instanceof RnE) {
            return new DoubleValueWithValueTypeRangedValueTarget(l2R2.Bh1(), l2R2, (RnE)xzD);
        }
        Double d2 = (Double)l2R2.getMinValue();
        assert (bTm.rLM(d2 != null));
        Double d3 = (Double)l2R2.getMaxValue();
        assert (bTm.rLM(d3 != null));
        return new DoubleValueRangedValueTarget(l2R2.Bh1(), l2R2, d2 != null ? d2 : -1.7976931348623157E308, d3 != null ? d3 : Double.MAX_VALUE);
    }

    public DoubleValueRangedValueTarget(String string, KIN kIN, double d2, double d3) {
        assert (bTm.rLM(string != null));
        assert (bTm.rLM(!string.isEmpty()));
        assert (bTm.rLM(kIN != null));
        this.mName = string;
        this.mDoubleValue = kIN;
        this.mMin = d2;
        this.mMax = d3;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean isSettable() {
        return this.mDoubleValue.isSettable();
    }

    @Override
    public KIN getValueChangedEventSource() {
        return this.mDoubleValue;
    }

    @Override
    public double getCurrentValue() {
        return this.mDoubleValue.getDoubleValue();
    }

    @Override
    public void setCurrentValue(double d2) {
        this.mDoubleValue.setDoubleValue(d2);
    }

    @Override
    public double valueToNormalizedValue(double d2) {
        double d3 = (d2 - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
        assert (bTm.rLM(d3 >= 0.0 && d3 <= 1.0));
        return d3;
    }

    @Override
    public double normalizedValueToValue(double d2) {
        assert (bTm.rLM(d2 >= 0.0 && d2 <= 1.0));
        return this.getMinValue() + d2 * (this.getMaxValue() - this.getMinValue());
    }

    @Override
    public bkO createTruncatableStringForCurrentValue() {
        return this.createTruncatableStringForValue(this.getCurrentValue());
    }

    @Override
    public bkO createTruncatableStringForCurrentModulatedValue() {
        return this.createTruncatableStringForCurrentValue();
    }

    public bkO createTruncatableStringForValue(double d2) {
        String string = String.valueOf(d2);
        return new PZR(string);
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    public double getMinValue() {
        return this.mMin;
    }

    private double getMaxValue() {
        return this.mMax;
    }
}

