/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.EnumValueProxy;
import com.bitwig.ramona.core.vE;

public class EnumSetting
extends EnumValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private XF mIsEnabled;
    private XF mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private vE mSetting;

    public EnumSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String[] stringArray, String string3) {
        super(controlSurfaceObject, stringArray, string3);
        if (string == null || string.isEmpty()) {
            throw new VEr("Error: label for setting can't be empty.");
        }
        if (stringArray.length == 0) {
            throw new VEr("Enum settings should needs to have at least some options: Setting " + string + " in category: " + string2);
        }
        if (stringArray.length < 2) {
            this.getControlSurface().rLM("Enum settings should have at least two options: Setting " + string + " in category: " + string2);
        }
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(qb qb2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(qb2 != null));
        assert (this.bsM(this.mSetting == null));
        this.mSetting = qb2;
        this.setTarget(qb2.zxv());
        this.connectEnableAndVisibleValues(qb2.IL(), qb2.SUJ());
    }

    public void disconnectFromSetting(qb qb2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(qb2 != null));
        assert (this.bsM(this.mSetting == qb2));
        this.disconnectEnableAndVisibleValues(qb2.IL(), qb2.SUJ());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(TkU tkU) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.bsM(this.mSetting == null));
        assert (this.rLM(tkU != null));
        this.mSetting = tkU;
        this.setTarget(tkU.w2Z());
        this.connectEnableAndVisibleValues(tkU.zxv(), tkU.Bh1());
    }

    public void disconnectFromSetting(TkU tkU) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(tkU != null));
        assert (this.bsM(this.mSetting == tkU));
        this.disconnectEnableAndVisibleValues(tkU.zxv(), tkU.Bh1());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(XF xF2, XF xF3) {
        this.mIsEnabled = xF2;
        this.mIsVisible = xF3;
    }

    private void disconnectEnableAndVisibleValues(XF xF2, XF xF3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public vE getSetting() {
        return this.mSetting;
    }
}

