/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.UnassignedValueObserver;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.ArrayList;
import java.util.List;

public class ListValueLengthProxy
extends ValueProxy
implements IntegerValue,
qoo {
    private List mUnassignedObservers;
    private boolean mHasScheduledUpdateCount;
    private int mValue;

    public ListValueLengthProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    @Override
    public Class getTargetType() {
        return Tvm.class;
    }

    @Override
    public int get() {
        assert (this.rLM(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.doAddValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        if (n2 == 0) {
            this.addValueObserver(integerValueChangedCallback);
        } else {
            this.checkIsInitializingDriver();
            this.notNull(integerValueChangedCallback, "callback");
            this.doMarkInterested();
            if (this.mUnassignedObservers == null) {
                this.mUnassignedObservers = new ArrayList(2);
            }
            this.mUnassignedObservers.add(new UnassignedValueObserver(integerValueChangedCallback, n2));
        }
    }

    protected void sendDefaultValue(IntegerValueChangedCallback integerValueChangedCallback) {
        integerValueChangedCallback.valueChanged(0);
    }

    protected void connectToTarget(Tvm tvm) {
        tvm.w2Z(this);
    }

    protected void disconnectFromTarget(Tvm tvm) {
        tvm.BOK(this);
    }

    @Override
    public void addedAsListenerTo(Tvm tvm) {
        this.scheduleUpdateCount();
    }

    @Override
    public void aboutToRemoveAsListenerFrom(Tvm tvm) {
        this.scheduleUpdateCount();
    }

    @Override
    public void insertedItems(Tvm tvm, int n2, int n3) {
        this.scheduleUpdateCount();
    }

    @Override
    public void aboutToRemoveItems(Tvm tvm, int n2, int n3) {
        this.scheduleUpdateCount();
    }

    @Override
    public void aboutToChangeItems(Tvm tvm, int n2, int n3) {
        this.scheduleUpdateCount();
    }

    @Override
    public void changedItems(Tvm tvm, int n2, int n3) {
    }

    private void scheduleUpdateCount() {
        assert (this.rLM(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateCount) {
            this.mHasScheduledUpdateCount = true;
            this.runAtEndOfEvent(this::updateCount);
        }
    }

    private void updateCount() {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(this.mHasScheduledUpdateCount));
        this.mHasScheduledUpdateCount = false;
        Tvm tvm = (Tvm)this.getTarget();
        if (tvm != null) {
            this.queueNotifyObservers(tvm.BOK());
        } else {
            this.queueNotifyObserversUnassigned();
        }
    }

    private void queueNotifyObserversUnassigned() {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(0, false));
    }

    private void queueNotifyObservers(int n2) {
        assert (this.rLM(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(n2, true));
    }

    private void notifyObservers(int n2, boolean bl2) {
        assert (this.rLM(this.isControlSurfaceThread()));
        assert (this.rLM(this.isInterested()));
        assert (this.rLM(!bl2 ? n2 == 0 : true));
        if (n2 != this.mValue) {
            this.mValue = n2;
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(n2);
                }
            }
            if (bl2 && this.mUnassignedObservers != null) {
                for (Object object : this.mUnassignedObservers) {
                    ((UnassignedValueObserver)object).mCallback.valueChanged(n2);
                }
            }
        }
        if (!bl2 && this.mUnassignedObservers != null) {
            for (Object object : this.mUnassignedObservers) {
                ((UnassignedValueObserver)object).mCallback.valueChanged(((UnassignedValueObserver)object).mUnassignedValue);
            }
        }
    }
}

