/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.AbsoluteHardwareControl;
import com.bitwig.extension.controller.api.AbsoluteHardwareControlBinding;
import com.bitwig.extension.controller.api.RelativeHardwareControl;
import com.bitwig.extension.controller.api.RelativeHardwareControlToRangedValueBinding;
import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy;
import com.bitwig.flt.control_surface.values.DocumentNumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.NumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.PreferencesNumberSettingRangedValueTarget;
import com.bitwig.ramona.core.vE;

public class NumberSetting
extends AbstractRangedValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final double mMinValue;
    private final double mMaxValue;
    private final double mStepResolution;
    private final String mUnit;
    private final double mDefaultValue;
    private XF mIsEnabled;
    private XF mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private vE mSetting;

    public NumberSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, double d2, double d3, double d4, String string3, double d5) {
        super(controlSurfaceObject, d5, d3 != d2 ? (d5 - d2) / (d3 - d2) : 0.0);
        if (string == null || string.isEmpty()) {
            throw new VEr("Error: label for setting can't be empty.");
        }
        if (string3 == null) {
            string3 = "";
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mMinValue = d2;
        this.mMaxValue = d3;
        this.mStepResolution = d4;
        this.mUnit = string3;
        this.mDefaultValue = d5;
        this.setKey("Setting/" + string2 + "/" + string);
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    @Override
    public Class getTargetType() {
        return NumberSettingRangedValueTarget.class;
    }

    public void connectToSetting(qd qd2) {
        assert (this.bsM(this.mSetting == null));
        this.mSetting = qd2;
        this.setTarget(new PreferencesNumberSettingRangedValueTarget(qd2));
        this.connectEnableAndVisibleValues(qd2.IL(), qd2.SUJ());
    }

    public void disconnectFromSetting(qd qd2) {
        assert (this.bsM(this.mSetting == qd2));
        this.disconnectEnableAndVisibleValues(qd2.IL(), qd2.SUJ());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(BeY beY2) {
        assert (this.bsM(this.mSetting == null));
        this.mSetting = beY2;
        this.setTarget(new DocumentNumberSettingRangedValueTarget(beY2));
        this.connectEnableAndVisibleValues(beY2.zxv(), beY2.Bh1());
    }

    public void disconnectFromSetting(BeY beY2) {
        assert (this.bsM(this.mSetting == beY2));
        this.disconnectEnableAndVisibleValues(beY2.zxv(), beY2.Bh1());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(XF xF2, XF xF3) {
        this.mIsEnabled = xF2;
        this.mIsVisible = xF3;
    }

    private void disconnectEnableAndVisibleValues(XF xF2, XF xF3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    protected double getCurrentValue() {
        double d2 = super.getCurrentValue();
        int n2 = (int)Math.round(d2 / this.mStepResolution);
        return this.mStepResolution * (double)n2;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }

    public double getStepResolution() {
        return this.mStepResolution;
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public String getUnit() {
        return this.mUnit;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public vE getSetting() {
        return this.mSetting;
    }

    @Override
    public AbsoluteHardwareControlBinding addBindingWithRange(AbsoluteHardwareControl absoluteHardwareControl, double d2, double d3) {
        throw new VEr("Not supported");
    }

    @Override
    public RelativeHardwareControlToRangedValueBinding addBindingWithRangeAndSensitivity(RelativeHardwareControl relativeHardwareControl, double d2, double d3, double d4) {
        throw new VEr("Not supported");
    }
}

