/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.MultiManuallyMappedParameterTarget;
import com.bitwig.flt.control_surface.values.ParameterProxy;
import com.bitwig.flt.control_surface.values.ParameterTarget;
import com.bitwig.flt.control_surface.values.RemappableRangedValueProxy;
import com.bitwig.flt.control_surface.values.SingleManuallyMappedParameterTarget;
import java.util.ArrayList;
import java.util.List;

public class RemappableParameterProxy
extends ParameterProxy {
    int mTouchId;
    private List mManualMappings;
    private ParameterTarget mTargetToUseWhenNotMapped;
    private boolean mHasScheduledUpdateToTarget;

    public RemappableParameterProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        assert (this.rLM(string != null));
        assert (this.rLM(!string.isEmpty()));
        this.mValue.setKey(string);
        this.getHost().rememberRemappableParameterProxy(this);
    }

    public void setTarget(ParameterTarget parameterTarget) {
        if (!this.hasManualMappings()) {
            super.setTarget(parameterTarget);
        }
        this.mTargetToUseWhenNotMapped = parameterTarget;
    }

    @Override
    protected RemappableRangedValueProxy createValueProxy() {
        return new RemappableRangedValueProxy(this);
    }

    @Override
    public RemappableRangedValueProxy getValueProxy() {
        return (RemappableRangedValueProxy)super.getValueProxy();
    }

    public String getParameterId() {
        return this.mValue.getKey();
    }

    public void manualMappingAdded(LKj lKj) {
        assert (this.rLM(lKj != null));
        assert (this.rLM(lKj.zxv().equals(this.getParameterId())));
        if (this.mManualMappings == null) {
            this.mManualMappings = new ArrayList(2);
        }
        assert (this.rLM(!this.mManualMappings.contains(lKj)));
        this.mManualMappings.add(lKj);
        this.invalidateTarget();
    }

    public void manualMappingRemoved(LKj lKj) {
        assert (this.rLM(lKj != null));
        assert (this.rLM(lKj.zxv().equals(this.getParameterId())));
        assert (this.rLM(this.mManualMappings != null && this.mManualMappings.contains(lKj)));
        this.mManualMappings.remove(lKj);
        if (this.mManualMappings.isEmpty()) {
            this.mManualMappings = null;
        }
        this.invalidateTarget();
    }

    private void invalidateTarget() {
        if (!this.mHasScheduledUpdateToTarget) {
            this.mHasScheduledUpdateToTarget = true;
            this.runAtEndOfEvent(this::updateTarget);
        }
    }

    private void updateTarget() {
        ParameterTarget parameterTarget = this.calculateTarget();
        super.setTarget(parameterTarget);
        this.mHasScheduledUpdateToTarget = false;
    }

    private ParameterTarget calculateTarget() {
        if (!this.hasManualMappings()) {
            return this.mTargetToUseWhenNotMapped;
        }
        if (this.mManualMappings.size() == 1) {
            return new SingleManuallyMappedParameterTarget((LKj)this.mManualMappings.get(0));
        }
        return new MultiManuallyMappedParameterTarget(this.mManualMappings);
    }

    public boolean hasManualMappings() {
        return this.mManualMappings != null && !this.mManualMappings.isEmpty();
    }

    @Override
    public void touch(boolean bl2) {
        if (bl2) {
            ++this.mTouchId;
        }
        this.postEvent(new PDV(this.mValue, bl2));
    }
}

