/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SignalProxy;
import com.bitwig.ramona.core.vE;

public class SignalSetting
extends SignalProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final String mAction;
    private XF mIsEnabled;
    private XF mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private vE mSetting;

    public SignalSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String string3) {
        super(controlSurfaceObject);
        if (string == null || string.isEmpty()) {
            throw new VEr("Error: label for setting can't be empty.");
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mAction = string3;
    }

    public void connectToSetting(qm qm2) {
        assert (this.bsM(this.mSetting == null));
        this.mSetting = qm2;
        this.setTarget(qm2.Bh1());
        this.connectEnableAndVisibleValues(qm2.IL(), qm2.SUJ());
    }

    public void disconnectFromSetting(qm qm2) {
        assert (this.bsM(this.mSetting == qm2));
        this.disconnectEnableAndVisibleValues(qm2.IL(), qm2.SUJ());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(erS erS2) {
        assert (this.bsM(this.mSetting == null));
        this.mSetting = erS2;
        this.setTarget(erS2.rLM());
        this.connectEnableAndVisibleValues(erS2.zxv(), erS2.Bh1());
    }

    public void disconnectFromSetting(erS erS2) {
        assert (this.bsM(this.mSetting == erS2));
        this.disconnectEnableAndVisibleValues(erS2.zxv(), erS2.Bh1());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(XF xF2, XF xF3) {
        this.mIsEnabled = xF2;
        this.mIsVisible = xF3;
    }

    private void disconnectEnableAndVisibleValues(XF xF2, XF xF3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public String getAction() {
        return this.mAction;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public vE getSetting() {
        return this.mSetting;
    }
}

