/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableStringValueProxy;
import com.bitwig.ramona.core.vE;

public class StringSetting
extends SettableStringValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private XF mIsEnabled;
    private XF mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private vE mSetting;

    public StringSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String string3) {
        super(controlSurfaceObject, string3);
        this.notEmpty(string, "label");
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(qq qq2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(qq2 != null));
        assert (this.bsM(this.mSetting == null));
        this.mSetting = qq2;
        this.setTarget(qq2.zxv());
        this.connectEnableAndVisibleValues(qq2.IL(), qq2.SUJ());
    }

    public void disconnectFromSetting(qq qq2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(qq2 != null));
        assert (this.bsM(this.mSetting == qq2));
        this.disconnectEnableAndVisibleValues(qq2.IL(), qq2.SUJ());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(npx npx2) {
        assert (this.bsM(this.mSetting == null));
        this.mSetting = npx2;
        this.setTarget(npx2.w2Z());
        this.connectEnableAndVisibleValues(npx2.zxv(), npx2.Bh1());
    }

    public void disconnectFromSetting(npx npx2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(npx2 != null));
        assert (this.bsM(this.mSetting == npx2));
        this.disconnectEnableAndVisibleValues(npx2.zxv(), npx2.Bh1());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(XF xF2, XF xF3) {
        this.mIsEnabled = xF2;
        this.mIsVisible = xF3;
    }

    private void disconnectEnableAndVisibleValues(XF xF2, XF xF3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (this.rLM(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public vE getSetting() {
        return this.mSetting;
    }
}

