/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class StringValueProxy
extends ValueProxy
implements StringValue,
lC {
    private bkO mValue;
    private final bkO mDefaultValue;

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.mValue = this.mDefaultValue = this.createTruncatableString(string);
    }

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, "");
    }

    @Override
    public Class getTargetType() {
        return wnR.class;
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        assert (this.rLM(n2 >= 1));
        return this.mValue.getLimited(n2);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        assert (this.w2Z(this.isControlSurfaceThread()));
        this.notNull(stringValueChangedCallback, "callback");
        this.doAddValueObserver(bkO2 -> stringValueChangedCallback.valueChanged(bkO2.get()));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.notNull(stringValueChangedCallback, "callback");
        this.doAddValueObserver(bkO2 -> {
            if (bkO2 == this.mDefaultValue) {
                stringValueChangedCallback.valueChanged(string);
            } else {
                stringValueChangedCallback.valueChanged(bkO2.getLimited(n2));
            }
        });
    }

    protected void sendDefaultValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        assert (this.rLM(this.isControlSurfaceThread()));
        controlSurfaceStringValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(wnR wnR2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(wnR2 != null));
        if (wnR2.isObservable()) {
            wnR2.removeListener(this);
        }
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(wnR wnR2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(wnR2 != null));
        assert (this.rLM(this.isInterested()));
        assert (this.rLM(this.isActiveOnDocumentThread()));
        if (wnR2.isObservable()) {
            wnR2.addListener(this);
        }
        this.updateValue();
    }

    public bkO getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(tmd tmd2) {
        assert (this.rLM(this.isDocumentThread()));
        assert (this.rLM(this.getTarget() != null));
        assert (this.rLM(this.isInterested()));
        assert (this.rLM(Objects.equals(tmd2.w2Z(), this.getTarget())));
        this.updateValue();
    }

    private void updateValue() {
        assert (this.rLM(this.isDocumentThread()));
        String string = (String)((wnR)this.getTarget()).getValue();
        assert (this.rLM(string != null));
        bkO bkO2 = this.createTruncatableString(string);
        assert (this.rLM(bkO2 != null));
        this.queueNotifyObservers(bkO2);
    }

    private void queueNotifyObservers(bkO bkO2) {
        assert (this.rLM(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(bkO2));
    }

    protected bkO createTruncatableString(String string) {
        assert (this.rLM(this.isDocumentThread() || this.isInitializingDriver()));
        if (string.isEmpty()) {
            return bkO.EMPTY;
        }
        return new mhx(string);
    }

    private void notifyObservers(bkO bkO2) {
        assert (this.rLM(this.isControlSurfaceThread()));
        assert (this.rLM(this.isInterested()));
        if (bkO2.equals(this.mValue)) {
            return;
        }
        this.mValue = bkO2;
        if (this.mObservers != null) {
            for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                controlSurfaceStringValueChangedCallback.valueChanged(bkO2);
            }
        }
    }
}

