/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.flt.control_surface.values.BooleanValueAtomParameterTarget;
import com.bitwig.flt.control_surface.values.DecimalValueAtomParameterTarget;
import com.bitwig.flt.control_surface.values.IndexedValueAtomParameterTarget;
import com.bitwig.flt.control_surface.values.IntegerValueAtomParameterTarget;
import com.bitwig.flt.control_surface.values.ParameterProxy;
import com.bitwig.flt.control_surface.values.ParameterTarget;
import com.bitwig.flt.control_surface.values.PluginAtomParameterTarget;
import com.bitwig.flt.document.core.iface.KcU;

public abstract class ValueAtomParameterTarget
extends ParameterTarget {
    private final Kpi mAtom;
    private GMY mDocumentDisplaySettings;

    public static ValueAtomParameterTarget createForAtom(Kpi kpi) {
        assert (bTm.rLM(kpi != null));
        assert (bTm.rLM(kpi.PTW() != null));
        if (kpi == null) {
            return null;
        }
        if (kpi.PTW() == null) {
            bTm.bsM.bsM("Trying to create a value atom target for an atom that is not in the project " + kpi.eQa().zsF());
            return null;
        }
        if (kpi instanceof YfS) {
            return new DecimalValueAtomParameterTarget((YfS)kpi);
        }
        if (kpi instanceof Z3H) {
            return new PluginAtomParameterTarget((Z3H)kpi);
        }
        if (kpi instanceof XpQ) {
            return new BooleanValueAtomParameterTarget((XpQ)kpi);
        }
        if (kpi instanceof Dyq) {
            return new IndexedValueAtomParameterTarget((Dyq)kpi);
        }
        if (kpi instanceof IjR) {
            return new IntegerValueAtomParameterTarget((IjR)kpi);
        }
        assert (bTm.rLM(false));
        bTm.bsM.bsM("Cannot create a parameter target for atom of type " + kpi.cFc().YiK());
        return null;
    }

    protected ValueAtomParameterTarget(Kpi kpi) {
        this.mAtom = kpi;
    }

    public Kpi getAtom() {
        return this.mAtom;
    }

    @Override
    public KcU getDocument() {
        return this.mAtom.PTW();
    }

    @Override
    public wnR getNameValue() {
        return this.getAtom().aw_();
    }

    @Override
    public void restoreAutomationControl() {
        this.mAtom.pOj();
    }

    @Override
    public void deleteAllAutomation() {
        this.mAtom.FJA();
    }

    @Override
    public void addActiveParameterBinding(gVd gVd2, ParameterProxy parameterProxy) {
        parameterProxy.getControlSurfaceState().w2Z(gVd2, parameterProxy, this.mAtom);
    }

    @Override
    public void removeActiveParameterBinding(gVd gVd2, ParameterProxy parameterProxy) {
        parameterProxy.getControlSurfaceState().BOK(gVd2, parameterProxy, this.mAtom);
    }

    @Override
    public void startedAdjusting(boolean bl2, boolean bl3) {
        this.mAtom.w2Z(bl2, bl3);
    }

    @Override
    public void finishedAdjusting(boolean bl2, boolean bl3) {
        this.mAtom.BOK(bl2, bl3);
    }

    @Override
    public void setToDefault() {
        assert (bTm.rLM(this.mDocumentDisplaySettings != null));
        if (this.mDocumentDisplaySettings != null) {
            boolean bl2;
            JbO jbO = this.mDocumentDisplaySettings.mge();
            boolean bl3 = bl2 = jbO != null && Di.w2Z(jbO, this.mAtom);
            if (bl2) {
                jbO.BOK(this.mAtom);
                return;
            }
        }
        this.mAtom.bZ_();
    }

    @Override
    protected void connected() {
        assert (bTm.rLM(this.mDocumentDisplaySettings == null));
        super.connected();
        KcU kcU = this.mAtom.PTW();
        assert (bTm.rLM(kcU != null));
        if (kcU != null) {
            this.mDocumentDisplaySettings = kcU.OLz();
        } else {
            bTm.bsM.bsM("Connected controller to a value atom that is not in a project " + this.mAtom.eQa().zsF());
        }
    }

    @Override
    protected void disconnected() {
        assert (bTm.rLM(this.mDocumentDisplaySettings != null));
        this.mDocumentDisplaySettings = null;
        super.disconnected();
    }

    @Override
    public Kpi getValueAtomToUpdateOnEngineSide() {
        return this.mAtom;
    }

    @Override
    public XF getHasAutomationTarget() {
        return this.mAtom.aG2();
    }
}

