/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.document.api.document;

import com.bitwig.dawproject.Arrangement;
import com.bitwig.dawproject.BoolParameter;
import com.bitwig.dawproject.Channel;
import com.bitwig.dawproject.ContentType;
import com.bitwig.dawproject.EnumParameter;
import com.bitwig.dawproject.ExpressionType;
import com.bitwig.dawproject.FileReference;
import com.bitwig.dawproject.IntegerParameter;
import com.bitwig.dawproject.Interpolation;
import com.bitwig.dawproject.MixerRole;
import com.bitwig.dawproject.Parameter;
import com.bitwig.dawproject.Project;
import com.bitwig.dawproject.RealParameter;
import com.bitwig.dawproject.Referenceable;
import com.bitwig.dawproject.Scene;
import com.bitwig.dawproject.Send;
import com.bitwig.dawproject.SendType;
import com.bitwig.dawproject.TimeSignatureParameter;
import com.bitwig.dawproject.Track;
import com.bitwig.dawproject.Transport;
import com.bitwig.dawproject.Unit;
import com.bitwig.dawproject.device.BuiltinDevice;
import com.bitwig.dawproject.device.ClapPlugin;
import com.bitwig.dawproject.device.Compressor;
import com.bitwig.dawproject.device.Device;
import com.bitwig.dawproject.device.DeviceRole;
import com.bitwig.dawproject.device.EqBand;
import com.bitwig.dawproject.device.EqBandType;
import com.bitwig.dawproject.device.Equalizer;
import com.bitwig.dawproject.device.Limiter;
import com.bitwig.dawproject.device.NoiseGate;
import com.bitwig.dawproject.device.Plugin;
import com.bitwig.dawproject.device.Vst2Plugin;
import com.bitwig.dawproject.device.Vst3Plugin;
import com.bitwig.dawproject.timeline.Audio;
import com.bitwig.dawproject.timeline.BoolPoint;
import com.bitwig.dawproject.timeline.Clip;
import com.bitwig.dawproject.timeline.ClipSlot;
import com.bitwig.dawproject.timeline.Clips;
import com.bitwig.dawproject.timeline.EnumPoint;
import com.bitwig.dawproject.timeline.IntegerPoint;
import com.bitwig.dawproject.timeline.Lanes;
import com.bitwig.dawproject.timeline.Marker;
import com.bitwig.dawproject.timeline.Markers;
import com.bitwig.dawproject.timeline.Note;
import com.bitwig.dawproject.timeline.Notes;
import com.bitwig.dawproject.timeline.Points;
import com.bitwig.dawproject.timeline.RealPoint;
import com.bitwig.dawproject.timeline.TimeSignaturePoint;
import com.bitwig.dawproject.timeline.TimeUnit;
import com.bitwig.dawproject.timeline.Timeline;
import com.bitwig.dawproject.timeline.Warp;
import com.bitwig.dawproject.timeline.Warps;
import com.bitwig.flt.document.core.master.DsV;
import com.bitwig.flt.document.core.master.LJS;
import com.bitwig.flt.document.core.master.REs;
import com.bitwig.flt.document.core.master.YZ1;
import com.bitwig.flt.document.core.master.aYR;
import com.bitwig.flt.document.core.master.device.DFk;
import com.bitwig.flt.document.core.master.device.DK2;
import com.bitwig.flt.document.core.master.device.Es;
import com.bitwig.flt.document.core.master.device.GYC;
import com.bitwig.flt.document.core.master.device.THL;
import com.bitwig.flt.document.core.master.device.mfX;
import com.bitwig.flt.document.core.master.device.qp;
import com.bitwig.flt.document.core.master.device.v1G;
import com.bitwig.flt.document.core.master.uDX;
import com.bitwig.flt.document.core.master.ywn;
import com.bitwig.flt.packaging.core.rKC;
import com.bitwig.ramona.core.KDJ;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.DoubleUnaryOperator;

public class ApiDawProjectExporter {
    private final Map mEmbeddedFiles;
    private final REs mSourceProject;
    private Project mProject;
    private final List mAllTracks = new ArrayList();
    private final Map mTrackToTrackMap = new HashMap();
    private final Map mAtomReferences = new HashMap();
    private Map mRealValueConverters = new HashMap();

    public ApiDawProjectExporter(REs rEs, Map map) {
        this.mSourceProject = rEs;
        this.mEmbeddedFiles = map;
    }

    public Project convert() {
        Referenceable.setAutoID((boolean)true);
        this.mProject = new Project();
        this.mProject.application.name = "Bitwig Studio";
        this.mProject.application.version = "5.3.9";
        this.createTransport();
        this.createRootTracks();
        this.routeTracks();
        this.createArrangement();
        this.createScenes();
        return this.mProject;
    }

    private void createScenes() {
        for (Ksw ksw : this.mSourceProject.sYT().Iso()) {
            this.mProject.scenes.add(this.createScene(ksw));
        }
    }

    private void createTransport() {
        JeY jeY = this.mSourceProject.WDD();
        this.mProject.transport = new Transport();
        this.mProject.transport.tempo = (RealParameter)this.createParameter(jeY.NW1());
        scM scM2 = jeY.NDH();
        this.mProject.transport.timeSignature = (TimeSignatureParameter)this.createParameter(scM2);
    }

    private void createRootTracks() {
        aYR aYR2 = this.mSourceProject.sYT();
        List list = this.mProject.structure;
        for (ywn ywn2 : aYR2.Fyb()) {
            Track track;
            if (ywn2 instanceof Eja) {
                track = this.createTrack((Eja)ywn2);
                list.add(track);
                continue;
            }
            if (ywn2 instanceof aYR) {
                track = this.createGroupTrack((aYR)ywn2);
                list.add(track);
                continue;
            }
            throw new IllegalStateException();
        }
        for (ywn ywn2 : aYR2.KjK()) {
            list.add(this.createTrack((Eja)ywn2));
        }
        list.add(this.createTrack(aYR2.geP()));
    }

    private Track createGroupTrack(aYR aYR2) {
        Track track = this.createTrack(aYR2.geP());
        track.name = aYR2.W23();
        track.color = this.getColor(aYR2.BD());
        track.contentType = new ContentType[]{ContentType.TRACKS};
        List list = track.tracks;
        for (ywn ywn2 : aYR2.Fyb()) {
            Track track2;
            if (ywn2 instanceof Eja) {
                track2 = this.createTrack((Eja)ywn2);
                list.add(track2);
                continue;
            }
            if (ywn2 instanceof aYR) {
                track2 = this.createGroupTrack((aYR)ywn2);
                list.add(track2);
                continue;
            }
            throw new IllegalStateException();
        }
        for (ywn ywn2 : aYR2.KjK()) {
            list.add(this.createTrack((Eja)ywn2));
        }
        assert (bTj.rLM(track.channel.role == MixerRole.MASTER));
        return track;
    }

    private Track createTrack(Eja eja) {
        ContentType[] contentTypeArray2;
        Track track = new Track();
        track.channel = new Channel();
        this.mTrackToTrackMap.put(eja, track);
        this.mAllTracks.add(eja);
        track.name = eja.W23();
        track.comment = eja.khG();
        track.color = this.getColor(eja.BD());
        track.loaded = eja.CKO();
        w1Q w1Q2 = eja.ZVP();
        track.name = eja.W23();
        track.color = this.getColor(eja.BD());
        Channel channel = track.channel;
        channel.volume = (RealParameter)this.createParameter(w1Q2.GW1());
        channel.pan = (RealParameter)this.createParameter(w1Q2.xhT(), Unit.NORMALIZED);
        channel.mute = (BoolParameter)this.createParameter(w1Q2.FpH());
        channel.solo = w1Q2.X3Z();
        channel.role = eja.U3m() ? MixerRole.MASTER : (eja.GJ() ? MixerRole.EFFECT_TRACK : MixerRole.REGULAR);
        for (ContentType[] contentTypeArray2 : eja.LVD().eJL()) {
            if (channel.devices == null) {
                channel.devices = new ArrayList();
            }
            channel.devices.add(this.createDevice((DFk)contentTypeArray2));
        }
        ContentType[] contentTypeArray3 = new ContentType[]{ContentType.NOTES};
        contentTypeArray2 = new ContentType[]{ContentType.AUDIO};
        ContentType[] contentTypeArray4 = new ContentType[]{ContentType.AUDIO, ContentType.NOTES};
        switch (eja.UN3()) {
            case w2Z: {
                track.contentType = contentTypeArray3;
                break;
            }
            case BOK: {
                track.contentType = contentTypeArray2;
                break;
            }
            case HaN: {
                track.contentType = contentTypeArray4;
            }
        }
        return track;
    }

    private void routeTracks() {
        for (Eja eja : this.mAllTracks) {
            this.routeTrack(eja);
        }
    }

    private void routeTrack(Eja eja) {
        int n2;
        Eja eja2;
        Track track = (Track)this.mTrackToTrackMap.get(eja);
        Channel channel = track.channel;
        WoI woI = eja.bUt().Pgb();
        Eja eja3 = eja2 = woI != null ? woI.RTr() : null;
        if (eja2 != null) {
            Track track2 = (Track)this.mTrackToTrackMap.get(eja2);
            channel.destination = track2.channel;
        }
        if ((n2 = eja.ZVP().tUG()) > 0) {
            channel.sends = new ArrayList();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            jUC jUC2 = eja.ZVP().rLM(i2);
            Send send = new Send();
            send.volume = (RealParameter)this.createParameter(jUC2.Rss());
            Eja eja4 = jUC2.vlq().SWi();
            send.destination = ((Track)this.mTrackToTrackMap.get((Object)eja4)).channel;
            if (!jUC2.rLM()) {
                send.enable = new BoolParameter();
                send.enable.value = false;
            }
            send.type = this.getEffectiveSendMode(jUC2);
            channel.sends.add(send);
        }
    }

    Parameter createParameter(rez rez2) {
        return this.createParameter(rez2, null);
    }

    Parameter createParameter(rez rez2, Unit unit, DoubleUnaryOperator doubleUnaryOperator) {
        Parameter parameter = this.createParameterOfType(rez2, unit, doubleUnaryOperator);
        parameter.name = this.nullIfEmpty(rez2.OyU());
        this.mAtomReferences.put(rez2, parameter);
        return parameter;
    }

    Parameter createParameter(rez rez2, Unit unit) {
        Parameter parameter = this.createParameterOfType(rez2, unit, null);
        parameter.name = this.nullIfEmpty(rez2.OyU());
        this.mAtomReferences.put(rez2, parameter);
        return parameter;
    }

    private Parameter createParameterOfType(rez rez2, Unit unit, DoubleUnaryOperator doubleUnaryOperator) {
        if (rez2 instanceof Vbx) {
            BoolParameter boolParameter = new BoolParameter();
            boolParameter.value = ((Vbx)rez2).w2Z();
            return boolParameter;
        }
        if (rez2 instanceof dpW) {
            RealParameter realParameter = new RealParameter();
            if (doubleUnaryOperator != null) {
                this.mRealValueConverters.put(realParameter, doubleUnaryOperator);
            }
            this.assignUnitAndValue((dpW)rez2, realParameter, unit);
            return realParameter;
        }
        if (rez2 instanceof qp) {
            RealParameter realParameter = new RealParameter();
            qp qp2 = (qp)rez2;
            realParameter.value = qp2.KEp();
            realParameter.min = 0.0;
            realParameter.max = 1.0;
            realParameter.unit = Unit.NORMALIZED;
            realParameter.parameterID = qp2.rLM();
            return realParameter;
        }
        if (rez2 instanceof uu) {
            EnumParameter enumParameter = new EnumParameter();
            enumParameter.value = ((uu)rez2).rLM();
            YJJ yJJ = ((uu)rez2).oYF();
            enumParameter.count = yJJ.JEB();
            enumParameter.labels = yJJ.r2();
            return enumParameter;
        }
        if (rez2 instanceof AwC) {
            IntegerParameter integerParameter = new IntegerParameter();
            integerParameter.value = ((AwC)rez2).xZV();
            integerParameter.min = ((AwC)rez2).h3k().rLM();
            integerParameter.max = ((AwC)rez2).h3k().KyJ();
            return integerParameter;
        }
        if (rez2 instanceof scM) {
            TimeSignatureParameter timeSignatureParameter = new TimeSignatureParameter();
            scM scM2 = (scM)rez2;
            timeSignatureParameter.numerator = scM2.JEB();
            timeSignatureParameter.denominator = scM2.Bh1();
            return timeSignatureParameter;
        }
        if (rez2 == null) {
            throw new NullPointerException();
        }
        throw new KDJ(rez2.getClass().getName());
    }

    private void assignUnitAndValue(dpW dpW2, RealParameter realParameter, Unit unit) {
        jrv jrv2 = dpW2.h3k();
        if (unit != null) {
            realParameter.unit = unit;
        } else {
            switch (jrv2.gFf()) {
                case BOK: {
                    realParameter.unit = Unit.DECIBEL;
                    break;
                }
                case HaN: 
                case JEB: {
                    realParameter.unit = Unit.SEMITONES;
                    break;
                }
                default: {
                    realParameter.unit = Unit.LINEAR;
                }
            }
            if (realParameter.unit == Unit.LINEAR) {
                switch (jrv2.zkl()) {
                    case cFc: {
                        realParameter.unit = Unit.BEATS;
                        break;
                    }
                    case r2: {
                        realParameter.unit = Unit.BPM;
                        break;
                    }
                    case bsM: {
                        realParameter.unit = Unit.SECONDS;
                        break;
                    }
                    case UN3: {
                        realParameter.unit = Unit.HERTZ;
                    }
                }
            }
        }
        DoubleUnaryOperator doubleUnaryOperator = (DoubleUnaryOperator)this.mRealValueConverters.get(realParameter);
        realParameter.value = this.convertValue(doubleUnaryOperator, dpW2.w2Z(), jrv2, realParameter.unit);
        realParameter.min = this.convertValue(doubleUnaryOperator, jrv2.KyJ(), jrv2, realParameter.unit);
        realParameter.max = this.convertValue(doubleUnaryOperator, jrv2.JEB(), jrv2, realParameter.unit);
    }

    private oVe convertUnit(Unit unit) {
        if (unit == null) {
            return oVe.w2Z;
        }
        switch (unit) {
            case LINEAR: 
            case NORMALIZED: {
                return oVe.w2Z;
            }
            case PERCENT: {
                return oVe.BOK;
            }
            case DECIBEL: {
                return oVe.rLM;
            }
            case HERTZ: {
                return oVe.UN3;
            }
            case SEMITONES: {
                return oVe.JEB;
            }
            case SECONDS: {
                return oVe.bsM;
            }
            case BEATS: {
                return oVe.cFc;
            }
            case BPM: {
                return oVe.r2;
            }
        }
        return null;
    }

    private double convertValue(DoubleUnaryOperator doubleUnaryOperator, double d2, jrv jrv2, Unit unit) {
        ZyH zyH = jrv2.gFf();
        if (unit == Unit.NORMALIZED) {
            double d3 = jrv2.w2Z(d2);
            assert (bTj.rLM(Double.isFinite(d3)));
            if (doubleUnaryOperator != null) {
                return doubleUnaryOperator.applyAsDouble(d3);
            }
            return d3;
        }
        oVe oVe2 = this.convertUnit(unit);
        double d4 = KJ.w2Z(d2, zyH, oVe2);
        assert (bTj.rLM(Double.isFinite(d4)));
        if (doubleUnaryOperator != null) {
            return doubleUnaryOperator.applyAsDouble(d4);
        }
        return d4;
    }

    private void createArrangement() {
        Lanes lanes;
        Arrangement arrangement = new Arrangement();
        arrangement.lanes = lanes = new Lanes();
        lanes.timeUnit = TimeUnit.BEATS;
        for (Eja eja : this.mAllTracks) {
            Lanes lanes2 = new Lanes();
            lanes2.track = (Track)this.mTrackToTrackMap.get(eja);
            lanes.lanes.add(lanes2);
            Clips clips = new Clips();
            lanes2.lanes.add(clips);
            wYN wYN2 = eja.Fe();
            for (bZO bZO2 : wYN2.Jpm().fa_()) {
                clips.clips.add(this.createArrangerClip((XB)bZO2));
            }
            for (bZO bZO2 : wYN2.Ayn()) {
                rez rez2 = ((MnG)bZO2).RTr();
                Points points = this.createPoints((DC1)bZO2);
                if (points == null) continue;
                if (rez2 == this.mSourceProject.WDD().NW1()) {
                    arrangement.tempoAutomation = points;
                    continue;
                }
                if (rez2 == this.mSourceProject.WDD().NDH()) {
                    arrangement.timeSignatureAutomation = points;
                    continue;
                }
                if (points.target.parameter == null && points.target.expression == null) continue;
                lanes2.lanes.add(points);
            }
        }
        arrangement.markers = this.createCueMarkers();
        this.mProject.arrangement = arrangement;
    }

    private Scene createScene(Ksw ksw) {
        Scene scene = new Scene();
        scene.name = this.nullIfEmpty(ksw.bsM());
        scene.color = this.getColor(ksw.gBA());
        scene.comment = ksw.Fyb();
        Lanes lanes = new Lanes();
        scene.content = lanes;
        int n2 = ksw.i2U();
        for (Eja eja : this.mAllTracks) {
            Zea zea = eja.HaN(n2);
            ClipSlot clipSlot = new ClipSlot();
            clipSlot.track = (Track)this.mTrackToTrackMap.get(eja);
            clipSlot.hasStop = zea.Bh1();
            lanes.lanes.add(clipSlot);
            XB xB2 = zea.Rss();
            if (xB2 == null) continue;
            clipSlot.clip = this.createClip(xB2);
            this.addClipAutomation(clipSlot.clip, xB2);
        }
        return scene;
    }

    private Points createPoints(DC1 dC1) {
        rez rez2 = dC1.RTr();
        if (rez2 instanceof mh) {
            mh mh2 = (mh)rez2;
            gJ gJ2 = mh2.wiI();
            Points points = this.createPoints(dC1.Jpm(), Unit.NORMALIZED, null);
            switch (gJ2) {
                case HaN: {
                    points.target.expression = ExpressionType.CHANNEL_CONTROLLER;
                    points.target.controller = mh2.xZV();
                    break;
                }
                case BOK: {
                    points.target.expression = ExpressionType.CHANNEL_PRESSURE;
                    break;
                }
                case w2Z: {
                    points.target.expression = ExpressionType.PITCH_BEND;
                }
            }
            points.target.channel = mh2.rLM();
            points.unit = Unit.NORMALIZED;
            return points;
        }
        Parameter parameter = this.getParameter(rez2);
        if (parameter == null) {
            return null;
        }
        DoubleUnaryOperator doubleUnaryOperator = (DoubleUnaryOperator)this.mRealValueConverters.get(parameter);
        Points points = this.createPoints(dC1.Jpm(), this.getUnit(parameter), doubleUnaryOperator);
        points.target.parameter = parameter;
        return points;
    }

    private Unit getUnit(Parameter parameter) {
        if (parameter instanceof RealParameter) {
            return ((RealParameter)parameter).unit;
        }
        return null;
    }

    private Points createPoints(yis yis2, Unit unit, DoubleUnaryOperator doubleUnaryOperator) {
        Points points = new Points();
        uyZ uyZ2 = yis2.aH_();
        points.unit = unit;
        for (f1D f1D2 : yis2.fa_()) {
            Object object;
            if (f1D2 instanceof qHY) {
                object = new RealPoint();
                ((RealPoint)object).time = f1D2.aG2();
                double d2 = this.convertValue(doubleUnaryOperator, ((qHY)f1D2).w2Z(), (jrv)uyZ2, unit);
                ((RealPoint)object).value = d2;
                ((RealPoint)object).interpolation = Interpolation.LINEAR;
                points.points.add(object);
                continue;
            }
            if (f1D2 instanceof utq) {
                object = new BoolPoint();
                ((BoolPoint)object).time = f1D2.aG2();
                ((BoolPoint)object).value = ((utq)f1D2).KyJ();
                points.points.add(object);
                continue;
            }
            if (f1D2 instanceof Zim) {
                object = (Zim)f1D2;
                EnumPoint enumPoint = new EnumPoint();
                YJJ yJJ = (YJJ)((f1D)object).IdP();
                enumPoint.time = f1D2.aG2();
                enumPoint.value = yJJ.BOK(((xxq)object).stE());
                points.points.add(enumPoint);
                continue;
            }
            if (f1D2 instanceof VG2) {
                object = new IntegerPoint();
                ((IntegerPoint)object).time = f1D2.aG2();
                ((IntegerPoint)object).value = ((VG2)f1D2).tUG();
                points.points.add(object);
                continue;
            }
            if (!(f1D2 instanceof pmU)) continue;
            object = new TimeSignaturePoint();
            ((TimeSignaturePoint)object).time = f1D2.aG2();
            pmU pmU2 = (pmU)f1D2;
            ((TimeSignaturePoint)object).numerator = pmU2.JEB();
            ((TimeSignaturePoint)object).denominator = pmU2.zxv();
            points.points.add(object);
        }
        return points;
    }

    private Parameter getParameter(rez rez2) {
        return (Parameter)this.mAtomReferences.get(rez2);
    }

    private Markers createCueMarkers() {
        PHm pHm = this.mSourceProject.sYT().VvU().P3();
        if (pHm.tUG() == 0) {
            return null;
        }
        Markers markers = new Markers();
        for (zLc zLc2 : pHm.fa_()) {
            Marker marker = new Marker();
            marker.time = zLc2.aG2();
            marker.name = this.nullIfEmpty(zLc2.w2Z());
            marker.color = this.getColor(zLc2.bsM());
            markers.markers.add(marker);
        }
        return markers;
    }

    private String getColor(Pu pu2) {
        return pu2.cFc() ? null : pu2.slM();
    }

    private Clip createArrangerClip(XB xB2) {
        return this.createClip(xB2);
    }

    private Clip createClip(XB xB2) {
        Clip clip = new Clip();
        clip.name = this.nullIfEmpty(xB2.stE());
        clip.color = this.getColor(xB2.nlO());
        clip.time = xB2.aG2();
        clip.duration = xB2.eN1();
        clip.playStart = xB2.d1I();
        clip.enable = !xB2.nnP();
        if (xB2.mYV()) {
            clip.loopStart = xB2.mun().aG2();
            clip.loopEnd = xB2.mun().sIK();
        }
        if (xB2 instanceof xad) {
            xad xad2 = (xad)xB2;
            clip.fadeTimeUnit = TimeUnit.BEATS;
            clip.fadeInTime = xad2.bsM();
            clip.fadeOutTime = xad2.KyJ();
            clip.content = this.createAudioEventTimeline(xad2.DYI());
        } else if (xB2 instanceof wow) {
            clip.content = this.createNoteTimeline(((wow)xB2).Bh1());
        }
        return clip;
    }

    private String nullIfEmpty(String string) {
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    private void addClipAutomation(Clip clip, XB xB2) {
        List list = xB2.Acb().tZS();
        if (list.isEmpty()) {
            return;
        }
        Lanes lanes = new Lanes();
        lanes.lanes.add(clip.content);
        clip.content = lanes;
        for (gJP gJP2 : list) {
            Points points = this.createPoints(gJP2);
            if (points == null) continue;
            lanes.lanes.add(points);
        }
    }

    private Notes createNoteTimeline(rD3 rD32) {
        Notes notes = new Notes();
        rD32.POt().zxv().forEach(oUa -> notes.notes.add(this.createNote((JFM)oUa)));
        return notes;
    }

    private Clips createAudioEventTimeline(bx bx2) {
        Mj mj2 = bx2.KRB();
        if (mj2 == null) {
            return null;
        }
        Clips clips = new Clips();
        for (yDX yDX2 : mj2.fa_()) {
            clips.clips.add(this.createAudioNote(yDX2));
        }
        return clips;
    }

    private Clip createAudioNote(yDX yDX2) {
        Clip clip = new Clip();
        clip.time = yDX2.aG2();
        clip.duration = yDX2.eN1();
        clip.fadeTimeUnit = TimeUnit.BEATS;
        clip.fadeInTime = yDX2.bsM();
        clip.fadeOutTime = yDX2.KyJ();
        Audio audio = this.createAudio(yDX2);
        if (yDX2.wFl() == LVK.w2Z) {
            clip.contentTimeUnit = TimeUnit.SECONDS;
            clip.content = this.wrapAudioContentWithExpressions(yDX2, (Timeline)audio);
            clip.playStart = yDX2.TNL();
            clip.playStop = yDX2.slM();
        } else {
            clip.contentTimeUnit = TimeUnit.BEATS;
            Warps warps = this.createWarps(yDX2.gBA(), audio);
            clip.content = this.wrapAudioContentWithExpressions(yDX2, (Timeline)warps);
            clip.playStart = yDX2.Pgb();
        }
        return clip;
    }

    private Timeline wrapAudioContentWithExpressions(yDX yDX2, Timeline timeline) {
        MxD mxD = yDX2.qn3();
        List list = mxD.seh();
        if (!list.isEmpty()) {
            Lanes lanes = new Lanes();
            lanes.lanes.add(timeline);
            for (Ggn ggn : list) {
                lanes.lanes.add(this.createExpressionTimeline(ggn));
            }
            return lanes;
        }
        return timeline;
    }

    private Audio createAudio(yDX yDX2) {
        Audio audio = new Audio();
        uDX uDX2 = yDX2.d1I();
        File file = this.getFile(uDX2);
        if (!this.mEmbeddedFiles.containsKey(file)) {
            String string = this.getUniquePath("audio/" + file.getName());
            this.embed(string, file);
        }
        audio.file.path = (String)this.mEmbeddedFiles.get(file);
        audio.duration = uDX2.zxv();
        audio.sampleRate = uDX2.JEB();
        audio.channels = uDX2.Bh1();
        audio.algorithm = yDX2.wFl().BOK();
        return audio;
    }

    private File getFile(uDX uDX2) {
        File file = uDX2.gU();
        if (file != null) {
            return file;
        }
        LJS lJS = uDX2.YMa();
        String string = lJS.zxv();
        if (string != null && !string.isEmpty()) {
            return this.mSourceProject.Bh1().BOK(string);
        }
        YZ1 yZ1 = lJS.eJL();
        return new File(yZ1.rLM());
    }

    private Warps createWarps(Zsu zsu, Audio audio) {
        int n2 = zsu.tUG();
        Warps warps = new Warps();
        warps.timeUnit = TimeUnit.BEATS;
        warps.contentTimeUnit = TimeUnit.SECONDS;
        warps.content = audio;
        for (int i2 = 0; i2 < n2; ++i2) {
            Mma mma = zsu.BOK(i2);
            Warp warp = new Warp();
            warp.time = mma.aG2();
            warp.contentTime = mma.rLM();
            warps.events.add(warp);
        }
        return warps;
    }

    private String getUniquePath(String string) {
        for (String string2 : this.mEmbeddedFiles.values()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            int n2 = string.lastIndexOf(".");
            if (n2 == -1) {
                return this.getUniquePath(string + "2");
            }
            return this.getUniquePath(string.substring(0, n2) + "2" + string.substring(n2));
        }
        return string;
    }

    private Note createNote(JFM jFM) {
        Note note = new Note();
        note.time = jFM.aG2();
        note.duration = jFM.eN1();
        note.channel = jFM.Ayn();
        note.key = jFM.w2Z();
        note.velocity = jFM.KyJ();
        note.releaseVelocity = jFM.UN3();
        PTy pTy = jFM.LqO();
        List list = pTy.seh();
        if (!list.isEmpty()) {
            if (list.size() == 1) {
                note.content = this.createExpressionTimeline((Ggn)list.get(0));
            } else {
                Lanes lanes = new Lanes();
                note.content = lanes;
                for (Ggn ggn : list) {
                    lanes.lanes.add(this.createExpressionTimeline(ggn));
                }
            }
        }
        return note;
    }

    private Points createExpressionTimeline(Ggn ggn) {
        Unit unit = this.getExpressionUnit(ggn.ckb());
        Points points = this.createPoints(ggn, unit, null);
        points.target.expression = this.getExpression(ggn.ckb());
        points.unit = unit;
        return points;
    }

    private ExpressionType getExpression(String string) {
        if (string.equals("amplitude")) {
            return ExpressionType.GAIN;
        }
        if (string.equals("panning")) {
            return ExpressionType.PAN;
        }
        if (string.equals("transpose")) {
            return ExpressionType.TRANSPOSE;
        }
        if (string.equals("timbre")) {
            return ExpressionType.TIMBRE;
        }
        if (string.equals("formant")) {
            return ExpressionType.FORMANT;
        }
        if (string.equals("pressure")) {
            return ExpressionType.PRESSURE;
        }
        return null;
    }

    private Unit getExpressionUnit(String string) {
        if (string.equals("amplitude")) {
            return Unit.LINEAR;
        }
        if (string.equals("panning")) {
            return Unit.LINEAR;
        }
        if (string.equals("transpose")) {
            return Unit.SEMITONES;
        }
        if (string.equals("timbre")) {
            return Unit.LINEAR;
        }
        if (string.equals("formant")) {
            return Unit.SEMITONES;
        }
        if (string.equals("pressure")) {
            return Unit.LINEAR;
        }
        return null;
    }

    public SendType getEffectiveSendMode(jUC jUC2) {
        WUc wUc = jUC2.mYV();
        if (wUc == WUc.w2Z) {
            DsV dsV2 = jUC2.vlq();
            Eja eja = dsV2.SWi();
            return eja.FqM() ? SendType.PRE : SendType.POST;
        }
        if (wUc == WUc.BOK) {
            return SendType.PRE;
        }
        return SendType.POST;
    }

    private Device createDevice(DFk dFk2) {
        if (dFk2 instanceof Es) {
            return this.createClapDevice((Es)dFk2);
        }
        if (dFk2 instanceof GYC) {
            return this.createVst3Device((GYC)dFk2);
        }
        if (dFk2 instanceof v1G) {
            return this.createVst2Device((v1G)dFk2);
        }
        if (dFk2 instanceof DK2) {
            return this.createBuiltinDevice((DK2)dFk2);
        }
        return null;
    }

    private ClapPlugin createClapDevice(Es es2) {
        ClapPlugin clapPlugin = new ClapPlugin();
        this.initPlugin(es2, (Plugin)clapPlugin);
        clapPlugin.deviceID = es2.A22().HaN();
        return clapPlugin;
    }

    private Vst3Plugin createVst3Device(GYC gYC) {
        Vst3Plugin vst3Plugin = new Vst3Plugin();
        this.initPlugin(gYC, (Plugin)vst3Plugin);
        vst3Plugin.deviceID = gYC.A22().HaN();
        return vst3Plugin;
    }

    private Vst2Plugin createVst2Device(v1G v1G2) {
        Vst2Plugin vst2Plugin = new Vst2Plugin();
        this.initPlugin(v1G2, (Plugin)vst2Plugin);
        return vst2Plugin;
    }

    private BuiltinDevice createBuiltinDeviceObject(DK2 dK2, ArrayList arrayList) {
        UUID uUID = dK2.cux().HaN();
        boolean bl2 = uUID.equals(rKC.SUJ);
        boolean bl3 = uUID.equals(rKC.mge);
        boolean bl4 = uUID.equals(rKC.P3);
        boolean bl5 = uUID.equals(rKC.wFl);
        boolean bl6 = uUID.equals(rKC.YMa);
        boolean bl7 = uUID.equals(rKC.RvW);
        boolean bl8 = uUID.equals(rKC.rhQ);
        if (bl2 || bl3) {
            return this.createEqualizer(dK2, bl2);
        }
        if (bl4) {
            return this.createEqualizerFromEQ2(dK2);
        }
        if (bl5) {
            return this.createCompressor(dK2);
        }
        if (bl8) {
            return this.createLimiter(dK2);
        }
        if (bl7) {
            return this.createGate(dK2);
        }
        return new BuiltinDevice();
    }

    private Compressor createCompressor(DK2 dK2) {
        Compressor compressor = new Compressor();
        compressor.inputGain = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "INPUT"));
        compressor.outputGain = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "OUTPUT"));
        compressor.threshold = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "THRESHOLD"));
        compressor.ratio = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "RATIO"), Unit.PERCENT);
        compressor.attack = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "ATTACK"));
        compressor.release = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "RELEASE"));
        compressor.autoMakeup = (BoolParameter)this.createParameter(this.getDeviceParameter(dK2, "MAKEUP_GAIN"));
        return compressor;
    }

    private Limiter createLimiter(DK2 dK2) {
        Limiter limiter = new Limiter();
        limiter.inputGain = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "GAIN"));
        limiter.threshold = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "CEILING"));
        limiter.release = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "RELEASE"));
        return limiter;
    }

    private NoiseGate createGate(DK2 dK2) {
        NoiseGate noiseGate = new NoiseGate();
        noiseGate.threshold = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "THRESHOLD_LEVEL"), Unit.DECIBEL);
        noiseGate.range = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "DEPTH"), Unit.DECIBEL, d2 -> -d2);
        noiseGate.attack = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "ATTACK"));
        noiseGate.release = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "RELEASE"));
        return noiseGate;
    }

    private Equalizer createEqualizerFromEQ2(DK2 dK2) {
        Equalizer equalizer = new Equalizer();
        String[] stringArray = new String[]{"LO_FREQ", "HI_FREQ"};
        String[] stringArray2 = new String[]{"LO_GAIN", "HI_GAIN"};
        String[] stringArray3 = new String[]{"LO_Q", "HI_Q"};
        String[] stringArray4 = new String[]{"TYPE1", "HI_TYPE"};
        String[] stringArray5 = new String[]{"LO_ENABLE", "HI_ENABLE"};
        for (int i2 = 0; i2 < 2; ++i2) {
            EqBand eqBand = new EqBand();
            eqBand.freq = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, stringArray[i2]));
            eqBand.gain = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, stringArray2[i2]));
            eqBand.Q = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, stringArray3[i2]));
            eqBand.enabled = (BoolParameter)this.createParameter((rez)dK2.EMg("CONTENTS/" + stringArray5[i2]));
            lxc lxc2 = lxc.w2Z(this.getIndexedValueAtom(dK2, stringArray4[i2]).rLM());
            eqBand.type = this.convertEqType(lxc2);
            eqBand.order = this.convertEqOrder(lxc2);
            if (eqBand.type == null) continue;
            equalizer.bands.add(eqBand);
        }
        return equalizer;
    }

    private Equalizer createEqualizer(DK2 dK2, boolean bl2) {
        Equalizer equalizer = new Equalizer();
        int n2 = bl2 ? 8 : 5;
        for (int i2 = 0; i2 < n2; ++i2) {
            EqBand eqBand = new EqBand();
            int n3 = i2 + 1;
            eqBand.freq = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "FREQ" + n3));
            eqBand.gain = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "GAIN" + n3));
            eqBand.Q = (RealParameter)this.createParameter(this.getDeviceParameter(dK2, "Q" + n3));
            eqBand.enabled = (BoolParameter)this.createParameter((rez)dK2.EMg("CONTENTS/ENABLE" + n3));
            lxc lxc2 = lxc.w2Z(this.getIndexedValueAtom(dK2, "TYPE" + n3).rLM());
            eqBand.type = this.convertEqType(lxc2);
            eqBand.order = this.convertEqOrder(lxc2);
            if (eqBand.type == null) continue;
            equalizer.bands.add(eqBand);
        }
        return equalizer;
    }

    private EqBandType convertEqType(lxc lxc2) {
        switch (lxc2) {
            case w2Z: {
                return null;
            }
            case BOK: 
            case HaN: 
            case rLM: 
            case bsM: 
            case KyJ: {
                return EqBandType.LOW_PASS;
            }
            case UN3: 
            case JEB: 
            case zxv: 
            case Bh1: 
            case r2: {
                return EqBandType.HIGH_PASS;
            }
            case cFc: 
            case OhK: {
                return EqBandType.BAND_PASS;
            }
            case Gox: {
                return EqBandType.BELL;
            }
            case gFf: {
                return EqBandType.NOTCH;
            }
            case GvW: {
                return EqBandType.LOW_SHELF;
            }
            case wFl: {
                return EqBandType.HIGH_SHELF;
            }
            case X3Z: {
                return null;
            }
        }
        return null;
    }

    private int convertEqOrder(lxc lxc2) {
        switch (lxc2) {
            case w2Z: 
            case X3Z: {
                return 0;
            }
            case KyJ: 
            case JEB: {
                return 1;
            }
            case BOK: 
            case UN3: 
            case cFc: 
            case Gox: 
            case gFf: 
            case GvW: 
            case wFl: {
                return 2;
            }
            case HaN: 
            case zxv: 
            case OhK: {
                return 4;
            }
            case rLM: 
            case Bh1: {
                return 6;
            }
            case bsM: 
            case r2: {
                return 8;
            }
        }
        return 0;
    }

    private uu getIndexedValueAtom(DK2 dK2, String string) {
        uu uu2 = (uu)dK2.EMg("CONTENTS/" + string);
        assert (bTj.rLM(uu2 != null));
        return uu2;
    }

    private rez getDeviceParameter(DK2 dK2, String string) {
        rez rez2 = (rez)dK2.EMg("CONTENTS/" + string);
        assert (bTj.rLM(rez2 != null));
        return rez2;
    }

    private BuiltinDevice createBuiltinDevice(DK2 dK2) {
        ArrayList arrayList = new ArrayList();
        BuiltinDevice builtinDevice = this.createBuiltinDeviceObject(dK2, arrayList);
        this.initDevice(dK2, (Device)builtinDevice);
        builtinDevice.deviceID = dK2.cux().HaN().toString();
        return builtinDevice;
    }

    private void initDevice(DFk dFk2, Device device) {
        device.name = this.nullIfEmpty(dFk2.h3k());
        device.deviceName = dFk2.stE();
        device.enabled = (BoolParameter)this.createParameter(dFk2.hRs());
        device.loaded = dFk2.sIK();
        device.deviceRole = switch (dFk2.FpH()) {
            default -> throw new MatchException(null, null);
            case lda.w2Z -> DeviceRole.AUDIO_FX;
            case lda.BOK -> DeviceRole.NOTE_FX;
            case lda.HaN -> DeviceRole.INSTRUMENT;
            case lda.rLM -> DeviceRole.ANALYZER;
        };
    }

    private void initPlugin(THL tHL, Plugin plugin) {
        this.initDevice(tHL, (Device)plugin);
        plugin.deviceID = tHL.A22().HaN();
        mfX mfX2 = tHL.ew();
        assert (bTj.KyJ(!mfX2.ElP()));
        File file = mfX2.csd();
        if (file != null && file.exists()) {
            plugin.state = new FileReference();
            plugin.state.path = "plugins/" + file.getName();
            this.embed(plugin.state.path, file);
        }
        for (qp qp2 : mfX2.agk()) {
            if (!qp2.FpH()) continue;
            plugin.automatedParameters.add(this.createParameter(qp2));
        }
    }

    File getFile(String string) {
        return new File(aTQ.Jpm(), string);
    }

    void embed(String string, File file) {
        if (!file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        this.mEmbeddedFiles.put(file, string);
    }
}

