/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.document.api.document;

import com.bitwig.base.geom.RZp;
import com.bitwig.base.io.NDZ;
import com.bitwig.base.io.liK;
import com.bitwig.base.serial.SerializationException;
import com.bitwig.dawproject.Arrangement;
import com.bitwig.dawproject.BoolParameter;
import com.bitwig.dawproject.Channel;
import com.bitwig.dawproject.ContentType;
import com.bitwig.dawproject.ExpressionType;
import com.bitwig.dawproject.FileReference;
import com.bitwig.dawproject.Interpolation;
import com.bitwig.dawproject.Lane;
import com.bitwig.dawproject.MixerRole;
import com.bitwig.dawproject.Parameter;
import com.bitwig.dawproject.Project;
import com.bitwig.dawproject.RealParameter;
import com.bitwig.dawproject.Referenceable;
import com.bitwig.dawproject.Scene;
import com.bitwig.dawproject.Send;
import com.bitwig.dawproject.TimeSignatureParameter;
import com.bitwig.dawproject.Track;
import com.bitwig.dawproject.Unit;
import com.bitwig.dawproject.device.ClapPlugin;
import com.bitwig.dawproject.device.Compressor;
import com.bitwig.dawproject.device.Device;
import com.bitwig.dawproject.device.EqBand;
import com.bitwig.dawproject.device.Equalizer;
import com.bitwig.dawproject.device.Limiter;
import com.bitwig.dawproject.device.NoiseGate;
import com.bitwig.dawproject.device.Vst2Plugin;
import com.bitwig.dawproject.device.Vst3Plugin;
import com.bitwig.dawproject.timeline.Audio;
import com.bitwig.dawproject.timeline.BoolPoint;
import com.bitwig.dawproject.timeline.Clip;
import com.bitwig.dawproject.timeline.ClipSlot;
import com.bitwig.dawproject.timeline.Clips;
import com.bitwig.dawproject.timeline.Lanes;
import com.bitwig.dawproject.timeline.Marker;
import com.bitwig.dawproject.timeline.Markers;
import com.bitwig.dawproject.timeline.Note;
import com.bitwig.dawproject.timeline.Notes;
import com.bitwig.dawproject.timeline.Point;
import com.bitwig.dawproject.timeline.Points;
import com.bitwig.dawproject.timeline.RealPoint;
import com.bitwig.dawproject.timeline.TimeSignaturePoint;
import com.bitwig.dawproject.timeline.TimeUnit;
import com.bitwig.dawproject.timeline.Timeline;
import com.bitwig.dawproject.timeline.Warp;
import com.bitwig.dawproject.timeline.Warps;
import com.bitwig.flt.device.InvalidDeviceIdException;
import com.bitwig.flt.device.OCP;
import com.bitwig.flt.device.QTJ;
import com.bitwig.flt.device.kln;
import com.bitwig.flt.device.nCp;
import com.bitwig.flt.document.api.document.ApiDawProjectImporter$ChannelConsumer;
import com.bitwig.flt.document.api.document.ApiDawProjectImporter$TrackConsumer;
import com.bitwig.flt.document.api.document.TimeTransforms;
import com.bitwig.flt.document.core.iface.SoS;
import com.bitwig.flt.document.core.master.JMV;
import com.bitwig.flt.document.core.master.LJS;
import com.bitwig.flt.document.core.master.REs;
import com.bitwig.flt.document.core.master.aYR;
import com.bitwig.flt.document.core.master.dPf;
import com.bitwig.flt.document.core.master.device.DFk;
import com.bitwig.flt.document.core.master.device.DK2;
import com.bitwig.flt.document.core.master.device.Es;
import com.bitwig.flt.document.core.master.device.GYC;
import com.bitwig.flt.document.core.master.device.v1G;
import com.bitwig.flt.document.core.master.uDX;
import com.bitwig.flt.document.core.master.ywn;
import com.bitwig.flt.document.file.TE1;
import com.bitwig.flt.packaging.core.rKC;
import com.bitwig.samplefile.S3g;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;

public class ApiDawProjectImporter {
    private final TimeTransforms mTimeTransforms;
    private final REs mProject;
    private final Project mDawProject;
    private final Function mStreamProvider;
    private final Map mTrackTrackMap = new HashMap();
    private final Map mChannelTrackMap = new HashMap();
    private xad mAudioNoteClipEvent;
    private wow mInstrumentNoteClipEvent;
    private final Stack mClipRange = new Stack();
    private final Stack mDawClip = new Stack();
    private final Stack mDawClipRange = new Stack();
    private final Stack mDawClipOutsideTimeUnit = new Stack();
    private final Stack mDawClipContentTimeUnit = new Stack();
    private final Stack mTrack = new Stack();
    private final Stack mTimeUnit = new Stack();
    private final Map mParameterMap = new HashMap();
    private Map mRealValueConverters = new HashMap();
    private final Stack mWarps = new Stack();
    private Ksw mScene;
    private JFM mInstrumentNoteEvent;
    private yDX mAudioNoteEvent;
    private final TE1 mProjectDir;
    private static jrv PLUGIN_VALUE_TYPE = jrv.BOK(0.0, 1.0, 0.0);
    private final File mDawProjectParentDir;

    public ApiDawProjectImporter(REs rEs, Project project, Function function, File file) {
        Referenceable.setAutoID((boolean)false);
        this.mProject = rEs;
        this.mDawProject = project;
        this.mStreamProvider = function;
        this.mDawProjectParentDir = file;
        this.mProjectDir = this.mProject.Bh1();
        assert (bTj.rLM(this.mProjectDir.w2Z().isDirectory()));
        this.mTimeTransforms = new TimeTransforms(rEs);
    }

    public void convertPhase1() {
        this.importTransport();
        this.createScenes();
        this.importTracks();
    }

    public void convertPhase2() {
        this.forEachTrack(this::importTrackSettings);
        this.forEachChannel(this::importChannelDevices);
        this.forEachChannel(this::importChannelSettings);
        this.importArrangement();
        this.importScenes();
    }

    private void importTransport() {
        if (this.mDawProject.transport == null) {
            return;
        }
        JeY jeY = this.mProject.WDD();
        this.importParameter(jeY.NW1(), (Parameter)this.mDawProject.transport.tempo);
        this.importParameter(jeY.NDH(), (Parameter)this.mDawProject.transport.timeSignature);
    }

    private void importTracks() {
        this.importTracks(this.mDawProject.structure, this.mProject.sYT());
        this.mProject.JuZ();
    }

    private void forEachTrack(ApiDawProjectImporter$TrackConsumer apiDawProjectImporter$TrackConsumer) {
        for (Map.Entry entry : this.mTrackTrackMap.entrySet()) {
            apiDawProjectImporter$TrackConsumer.accept((Track)entry.getKey(), ((ywn)entry.getValue()).SWi());
        }
    }

    private void forEachChannel(ApiDawProjectImporter$ChannelConsumer apiDawProjectImporter$ChannelConsumer) {
        for (Map.Entry entry : this.mChannelTrackMap.entrySet()) {
            apiDawProjectImporter$ChannelConsumer.accept((Channel)entry.getKey(), ((Eja)entry.getValue()).SWi());
        }
    }

    private void importTracks(List list, aYR aYR2) {
        for (Lane lane : list) {
            if (lane instanceof Track) {
                Track track = (Track)lane;
                if (!this.shouldCreateTrack(track)) continue;
                this.importTrackToTrackGroup(track, aYR2);
                continue;
            }
            if (!(lane instanceof Channel)) continue;
            Channel channel = (Channel)lane;
            this.importChannelToTrackGroup(channel, aYR2);
        }
    }

    private void importChannelToTrackGroup(Channel channel, aYR aYR2) {
        if (channel.role == MixerRole.MASTER) {
            this.assignChannelToResulting(aYR2.geP(), channel);
            return;
        }
        Eja eja = Eja.Xrv();
        eja.w2Z(G3V.BOK);
        if (channel.name != null && !channel.name.isEmpty()) {
            eja.e_(channel.name);
        }
        if (channel.color != null) {
            eja.w2Z(this.convertColor(channel.color));
        }
        this.assignChannelToResulting(eja, channel);
        if (channel.role == MixerRole.EFFECT_TRACK) {
            aYR2.BOK(Collections.singletonList(eja), aYR2.Euc(), false, null);
        } else if (channel.role != MixerRole.VCA) {
            aYR2.rLM(Collections.singletonList(eja), aYR2.b2x(), false, null);
        }
    }

    private boolean shouldCreateTrack(Track track) {
        return track.channel != null || track.tracks != null && !track.tracks.isEmpty();
    }

    private void importTrackToTrackGroup(Track track, aYR aYR2) {
        List<Object> list = track.contentType != null ? Arrays.asList(track.contentType) : Collections.emptyList();
        boolean bl2 = list.contains(ContentType.TRACKS);
        if (bl2) {
            aYR aYR3 = this.createGroupTrack();
            if (track.name != null) {
                aYR3.e_(track.name);
            }
            if (track.color != null) {
                aYR3.w2Z(this.convertColor(track.color));
            }
            aYR2.rLM(Collections.singletonList(aYR3), aYR2.b2x(), false, null);
            this.importTracks(track.tracks, aYR3);
            this.assignTrackToResulting(aYR3.geP(), track);
            return;
        }
        Channel channel = track.channel;
        if (channel == null) {
            Eja eja = this.createTrack(track);
            aYR2.rLM(Collections.singletonList(eja), aYR2.b2x(), false, null);
        } else {
            if (channel.role == MixerRole.MASTER) {
                this.assignTrackToResulting(aYR2.geP(), track);
                return;
            }
            if (channel.role == MixerRole.EFFECT_TRACK) {
                Eja eja = this.createTrack(track);
                aYR2.BOK(Collections.singletonList(eja), aYR2.Euc(), false, null);
            } else if (channel.role != MixerRole.VCA) {
                Eja eja = this.createTrack(track);
                aYR2.rLM(Collections.singletonList(eja), aYR2.b2x(), false, null);
            }
        }
    }

    private Eja createTrack(Track track) {
        Eja eja = Eja.Xrv();
        this.assignTrackToResulting(eja, track);
        if (track.contentType != null) {
            List<ContentType> list = Arrays.asList(track.contentType);
            if (list.contains(ContentType.AUDIO) && list.contains(ContentType.NOTES)) {
                eja.w2Z(G3V.HaN);
            } else if (list.contains(ContentType.NOTES)) {
                eja.w2Z(G3V.w2Z);
            } else if (list.contains(ContentType.AUDIO)) {
                eja.w2Z(G3V.BOK);
            } else {
                eja.w2Z(G3V.BOK);
            }
        }
        return eja;
    }

    private aYR createGroupTrack() {
        aYR aYR2 = aYR.Acb();
        return aYR2;
    }

    private void assignTrackToResulting(Eja eja, Track track) {
        if (this.mTrackTrackMap.containsKey(track)) {
            throw new IllegalArgumentException("Track already in map.");
        }
        this.mTrackTrackMap.put(track, eja);
        if (track.channel != null) {
            this.assignChannelToResulting(eja, track.channel);
        }
    }

    private void assignChannelToResulting(Eja eja, Channel channel) {
        if (this.mChannelTrackMap.containsKey(channel)) {
            throw new IllegalArgumentException("Channel already in map.");
        }
        this.mChannelTrackMap.put(channel, eja);
    }

    private void importTrackSettings(Track track, Eja eja) {
        if (track.name != null) {
            eja.e_(track.name);
        }
        if (track.comment != null) {
            eja.r2(track.comment);
        }
        if (track.color != null) {
            eja.w2Z(this.convertColor(track.color));
        }
        if (track.loaded != null) {
            eja.gFf(track.loaded);
        }
        Channel channel = track.channel;
    }

    private void importChannelSettings(Channel channel, Eja eja) {
        if (channel.solo != null) {
            eja.ZVP().BOK(channel.solo);
        }
        this.importParameter(eja.ZVP().GW1(), (Parameter)channel.volume);
        this.importParameter(eja.ZVP().xhT(), (Parameter)channel.pan);
        this.importParameter(eja.ZVP().FpH(), (Parameter)channel.mute);
        if (channel.sends != null) {
            for (Send send : channel.sends) {
                Eja eja2 = (Eja)this.mChannelTrackMap.get(send.destination);
                if (eja2 == null) continue;
                for (jUC jUC2 : eja.ZVP().agk()) {
                    if (jUC2.vlq() != eja2) continue;
                    this.importParameter(jUC2.Rss(), (Parameter)send.volume);
                    if (send.enable != null && send.enable.value != null) {
                        jUC2.w2Z(send.enable.value);
                        continue;
                    }
                    jUC2.w2Z(true);
                }
            }
        }
        if (channel.destination != null) {
            Eja eja3 = (Eja)this.mChannelTrackMap.get(channel.destination);
            if (eja3 == null) {
                throw new IllegalStateException("destinationTrack is not found for " + channel.destination.id);
            }
            eja.bUt().bsM(eja3.rc2());
        }
    }

    private void importChannelDevices(Channel channel, Eja eja) {
        if (channel == null || channel.devices == null) {
            return;
        }
        for (Device device : channel.devices) {
            DFk dFk2 = this.importDevice(device);
            if (dFk2 == null) continue;
            eja.LVD().BOK(dFk2);
            this.importDeviceSettings(device, dFk2);
        }
    }

    private void importDeviceSettings(Device device, DFk dFk2) {
        if (device.enabled != null) {
            this.importParameter(dFk2.hRs(), (Parameter)device.enabled);
        }
        if (device.loaded != null) {
            dFk2.w2Z(device.loaded);
        }
    }

    private DFk importDevice(Device device) {
        if (device instanceof ClapPlugin) {
            ClapPlugin clapPlugin = (ClapPlugin)device;
            return this.createClapPlugin(clapPlugin);
        }
        if (device instanceof Vst3Plugin) {
            Vst3Plugin vst3Plugin = (Vst3Plugin)device;
            return this.createVst3Plugin(vst3Plugin);
        }
        if (device instanceof Vst2Plugin) {
            Vst2Plugin vst2Plugin = (Vst2Plugin)device;
            return this.createVst2Plugin(vst2Plugin);
        }
        if (device instanceof Equalizer) {
            Equalizer equalizer = (Equalizer)device;
            return this.createEqualizer(equalizer);
        }
        if (device instanceof Limiter) {
            Limiter limiter = (Limiter)device;
            return this.createLimiter(limiter);
        }
        if (device instanceof Compressor) {
            Compressor compressor = (Compressor)device;
            return this.createCompressor(compressor);
        }
        if (device instanceof NoiseGate) {
            NoiseGate noiseGate = (NoiseGate)device;
            return this.createNoiseGate(noiseGate);
        }
        return null;
    }

    private uDX create(Audio audio) {
        if (audio.file != null) {
            InputStream inputStream;
            File file = this.mProject.Bh1().BOK(audio.file.path);
            if (!file.exists() && (inputStream = (InputStream)this.mStreamProvider.apply(audio.file.path)) != null) {
                this.copyFileToProjectDir(inputStream, file);
            }
            if (file.exists()) {
                return this.createSampleReference(file);
            }
        }
        return null;
    }

    private GYC createVst3Plugin(Vst3Plugin vst3Plugin) {
        if (vst3Plugin.id == null) {
            return null;
        }
        if (vst3Plugin.state == null) {
            return null;
        }
        try {
            Object object;
            OCP oCP = (OCP)nCp.BOK("vst3:" + vst3Plugin.deviceID);
            String string = new File(vst3Plugin.state.path).getName();
            File file = new File(aTQ.Jpm(), string);
            if (!file.exists() && (object = this.resolve(vst3Plugin.state)) != null) {
                this.copyFileToProjectDir((InputStream)object, file);
            }
            object = vst3Plugin.deviceName != null ? vst3Plugin.deviceName : "";
            String string2 = vst3Plugin.pluginVersion != null ? vst3Plugin.pluginVersion : "";
            GYC gYC = GYC.w2Z((String)object, oCP, string2, file);
            for (Parameter parameter : vst3Plugin.automatedParameters) {
                String string3 = "CONTENTS/PID" + Integer.toHexString(parameter.parameterID);
                dPf dPf2 = dPf.w2Z(gYC, string3, PLUGIN_VALUE_TYPE);
                this.mParameterMap.put(parameter, dPf2);
            }
            return gYC;
        }
        catch (InvalidDeviceIdException invalidDeviceIdException) {
            throw new IOException(invalidDeviceIdException);
        }
    }

    private Es createClapPlugin(ClapPlugin clapPlugin) {
        if (clapPlugin.id == null) {
            return null;
        }
        if (clapPlugin.state == null) {
            return null;
        }
        try {
            Object object;
            kln kln2 = (kln)nCp.BOK("clap:" + clapPlugin.deviceID);
            String string = new File(clapPlugin.state.path).getName();
            File file = new File(aTQ.Jpm(), string);
            if (!file.exists() && (object = this.resolve(clapPlugin.state)) != null) {
                this.copyFileToProjectDir((InputStream)object, file);
            }
            object = clapPlugin.deviceName != null ? clapPlugin.deviceName : "";
            String string2 = clapPlugin.pluginVersion != null ? clapPlugin.pluginVersion : "";
            Es es2 = Es.w2Z((String)object, kln2, string2, file);
            for (Parameter parameter : clapPlugin.automatedParameters) {
                String string3 = "CONTENTS/PID" + Integer.toHexString(parameter.parameterID);
                dPf dPf2 = dPf.w2Z(es2, string3, PLUGIN_VALUE_TYPE);
                this.mParameterMap.put(parameter, dPf2);
            }
            return es2;
        }
        catch (InvalidDeviceIdException invalidDeviceIdException) {
            throw new IOException(invalidDeviceIdException);
        }
    }

    private v1G createVst2Plugin(Vst2Plugin vst2Plugin) {
        if (vst2Plugin.id == null) {
            return null;
        }
        if (vst2Plugin.state == null) {
            return null;
        }
        try {
            QTJ qTJ = (QTJ)nCp.BOK("vst:" + vst2Plugin.deviceID);
            String string = new File(vst2Plugin.state.path).getName();
            File file = new File(aTQ.Jpm(), string);
            if (!file.exists()) {
                this.copyFileToProjectDir(this.resolve(vst2Plugin.state), file);
            }
            String string2 = vst2Plugin.deviceName != null ? vst2Plugin.deviceName : "";
            int n2 = vst2Plugin.pluginVersion != null ? Integer.parseInt(vst2Plugin.pluginVersion) : 0;
            v1G v1G2 = v1G.w2Z(string2, qTJ, n2, file);
            for (Parameter parameter : vst2Plugin.automatedParameters) {
                String string3 = "CONTENTS/PARAM" + parameter.parameterID;
                dPf dPf2 = dPf.w2Z(v1G2, string3, PLUGIN_VALUE_TYPE);
                this.mParameterMap.put(parameter, dPf2);
            }
            return v1G2;
        }
        catch (SerializationException | InvalidDeviceIdException rKM) {
            throw new IOException(rKM);
        }
    }

    private DK2 createEqualizer(Equalizer equalizer) {
        try {
            DK2 dK2 = DK2.UN3(rKC.SUJ);
            int n2 = 1;
            for (EqBand eqBand : equalizer.bands) {
                lxc lxc2 = this.getFilterType(eqBand);
                if (lxc2 == null) continue;
                if (eqBand.freq != null) {
                    this.importParameter(dK2, "FREQ" + n2, (Parameter)eqBand.freq);
                }
                if (eqBand.gain != null) {
                    this.importParameter(dK2, "GAIN" + n2, (Parameter)eqBand.gain);
                }
                if (eqBand.Q != null) {
                    this.importParameter(dK2, "Q" + n2, (Parameter)eqBand.Q);
                }
                if (eqBand.enabled != null) {
                    this.importParameter(dK2, "ENABLE" + n2, (Parameter)eqBand.enabled);
                }
                uu uu2 = (uu)dK2.EMg("CONTENTS/TYPE" + n2);
                uu2.w2Z(lxc2.w2Z());
                if (++n2 <= 8) continue;
                break;
            }
            return dK2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private DK2 createLimiter(Limiter limiter) {
        try {
            DK2 dK2 = DK2.UN3(rKC.rhQ);
            if (limiter.inputGain != null) {
                this.importParameter(dK2, "GAIN", (Parameter)limiter.inputGain);
            }
            if (limiter.threshold != null) {
                this.importParameter(dK2, "CEILING", (Parameter)limiter.threshold);
            }
            if (limiter.release != null) {
                this.importParameter(dK2, "RELEASE", (Parameter)limiter.release);
            }
            return dK2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private DK2 createCompressor(Compressor compressor) {
        try {
            DK2 dK2 = DK2.UN3(rKC.wFl);
            if (compressor.inputGain != null) {
                this.importParameter(dK2, "INPUT", (Parameter)compressor.inputGain);
            }
            if (compressor.outputGain != null) {
                this.importParameter(dK2, "OUTPUT", (Parameter)compressor.outputGain);
            }
            if (compressor.threshold != null) {
                this.importParameter(dK2, "THRESHOLD", (Parameter)compressor.threshold);
            }
            if (compressor.ratio != null) {
                this.importParameter(dK2, "RATIO", (Parameter)compressor.ratio);
            }
            if (compressor.attack != null) {
                this.importParameter(dK2, "ATTACK", (Parameter)compressor.attack);
            }
            if (compressor.release != null) {
                this.importParameter(dK2, "RELEASE", (Parameter)compressor.release);
            }
            if (compressor.autoMakeup != null) {
                this.importParameter(dK2, "MAKEUP_GAIN", (Parameter)compressor.autoMakeup);
            }
            return dK2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private DK2 createNoiseGate(NoiseGate noiseGate) {
        try {
            DK2 dK2 = DK2.UN3(rKC.RvW);
            if (noiseGate.threshold != null) {
                this.importParameter(dK2, "THRESHOLD_LEVEL", (Parameter)noiseGate.threshold);
            }
            if (noiseGate.range != null) {
                this.importParameter(dK2, "DEPTH", (Parameter)noiseGate.range, d2 -> -d2);
            }
            return dK2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private lxc getFilterType(EqBand eqBand) {
        if (eqBand.type == null) {
            return null;
        }
        int n2 = eqBand.order != null ? eqBand.order : 2;
        switch (eqBand.type) {
            case HIGH_PASS: {
                if (n2 >= 8) {
                    return lxc.r2;
                }
                if (n2 >= 6) {
                    return lxc.Bh1;
                }
                if (n2 >= 4) {
                    return lxc.zxv;
                }
                if (n2 == 1) {
                    return lxc.JEB;
                }
                return lxc.UN3;
            }
            case LOW_PASS: {
                if (n2 >= 8) {
                    return lxc.bsM;
                }
                if (n2 >= 6) {
                    return lxc.rLM;
                }
                if (n2 >= 4) {
                    return lxc.HaN;
                }
                if (n2 == 1) {
                    return lxc.KyJ;
                }
                return lxc.BOK;
            }
            case HIGH_SHELF: {
                return lxc.wFl;
            }
            case LOW_SHELF: {
                return lxc.GvW;
            }
            case BELL: {
                return lxc.Gox;
            }
            case NOTCH: {
                return lxc.gFf;
            }
        }
        return null;
    }

    private void importParameter(DFk dFk2, String string, Parameter parameter, DoubleUnaryOperator doubleUnaryOperator) {
        this.mRealValueConverters.put(parameter, doubleUnaryOperator);
        this.importParameter(dFk2, string, parameter);
    }

    private void importParameter(DFk dFk2, String string, Parameter parameter) {
        rez rez2 = (rez)dFk2.EMg("CONTENTS/" + string);
        assert (bTj.rLM(rez2 != null));
        this.importParameter(rez2, parameter);
    }

    private void importParameter(rez rez2, Parameter parameter) {
        if (parameter == null) {
            return;
        }
        if (rez2 instanceof Vbx && parameter instanceof BoolParameter) {
            this.importBoolParameter((Vbx)rez2, (BoolParameter)parameter);
        } else if (rez2 instanceof dpW && parameter instanceof RealParameter) {
            this.importRealParameter((dpW)rez2, (RealParameter)parameter);
        } else if (rez2 instanceof scM && parameter instanceof TimeSignatureParameter) {
            this.importTimeSignatureParameter((scM)rez2, (TimeSignatureParameter)parameter);
        }
        this.mParameterMap.put(parameter, JMV.w2Z(rez2));
    }

    private void importBoolParameter(Vbx vbx, BoolParameter boolParameter) {
        if (boolParameter.value != null) {
            vbx.w2Z(boolParameter.value);
        }
    }

    private void importRealParameter(dpW dpW2, RealParameter realParameter) {
        if (realParameter.value != null) {
            DoubleUnaryOperator doubleUnaryOperator = (DoubleUnaryOperator)this.mRealValueConverters.get(realParameter);
            double d2 = doubleUnaryOperator != null ? doubleUnaryOperator.applyAsDouble(realParameter.value) : realParameter.value.doubleValue();
            dpW2.gFf(this.convertRealValue(d2, realParameter.unit, dpW2.h3k()));
        }
    }

    private void importTimeSignatureParameter(scM scM2, TimeSignatureParameter timeSignatureParameter) {
        if (timeSignatureParameter.numerator != null && timeSignatureParameter.denominator != null) {
            int n2 = vrX.w2Z(timeSignatureParameter.numerator, timeSignatureParameter.denominator, 16);
            scM2.OhK(n2);
        }
    }

    private double convertRealValue(double d2, Unit unit, jrv jrv2) {
        double d3 = unit == Unit.NORMALIZED ? jrv2.BOK(d2) : KJ.w2Z(d2, this.convertUnit(unit), jrv2.gFf());
        return nBT.BOK(d3, jrv2.KyJ(), jrv2.JEB());
    }

    private oVe convertUnit(Unit unit) {
        if (unit == null) {
            return oVe.w2Z;
        }
        switch (unit) {
            case LINEAR: {
                return oVe.w2Z;
            }
            case NORMALIZED: {
                throw new IllegalStateException("Needs context of value type");
            }
            case PERCENT: {
                return oVe.BOK;
            }
            case DECIBEL: {
                return oVe.rLM;
            }
            case HERTZ: {
                return oVe.UN3;
            }
            case SEMITONES: {
                return oVe.JEB;
            }
            case SECONDS: {
                return oVe.bsM;
            }
            case BEATS: {
                return oVe.cFc;
            }
            case BPM: {
                return oVe.r2;
            }
        }
        return oVe.w2Z;
    }

    private void importArrangement() {
        Arrangement arrangement = this.mDawProject.arrangement;
        JeY jeY = this.mProject.WDD();
        if (arrangement != null) {
            if (arrangement.tempoAutomation != null) {
                this.importAutomationForAtom(JMV.w2Z(jeY.NW1()), arrangement.tempoAutomation);
            }
            if (arrangement.timeSignatureAutomation != null) {
                this.importAutomationForAtom(JMV.w2Z(jeY.NDH()), arrangement.timeSignatureAutomation);
            }
            if (arrangement.markers != null) {
                this.importMarkers(arrangement.markers);
            }
            this.mTimeUnit.push(TimeUnit.BEATS);
            if (arrangement.lanes != null) {
                this.importTimeline((Timeline)arrangement.lanes);
            }
            this.mTimeUnit.pop();
        }
    }

    private double getTimeAsBeats(double d2) {
        if (!this.mTimeUnit.isEmpty() && this.mTimeUnit.peek() == TimeUnit.SECONDS) {
            return this.mProject.Bh1(d2);
        }
        return d2;
    }

    private double getTimeAsSeconds(double d2) {
        if (!this.mTimeUnit.isEmpty() && this.mTimeUnit.peek() == TimeUnit.BEATS) {
            return this.mProject.zxv(d2);
        }
        return d2;
    }

    private double getClipTimeAsBeats(vCl vCl2, double d2) {
        if (!this.mDawClipContentTimeUnit.isEmpty() && this.mDawClipContentTimeUnit.peek() == TimeUnit.SECONDS) {
            if (vCl2.AqJ()) {
                return this.mProject.Bh1(d2);
            }
            double d3 = this.mProject.zxv(vCl2.aG2());
            return this.mProject.Bh1(d3 + d2) - vCl2.aG2();
        }
        return d2;
    }

    protected void createScenes() {
        if (this.mDawProject.scenes == null) {
            return;
        }
        this.mProject.sYT().agk(this.mDawProject.scenes.size());
    }

    private void importScenes() {
        if (this.mDawProject.scenes == null) {
            return;
        }
        int n2 = 0;
        for (Scene scene : this.mDawProject.scenes) {
            this.importScene(scene, this.mProject.sYT().Jec(n2++));
        }
    }

    private void importScene(Scene scene, Ksw ksw) {
        if (scene.name != null) {
            ksw.BOK(scene.name);
        }
        if (scene.comment != null) {
            ksw.Bh1(scene.comment);
        }
        if (scene.color != null) {
            ksw.rLM(this.convertColor(scene.color));
        }
        this.mScene = ksw;
        this.mTimeUnit.push(TimeUnit.BEATS);
        this.importTimeline(scene.content);
        this.mTimeUnit.pop();
        this.mScene = null;
    }

    private void importTimeline(Timeline timeline) {
        ywn ywn2;
        TimeUnit timeUnit = (TimeUnit)this.mTimeUnit.peek();
        if (timeline.timeUnit != null) {
            this.mTimeUnit.push(timeline.timeUnit);
        }
        if (timeline.track != null && this.shouldCreateTrack(timeline.track)) {
            ywn2 = (ywn)this.mTrackTrackMap.get(timeline.track);
            if (ywn2 == null) {
                throw new IOException("Importing timeline to track, but track with id " + timeline.track.id + " not imported yet.");
            }
            this.mTrack.push(ywn2.SWi());
        }
        if (timeline instanceof Lanes) {
            this.importLanes((Lanes)timeline);
        } else if (timeline instanceof Clips) {
            this.importClips((Clips)timeline);
        } else if (timeline instanceof Markers) {
            this.importMarkers((Markers)timeline);
        } else if (timeline instanceof Warps) {
            ywn2 = (Warps)timeline;
            this.importWarps((Warps)ywn2, timeUnit);
        } else if (timeline instanceof Notes) {
            this.importNotes((Notes)timeline);
        } else if (timeline instanceof Audio) {
            this.importAudio((Audio)timeline);
        } else if (timeline instanceof Points) {
            this.importPoints((Points)timeline);
        } else if (timeline instanceof ClipSlot) {
            this.importClipSlot((ClipSlot)timeline);
        }
        if (timeline.track != null && this.shouldCreateTrack(timeline.track)) {
            this.mTrack.pop();
        }
        if (timeline.timeUnit != null) {
            this.mTimeUnit.pop();
        }
    }

    private void importLanes(Lanes lanes) {
        for (Timeline timeline : lanes.lanes) {
            this.importTimeline(timeline);
        }
    }

    private void importClipSlot(ClipSlot clipSlot) {
        Zea zea;
        Eja eja = (Eja)this.mTrack.peek();
        Zea zea2 = zea = this.mScene != null && eja != null ? eja.HaN(this.mScene.i2U()) : null;
        if (zea != null) {
            if (clipSlot.hasStop != null) {
                zea.f_(clipSlot.hasStop);
            }
            if (clipSlot.clip != null) {
                this.importClip(clipSlot.clip);
            }
        }
    }

    private void importClips(Clips clips) {
        for (Clip clip : clips.clips) {
            this.importClip(clip);
        }
    }

    private void importClip(Clip clip) {
        RZp rZp;
        double d2 = this.getTimeAsBeats(clip.time);
        boolean bl2 = clip.duration != null && clip.duration > 0.0;
        double d3 = bl2 ? this.getTimeAsBeats(clip.time + clip.duration) : this.estimateClipEndTimeFromContent(d2, clip);
        this.mDawClip.push(clip);
        this.mDawClipRange.push(new RZp(d2, d3));
        if (this.mDawClip.size() > 1) {
            rZp = this.mClipRange.isEmpty() ? null : (RZp)this.mClipRange.peek();
            RZp rZp2 = rZp != null ? new RZp(Math.max(d2, rZp.w2Z()), Math.min(d3, rZp.BOK())) : new RZp(d2, d3);
            this.mClipRange.push(rZp2);
        }
        this.mDawClipOutsideTimeUnit.push((TimeUnit)this.mTimeUnit.peek());
        if (clip.contentTimeUnit != null) {
            this.mTimeUnit.push(clip.contentTimeUnit);
        }
        this.mDawClipContentTimeUnit.push((TimeUnit)this.mTimeUnit.peek());
        Object object = rZp = clip.content != null ? clip.content : clip.reference;
        if (rZp != null) {
            this.importTimeline((Timeline)rZp);
        }
        if (clip.contentTimeUnit != null) {
            this.mTimeUnit.pop();
        }
        if (this.mDawClip.size() > 1) {
            this.mClipRange.pop();
        }
        this.mDawClip.pop();
        this.mDawClipRange.pop();
        this.mDawClipOutsideTimeUnit.pop();
        this.mDawClipContentTimeUnit.pop();
        this.mAudioNoteEvent = null;
        if (this.mDawClip.isEmpty()) {
            if (this.mInstrumentNoteClipEvent != null) {
                this.addClipToTimelineOrScene(this.mInstrumentNoteClipEvent, clip);
            }
            if (this.mAudioNoteClipEvent != null) {
                this.addClipToTimelineOrScene(this.mAudioNoteClipEvent, clip);
            }
            this.mAudioNoteClipEvent = null;
            this.mInstrumentNoteClipEvent = null;
        }
    }

    private double estimateClipEndTimeFromContent(double d2, Clip clip) {
        double d3 = clip.playStop != null ? clip.playStop : 0.0;
        double d4 = clip.playStart != null ? clip.playStart : 0.0;
        double d5 = d3 - d4;
        if (clip.contentTimeUnit == TimeUnit.SECONDS && !this.mTimeUnit.isEmpty() && this.mTimeUnit.peek() == TimeUnit.BEATS) {
            return this.mProject.Bh1(this.mProject.zxv(d2) + d5);
        }
        return this.getTimeAsBeats(clip.time + d5);
    }

    private void importMarkers(Markers markers) {
        PHm pHm = this.mProject.sYT().VvU().P3();
        this.mTimeUnit.push(markers.timeUnit);
        for (Marker marker : markers.markers) {
            double d2 = Df.bsM(this.getTimeAsBeats(marker.time));
            zLc zLc2 = zLc.rLM(d2);
            if (marker.name != null) {
                zLc2.w2Z(marker.name);
            }
            if (marker.color != null) {
                zLc2.w2Z(this.convertColor(marker.color));
            }
            pHm.HaN(zLc2);
        }
        this.mTimeUnit.pop();
    }

    private void importWarps(Warps warps, TimeUnit timeUnit) {
        if (warps.contentTimeUnit == null) {
            throw new NDZ("Warps must define a contentTimeUnit");
        }
        if (warps.events == null) {
            throw new NDZ("Warps must define events");
        }
        if (warps.events.isEmpty()) {
            throw new NDZ("Warps must contain events");
        }
        this.mWarps.push(new qvP(warps, timeUnit));
        this.mTimeUnit.push(warps.contentTimeUnit);
        this.importTimeline(warps.content);
        this.mTimeUnit.pop();
        this.mWarps.pop();
    }

    private double localSecondsToBeats(double d2) {
        return this.getTimeAsBeats(d2);
    }

    private void importAudio(Audio audio) {
        yDX yDX2;
        double d2;
        Object object;
        Object object2;
        if (this.mDawClip.size() < 1) {
            return;
        }
        if (this.mAudioNoteClipEvent == null) {
            object2 = (Clip)this.mDawClip.get(0);
            object = (RZp)this.mDawClipRange.get(0);
            this.mAudioNoteClipEvent = xad.w2Z(Df.bsM(((RZp)object).w2Z()), Df.KyJ(((RZp)object).bsM()));
            this.importClipSettings((Clip)object2, this.mAudioNoteClipEvent);
            this.requireTrackForTimeline((Timeline)audio);
        }
        object2 = this.mAudioNoteClipEvent.DYI().BOK(true);
        object = this.createSampleReference(audio);
        if (object == null) {
            return;
        }
        qvP qvP2 = this.mWarps.isEmpty() ? null : (qvP)this.mWarps.peek();
        Warps warps = qvP2 != null ? (Warps)qvP2.w2Z() : null;
        TimeUnit timeUnit = qvP2 != null ? (TimeUnit)qvP2.BOK() : null;
        RZp rZp = this.mClipRange.isEmpty() ? null : (RZp)this.mClipRange.peek();
        double d3 = rZp != null ? rZp.w2Z() : 0.0;
        double d4 = d2 = rZp != null ? rZp.bsM() : this.mAudioNoteClipEvent.eN1();
        if (warps != null) {
            double d5 = ((Warp)warps.events.get((int)(warps.events.size() - 1))).time;
            d2 = Math.min(d2, timeUnit == TimeUnit.SECONDS ? this.localSecondsToBeats(d5) : d5);
        }
        this.mAudioNoteEvent = yDX2 = yDX.w2Z(Df.bsM(d3), Df.KyJ(d2), (uDX)object);
        Clip clip = (Clip)this.mDawClip.peek();
        if (warps != null) {
            S3g s3g = new S3g(warps.events.size());
            for (Warp warp : warps.events) {
                s3g.w2Z(timeUnit == TimeUnit.SECONDS ? this.localSecondsToBeats(warp.time) : warp.time, warp.contentTime);
            }
            yDX2.gBA().w2Z(s3g);
            yDX2.w2Z(LVK.BOK);
            if (clip.playStart != null) {
                yDX2.Bh1(clip.playStart);
            }
        } else {
            yDX2.w2Z(LVK.w2Z);
            if (clip.playStart != null) {
                yDX2.Bh1(this.getTimeAsSeconds(clip.playStart));
            }
            if (clip.playStop != null) {
                yDX2.P3(this.getTimeAsSeconds(clip.playStop));
            }
        }
        if (clip.fadeInTime != null) {
            yDX2.w2Z(this.getTimeAsBeats(clip.fadeInTime));
        }
        if (clip.fadeOutTime != null) {
            yDX2.HaN(this.getTimeAsBeats(clip.fadeOutTime));
        }
        ((UbK)object2).HaN(yDX2);
    }

    private void requireTrackForTimeline(Timeline timeline) {
        if (this.mTrack.isEmpty()) {
            throw new IOException("Importing timeline with id " + timeline.id + " to track, but track is not specified.");
        }
    }

    private uDX createSampleReference(Audio audio) {
        if (audio.file != null) {
            InputStream inputStream;
            if (audio.file.path == null || audio.file.path.isEmpty()) {
                throw new IOException("FileReference path cannot be empty.");
            }
            if (Boolean.TRUE.equals(audio.file.external)) {
                File file = new File(audio.file.path);
                if (file.isAbsolute()) {
                    return this.createSampleReference(file);
                }
                File file2 = new File(this.mDawProjectParentDir, audio.file.path);
                if (file2.exists()) {
                    return this.createSampleReference(file2);
                }
                return this.createMissingSampleReference(audio);
            }
            File file = this.mProject.Bh1().BOK(audio.file.path);
            if (!file.exists() && (inputStream = this.resolve(audio.file)) != null) {
                this.copyFileToProjectDir(inputStream, file);
            }
            if (file.exists()) {
                return this.createSampleReference(file);
            }
        }
        return null;
    }

    InputStream resolve(FileReference fileReference) {
        return (InputStream)this.mStreamProvider.apply(fileReference.path);
    }

    private void copyFileToProjectDir(InputStream inputStream, File file) {
        assert (bTj.rLM(this.mProject.Bh1().w2Z().exists()));
        assert (bTj.rLM(!file.exists()));
        file.getParentFile().mkdirs();
        Files.copy(inputStream, file.toPath(), new CopyOption[0]);
        inputStream.close();
    }

    private uDX createSampleReference(File file) {
        return uDX.w2Z(new liK(file));
    }

    private uDX createMissingSampleReference(Audio audio) {
        if (audio.file.path == null) {
            return null;
        }
        String string = audio.name != null ? audio.name : new File(audio.file.path).getName();
        uDX uDX2 = uDX.w2Z(string, "", audio.duration, audio.sampleRate, audio.channels);
        LJS.w2Z(audio.file.path, uDX2, 0L);
        return uDX2;
    }

    private void importNotes(Notes notes) {
        if (this.mDawClip.size() < 1) {
            return;
        }
        if (this.mInstrumentNoteClipEvent == null) {
            Clip clip = (Clip)this.mDawClip.get(0);
            Object object = (RZp)this.mDawClipRange.get(0);
            this.mInstrumentNoteClipEvent = wow.w2Z(Df.bsM(((RZp)object).w2Z()), Df.KyJ(((RZp)object).bsM()));
            this.importClipSettings(clip, this.mInstrumentNoteClipEvent);
        }
        for (Object object : notes.notes) {
            this.importNote((Note)object);
        }
    }

    private void importNote(Note note) {
        double d2 = this.getTimeAsBeats(note.time);
        double d3 = this.getTimeAsBeats(note.time + note.duration);
        JFM jFM = JFM.rLM(Df.bsM(d2), Df.KyJ(d3 - d2));
        if (note.velocity != null) {
            jFM.w2Z(note.velocity);
        }
        if (note.releaseVelocity != null) {
            jFM.BOK(note.releaseVelocity);
        }
        this.mInstrumentNoteEvent = jFM;
        if (note.content != null) {
            this.importTimeline(note.content);
        }
        this.mInstrumentNoteEvent = null;
        this.mInstrumentNoteClipEvent.BOK(jFM, null, note.channel, note.key);
    }

    private void addClipToTimelineOrScene(XB xB2, Clip clip) {
        Eja eja = (Eja)this.mTrack.peek();
        if (eja != null) {
            if (clip.enable != null) {
                xB2.zxv(clip.enable == false);
            }
            if (this.mScene != null) {
                eja.HaN(this.mScene.i2U()).BOK((UwT)xB2);
            } else {
                eja.Fe().Jpm().HaN((ngJ)xB2);
                List list = xB2.Acb().tZS();
                for (gJP gJP2 : list) {
                    eja.w2Z(gJP2.BD(), xB2, false, true);
                }
            }
        }
    }

    private g3 getArrangement() {
        return this.mProject.sYT().VvU();
    }

    private void importClipSettings(Clip clip, XB xB2) {
        if (clip.name != null) {
            xB2.w2Z(clip.name);
        }
        if (clip.color != null) {
            xB2.rLM(this.convertColor(clip.color));
        }
        if (clip.playStart != null) {
            xB2.OyU(this.getClipTimeAsBeats(xB2, clip.playStart));
        }
        if (clip.loopStart != null) {
            xB2.mun().OhK(this.getClipTimeAsBeats(xB2, clip.loopStart));
        }
        if (clip.loopEnd != null) {
            xB2.mun().Gox(this.getClipTimeAsBeats(xB2, clip.loopEnd));
        }
        if (clip.loopStart != null && clip.loopEnd != null) {
            xB2.fzc(true);
        }
        if (xB2 instanceof xad) {
            xad xad2 = (xad)xB2;
            if (clip.fadeInTime != null) {
                xad2.w2Z(clip.fadeInTime);
            }
            if (clip.fadeOutTime != null) {
                xad2.HaN(clip.fadeOutTime);
            }
        }
    }

    private void importPoints(Points points) {
        OUa oUa = this.mInstrumentNoteEvent != null ? this.mInstrumentNoteEvent : this.mAudioNoteEvent;
        Eja eja = this.mTrack.isEmpty() ? null : (Eja)this.mTrack.peek();
        ExpressionType expressionType = points.target.expression;
        if (expressionType != null) {
            if (oUa != null) {
                this.importNoteExpression(points, oUa);
            } else if (eja != null) {
                deQ deQ2 = eja.JkO();
                if (expressionType == ExpressionType.CHANNEL_CONTROLLER) {
                    mh mh2 = deQ2.w2Z(points.target.channel, gJ.HaN, (int)points.target.controller);
                    this.importAutomationForAtom(JMV.w2Z(mh2), points);
                } else if (expressionType == ExpressionType.CHANNEL_PRESSURE) {
                    mh mh3 = deQ2.w2Z(points.target.channel, gJ.BOK, 0);
                    this.importAutomationForAtom(JMV.w2Z(mh3), points);
                } else if (expressionType == ExpressionType.PITCH_BEND) {
                    mh mh4 = deQ2.w2Z(points.target.channel, gJ.w2Z, 0);
                    this.importAutomationForAtom(JMV.w2Z(mh4), points);
                }
            }
        } else if (points.target.parameter != null) {
            this.importAutomation(points);
        }
    }

    private void importNoteExpression(Points points, OUa oUa) {
        String string = this.getExpressionName(points.target.expression);
        if (string == null) {
            return;
        }
        Ggn ggn = oUa.OLz().BOK(string, true);
        this.insertPoints(points, ggn);
    }

    private void importAutomation(Points points) {
        JMV jMV = (JMV)this.mParameterMap.get(points.target.parameter);
        if (jMV == null) {
            return;
        }
        this.importAutomationForAtom(jMV, points);
    }

    private qHY createRealEvent(double d2, double d3, jrv jrv2) {
        if (jrv2 instanceof awl) {
            return cTN.HaN(Df.bsM(d2), d3);
        }
        return qHY.w2Z(Df.bsM(d2), d3);
    }

    private void insertPoints(Points points, yis yis2) {
        Double d2 = null;
        double d3 = 0.0;
        uyZ uyZ2 = yis2.aH_();
        for (Point point : points.points) {
            Object object;
            TimeSignaturePoint timeSignaturePoint;
            double d4 = this.getTimeAsBeats(point.time);
            if (point instanceof RealPoint) {
                RealPoint realPoint = (RealPoint)point;
                if (uyZ2 instanceof jrv) {
                    boolean bl2;
                    DoubleUnaryOperator doubleUnaryOperator;
                    timeSignaturePoint = points.unit != null ? points.unit : (points.target.parameter instanceof RealParameter ? ((RealParameter)points.target.parameter).unit : null);
                    jrv jrv2 = (jrv)uyZ2;
                    object = realPoint.value;
                    if (points.target.parameter instanceof RealParameter && (doubleUnaryOperator = (DoubleUnaryOperator)this.mRealValueConverters.get(points.target.parameter)) != null) {
                        object = doubleUnaryOperator.applyAsDouble((Double)object);
                    }
                    double d5 = this.convertRealValue((Double)object, (Unit)timeSignaturePoint, jrv2);
                    boolean bl3 = bl2 = realPoint.interpolation != Interpolation.LINEAR;
                    if (bl2 && d2 != null && d4 > d3) {
                        yis2.HaN(this.createRealEvent(d4, d2, jrv2));
                    }
                    yis2.HaN(this.createRealEvent(d4, d5, jrv2));
                    d2 = d5;
                    d3 = d4;
                    continue;
                }
            }
            if (point instanceof TimeSignaturePoint && uyZ2 instanceof gfb) {
                timeSignaturePoint = (TimeSignaturePoint)point;
                int n2 = vrX.w2Z(timeSignaturePoint.numerator, timeSignaturePoint.denominator, 16);
                object = pmU.w2Z(Df.bsM(d4), n2);
                yis2.HaN((ngJ)object);
                continue;
            }
            if (!(point instanceof BoolPoint)) continue;
            timeSignaturePoint = (BoolPoint)point;
            yis2.w2Z(d4, timeSignaturePoint.value != false ? 1.0 : 0.0, 0.0, -1, (NBu)null);
        }
    }

    private void importAutomationForAtom(JMV jMV, Points points) {
        Eja eja;
        XB xB2 = this.getCurrentClip();
        Eja eja2 = eja = this.mTrack.isEmpty() ? jMV.mge() : (Eja)this.mTrack.peek();
        if (xB2 != null) {
            ArrayList<Double> arrayList = new ArrayList<Double>(points.points.size());
            ArrayList<Double> arrayList2 = new ArrayList<Double>(points.points.size());
            int n2 = 0;
            boolean bl2 = false;
            double d2 = 0.0;
            double d3 = 0.0;
            for (Point point : points.points) {
                if (point instanceof RealPoint) {
                    RealPoint realPoint = (RealPoint)point;
                    double d4 = this.convertRealValue(realPoint.value, points.unit, (jrv)jMV.aH_());
                    if (bl2 && point.time > d3 && d4 != d2) {
                        arrayList.add(point.time);
                        arrayList2.add(d2);
                    }
                    arrayList.add(point.time);
                    arrayList2.add(d4);
                    bl2 = realPoint.interpolation == Interpolation.HOLD;
                    d2 = d4;
                    d3 = point.time;
                }
                ++n2;
            }
            eja.BOK(jMV, dWA.w2Z, (vCl)xB2, aPm.BOK(arrayList), aPm.BOK(arrayList2), null, null);
        } else {
            eja.BOK(jMV, dWA.w2Z, false);
            NUH nUH = eja.BOK((SoS)jMV);
            Drv drv2 = nUH.eN1().Jpm();
            drv2.cY1();
            this.insertPoints(points, drv2);
        }
    }

    private XB getCurrentClip() {
        if (this.mInstrumentNoteClipEvent != null) {
            return this.mInstrumentNoteClipEvent;
        }
        return this.mAudioNoteClipEvent;
    }

    private String getExpressionName(ExpressionType expressionType) {
        switch (expressionType) {
            case GAIN: {
                return "amplitude";
            }
            case PAN: {
                return "panning";
            }
            case TRANSPOSE: {
                return "transpose";
            }
            case TIMBRE: {
                return "timbre";
            }
            case FORMANT: {
                return "formant";
            }
            case PRESSURE: {
                return "pressure";
            }
        }
        return null;
    }

    private TimeUnit getTimeUnit() {
        try {
            return (TimeUnit)this.mTimeUnit.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    private Eja getTrack() {
        try {
            return (Eja)this.mTrack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    private Pu convertColor(String string) {
        try {
            return Pu.w2Z(string);
        }
        catch (ewP ewP2) {
            ewP2.printStackTrace();
            return Pu.r2;
        }
    }
}

