/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.samplefile;

import com.bitwig.base.io.nCp;
import com.bitwig.samplefile.OCP;
import com.bitwig.samplefile.dPu;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class S3g {
    public static final Comparator w2Z = (object, object2) -> {
        double d2;
        double d3;
        if (object instanceof dPu) {
            dPu dPu2 = (dPu)object;
            v0 = dPu2.BOK();
        } else {
            v0 = d3 = ((Double)object).doubleValue();
        }
        if (object2 instanceof dPu) {
            dPu dPu3 = (dPu)object2;
            d2 = dPu3.BOK();
        } else {
            d2 = (Double)object2;
        }
        double d4 = d2;
        return Double.compare(d3, d4);
    };
    private final List HaN;
    private double rLM = 5.0E-5;

    public S3g(nCp nCp2) {
        int n2 = nCp2.zxv();
        if (n2 != 1) {
            throw new IOException("Invalid warp marker version: " + n2 + " (supported version is 1)");
        }
        int n3 = nCp2.zxv();
        if (n3 < 0) {
            throw new IOException("Warp marker count is negative (" + n3 + ")");
        }
        try {
            this.HaN = new ArrayList(n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Out of memory allocating warp markers list for " + n3 + " warp markers");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            double d2 = nCp2.slM();
            double d3 = nCp2.slM();
            this.HaN.add(new dPu(d2, d3));
        }
        this.w2Z(true);
    }

    public S3g(List list) {
        this.HaN = new ArrayList(list);
    }

    public S3g(double d2, double d3) {
        this.HaN = new ArrayList(2);
        this.HaN.add(new dPu(0.0, 0.0));
        this.HaN.add(new dPu(d2, d3));
    }

    public S3g(int n2) {
        this.HaN = new ArrayList(n2);
    }

    public boolean w2Z() {
        try {
            this.w2Z(true);
            return true;
        }
        catch (OCP oCP) {
            return false;
        }
    }

    public void w2Z(boolean bl2) {
        if (bl2 && this.HaN.size() < 2) {
            throw new OCP("At least 2 warp markers are needed for warping");
        }
        dPu dPu2 = (dPu)this.HaN.get(0);
        if (dPu2.BOK() != 0.0) {
            throw new OCP("First warp marker must have beat time of 0");
        }
        for (int i2 = 1; i2 < this.HaN.size(); ++i2) {
            dPu dPu3 = (dPu)this.HaN.get(i2);
            if (dPu3.BOK() <= dPu2.BOK()) {
                throw new OCP("Warp markers are not in ascending order for beat time");
            }
            if (dPu3.w2Z() <= dPu2.w2Z()) {
                throw new OCP("Warp markers are not in ascending order for sample time");
            }
            dPu2 = dPu3;
        }
    }

    public boolean w2Z(double d2, double d3) {
        assert (bSI.HaN(d2 >= 0.0));
        assert (bSI.HaN(d3 >= 0.0));
        if (d2 < 0.0 || d3 < 0.0) {
            return false;
        }
        int n2 = this.HaN.size();
        dPu dPu2 = new dPu(d2, d3);
        if (n2 > 0) {
            dPu dPu3;
            dPu dPu4 = (dPu)this.HaN.get(n2 - 1);
            if (d2 == dPu4.BOK()) {
                if (d3 == dPu4.w2Z()) {
                    return false;
                }
                assert (bSI.BOK("changing sample time of last warp marker from " + dPu4.w2Z() + " to " + d3));
                if (d3 < dPu4.w2Z()) {
                    return false;
                }
                this.HaN.remove(n2 - 1);
                this.HaN.add(dPu2);
                return true;
            }
            assert (bSI.HaN(d2 >= dPu4.BOK()));
            assert (bSI.HaN(d3 >= dPu4.w2Z()));
            if (d2 <= dPu4.BOK() || d3 <= dPu4.w2Z()) {
                return false;
            }
            if (n2 >= 2 && !dPu.w2Z(dPu3 = (dPu)this.HaN.get(n2 - 2), dPu4, dPu2, this.rLM)) {
                this.HaN.remove(n2 - 1);
            }
        }
        this.HaN.add(dPu2);
        return true;
    }

    public void BOK(double d2, double d3) {
        int n2 = Collections.binarySearch(this.HaN, d2, w2Z);
        if (n2 >= 0) {
            dPu dPu2 = (dPu)this.HaN.get(n2);
            assert (bSI.bsM(dPu2.BOK() == d2));
            this.HaN.remove(n2);
            this.HaN.add(n2, new dPu(d2, d3));
            this.w2Z(false);
            return;
        }
        int n3 = -(n2 + 1);
        this.HaN.add(n3, new dPu(d2, d3));
        this.w2Z(false);
    }

    public int BOK() {
        return this.HaN.size();
    }

    public dPu w2Z(int n2) {
        return (dPu)this.HaN.get(n2);
    }

    public dPu HaN() {
        assert (bSI.HaN(this.HaN.size() > 0));
        return (dPu)this.HaN.get(this.HaN.size() - 1);
    }

    public List rLM() {
        return Collections.unmodifiableList(this.HaN);
    }

    public double bsM() {
        return this.rLM;
    }

    public void w2Z(double d2) {
        assert (bSI.bsM(nBT.HaN(d2, 0.0, 1.0)));
        if (d2 >= 0.5) {
            double d3 = d2 * 2.0 - 1.0;
            double d4 = 0.00995;
            this.rLM = 5.0E-5 + (1.0 - d3) * 0.00995;
        } else if (d2 >= 0.0) {
            double d5 = d2 * 2.0;
            double d6 = 0.19;
            this.rLM = 0.01 + (1.0 - d5) * 0.19;
        }
    }
}

