/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.widget.tests;

import com.bitwig.base.testing.AnnotationBasedTest;
import com.bitwig.base.testing.OCP;
import com.bitwig.base.testing.QTJ;
import com.bitwig.graphics.bay;
import com.bitwig.graphics.l2R;
import com.bitwig.graphics.vE;
import com.bitwig.widget.tests.pdu;
import java.io.IOException;

@OCP(w2Z="Platform")
public class GUIToolkitTests
extends AnnotationBasedTest {
    @QTJ
    public void testShowTextWithSurrogatePairs() {
        String string = new String(new int[]{65536, 127829, 72, 69, 76, 76, 79}, 0, 7);
        this.check("is multi char encoding", string.length()).w2Z(9);
        this.showWindowWithText(string);
    }

    @QTJ
    public void testShowTextWithInvalidData() {
        String string = new String(new char[]{'\ud800', 'H', 'E', 'L', 'L', 'O'});
        this.showWindowWithText(string);
    }

    private void showWindowWithText(String string) {
        cyt cyt2 = (cyt)this.get(() -> {
            cyt cyt2 = cyt.UuI();
            cyt2.w2Z(cuh.w2Z);
            cyt2.w2Z(new crU(600L, 600L));
            cwE cwE2 = cwE.UN3(string);
            cwE2.UN3(0.5f);
            cwE2.JEB(0.5f);
            crQ crQ2 = crQ.w2Z(cwE2, true, true);
            cyt2.bsM(crQ2);
            cyt2.KyJ(string);
            return cyt2;
        });
        this.exec(() -> cyt2.r_(true));
        this.exec(() -> cyt2.bE_());
    }

    @QTJ
    public void testShowEmptyPopupWindow() {
        cve cve2 = (cve)this.get(() -> {
            cve cve2 = cve.mzu();
            cpQ cpQ2 = csj.YdN().JRm();
            cve2.w2Z(new cRA(cpQ2, 0L, 0L, false));
            return cve2;
        });
        this.exec(() -> cve2.r_(true));
        this.exec(() -> cve2.bE_());
    }

    @QTJ
    public void testCreateAndShowLotsOfWindowWidgets() {
        int n2 = 1000;
        for (int i2 = 0; i2 < 1000; ++i2) {
            int n3 = i2 + 1;
            cyt cyt2 = (cyt)this.get(() -> this.createWindow(n3));
            this.exec(() -> cyt2.r_(true));
            this.exec(() -> cyt2.bE_());
        }
    }

    private cyt createWindow(int n2) {
        assert (bTC.w2Z(this.isEventDispatchThread()));
        cyt cyt2 = cyt.UuI();
        cyt2.bsM(crQ.w2Z(cwE.bsM(String.valueOf(n2)), true, true));
        cyt2.w2Z(cuh.w2Z);
        cyt2.w2Z(new crU(600L, 600L));
        return cyt2;
    }

    @QTJ
    public void testCreateAndShowLotsOfPopupWindowWidgets() {
        int n2 = 1000;
        for (int i2 = 0; i2 < 1000; ++i2) {
            int n3 = i2 + 1;
            cve cve2 = (cve)this.get(() -> this.createPopupWindow(n3));
            this.exec(() -> cve2.r_(true));
            this.exec(() -> cve2.bE_());
        }
    }

    @QTJ
    public void testCanLoadAllFontSets() {
        kZI kZI2 = csj.YdN().FeE();
        pdu pdu2 = new pdu(this, kZI2);
        for (bay bay2 : dhP.w2Z()) {
            try {
                l2R l2R2 = csj.YdN().JRm().JEB().w2Z(bay2, pdu2);
                this.check("Font face loaded from font set", l2R2).OhK();
            }
            catch (IOException iOException) {
                this.fail("Loading font set " + bay2.w2Z() + " threw an exception", iOException);
            }
            for (int i2 = 0; i2 < bay2.BOK(); ++i2) {
                vE vE2 = bay2.w2Z(i2);
                qyU qyU2 = new qyU(kZI2, vE2.w2Z());
                try {
                    l2R l2R3 = csj.YdN().JRm().JEB().w2Z(qyU2.tUG());
                    this.check("Can load font source " + vE2.w2Z() + " for font set " + bay2.w2Z(), l2R3).OhK();
                    l2R3.bE_();
                    continue;
                }
                catch (IOException iOException) {
                    this.fail("Loading font source " + vE2.w2Z() + " for font set " + bay2.w2Z() + " threw an exception", iOException);
                }
            }
        }
    }

    @QTJ
    public void testFontSetsCanRenderStrings() {
        for (bay bay2 : dhP.w2Z()) {
            this.check(bay2.w2Z(), bay2.w2Z("hello")).w2Z(0);
            this.check(bay2.w2Z(), bay2.w2Z("\u6238\u7530\u99c5")).rLM(0);
            this.check(bay2.w2Z(), bay2.w2Z("\u6238\u7530\u99c5hello")).w2Z(-1);
        }
    }

    private cve createPopupWindow(int n2) {
        assert (bTC.w2Z(this.isEventDispatchThread()));
        cve cve2 = cve.mzu();
        cve2.bsM(crQ.w2Z(cwE.bsM(String.valueOf(n2)), true, true));
        cpQ cpQ2 = csj.YdN().JRm();
        cve2.w2Z(new cRA(cpQ2, 0L, 0L, false));
        cve2.w2Z(new crU(600L, 600L));
        return cve2;
    }
}

