/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.x11_windowing_system;

import com.bitwig.base.geom.CtF;
import com.bitwig.windowing_system.cze;
import com.bitwig.windowing_system.ssj;
import com.bitwig.x11_windowing_system.X11Display;
import com.bitwig.x11_windowing_system.X11TopLevelWindowHandle;

class X11TextInputSession
implements ssj {
    private final X11Display mDisplay;
    private final cze mTextInputTarget;
    private final X11TopLevelWindowHandle mWindowHandle;
    private boolean mHasScheduledUpdateToImmWindowPos;
    private boolean mIsCursorPositionValid;
    private int mCursorX;
    private int mCursorY;
    private int mNativeCursorX;
    private int mNativeCursorY;
    private final RQf mCompositionTextBuffer = new TBf(10);

    public X11TextInputSession(X11Display x11Display, cze cze2) {
        this.mDisplay = x11Display;
        this.mTextInputTarget = cze2;
        this.mWindowHandle = (X11TopLevelWindowHandle)cze2.w2Z();
    }

    @Override
    public cze getTextInputTarget() {
        return this.mTextInputTarget;
    }

    public X11TopLevelWindowHandle getWindowHandle() {
        return this.mWindowHandle;
    }

    @Override
    public void cursorPositionChanged() {
        assert (bTN.HaN(this.mDisplay.isEventDispatchThread()));
        this.invalidateTextInputCursorPos();
    }

    @Override
    public void areaOnScreenChanged() {
        assert (bTN.HaN(this.mDisplay.isEventDispatchThread()));
        this.invalidateTextInputCursorPos();
    }

    void started() {
        assert (bTN.HaN(this.mDisplay.isEventDispatchThread()));
        this.updateTextInputCursorPos(false);
        this.mNativeCursorX = this.mCursorX;
        this.mNativeCursorY = this.mCursorY;
    }

    void startedOnNativeThread() {
        assert (bTN.HaN(this.mDisplay.w2Z()));
        this.sendTextInputCusorPos();
    }

    private void invalidateTextInputCursorPos() {
        assert (bTN.HaN(this.mDisplay.isEventDispatchThread()));
        if (!this.mHasScheduledUpdateToImmWindowPos) {
            this.mHasScheduledUpdateToImmWindowPos = true;
            this.mDisplay.asyncExec(() -> {
                this.mHasScheduledUpdateToImmWindowPos = false;
                if (this.isActive()) {
                    this.updateTextInputCursorPos(true);
                }
            });
        }
    }

    private void updateTextInputCursorPos(boolean bl2) {
        assert (bTN.HaN(this.mDisplay.isEventDispatchThread()));
        assert (bTN.HaN(this.isActive()));
        int n2 = this.mTextInputTarget.HaN();
        CtF ctF2 = this.mTextInputTarget.w2Z(n2);
        int n3 = (int)ctF2.rLM() - this.mWindowHandle.JEB();
        int n4 = (int)(ctF2.bsM() + ctF2.UN3() - (long)this.mWindowHandle.UN3() + 5L);
        if (!this.mIsCursorPositionValid || n3 != this.mCursorX || n4 != this.mCursorY) {
            this.mCursorX = n3;
            this.mCursorY = n4;
            this.mIsCursorPositionValid = true;
            if (bl2) {
                this.mDisplay.BOK(() -> {
                    assert (bTN.HaN(this.mDisplay.w2Z()));
                    if (!this.isActiveOnNativeThread()) {
                        return;
                    }
                    this.mNativeCursorX = n3;
                    this.mNativeCursorY = n4;
                    this.sendTextInputCusorPos();
                });
            }
        }
    }

    private void sendTextInputCusorPos() {
        assert (bTN.HaN(this.mDisplay.w2Z()));
        assert (bTN.HaN(this.isActiveOnNativeThread()));
        if (bTN.bsM.BOK()) {
            bTN.bsM.w2Z("setTextInputScreenCursorPos(" + this.mNativeCursorX + ", " + this.mNativeCursorY + ")");
        }
        this.mDisplay.w2Z(this.mNativeCursorX, this.mNativeCursorY);
    }

    @Override
    public void cancelComposition() {
        assert (bTN.HaN(this.mDisplay.isEventDispatchThread()));
    }

    private void insertText(String string) {
        assert (bTN.HaN(this.mDisplay.w2Z()));
        if (bTN.bsM.BOK()) {
            bTN.bsM.w2Z("insertText(" + X11TextInputSession.stringDebugInfo(string) + ")");
        }
        if (X11TextInputSession.hasNullChar(string)) {
            bTN.bsM.bsM("Text to insert contains null character: " + X11TextInputSession.stringDebugInfo(string));
            return;
        }
        String string2 = X11TextInputSession.simplifyInternationalChars(string);
        this.mDisplay.asyncExec(() -> {
            if (this.isActive()) {
                this.mTextInputTarget.w2Z(string2);
            }
        });
    }

    private void startComposing() {
        assert (bTN.HaN(this.mDisplay.w2Z()));
        bTN.bsM.w2Z("startComposing()");
        assert (bTN.HaN(this.mCompositionTextBuffer.w2Z() == 0));
        this.mCompositionTextBuffer.BOK();
        this.sendTextInputCusorPos();
    }

    private void setCompositionText(String string, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        assert (bTN.HaN(this.mDisplay.w2Z()));
        if (bTN.bsM.BOK()) {
            bTN.bsM.w2Z("setCompositionText(" + X11TextInputSession.stringDebugInfo(string) + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ", " + n6 + ")");
        }
        if (n3 > 0) {
            n8 = nBT.w2Z(n2, 0, this.mCompositionTextBuffer.w2Z() - 1);
            n7 = nBT.w2Z(n3, 0, this.mCompositionTextBuffer.w2Z() - n8);
            assert (bTN.HaN(n8 == n2));
            assert (bTN.HaN(n7 == n3));
            this.mCompositionTextBuffer.w2Z(n8, n8 + n7);
        }
        if (string != null) {
            n8 = nBT.w2Z(n2, 0, this.mCompositionTextBuffer.w2Z());
            assert (bTN.HaN(n8 == n2));
            this.mCompositionTextBuffer.w2Z(n8, string);
        }
        String string2 = X11TextInputSession.simplifyInternationalChars(this.mCompositionTextBuffer.toString());
        n7 = (int)string2.codePoints().count();
        int n9 = nBT.w2Z(n4, 0, n7);
        int n10 = nBT.w2Z(n5, 0, n7);
        int n11 = nBT.w2Z(n6, 0, n7 - n10);
        this.mDisplay.asyncExec(() -> {
            if (this.isActive()) {
                if (!string2.isEmpty()) {
                    this.mTextInputTarget.w2Z(string2, n9, n10, n11);
                } else if (this.mTextInputTarget.BOK()) {
                    this.mTextInputTarget.rLM();
                }
            }
        });
    }

    private void endComposing() {
        assert (bTN.HaN(this.mDisplay.w2Z()));
        bTN.bsM.w2Z("endComposing()");
        this.mCompositionTextBuffer.BOK();
        this.mDisplay.asyncExec(() -> {
            if (this.isActive()) {
                this.mTextInputTarget.rLM();
            }
        });
    }

    private boolean isActive() {
        assert (bTN.HaN(this.mDisplay.isEventDispatchThread()));
        return this.mDisplay.slM() == this;
    }

    private boolean isActiveOnNativeThread() {
        assert (bTN.HaN(this.mDisplay.w2Z()));
        return this.mDisplay.OhK() == this;
    }

    private static boolean hasNullChar(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '\u0000') continue;
            return true;
        }
        return false;
    }

    private static String stringDebugInfo(String string) {
        int n2;
        if (string == null) {
            return "null";
        }
        int[] nArray = string.codePoints().toArray();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        stringBuilder.append(string);
        stringBuilder.append("\" length = ");
        stringBuilder.append(string.length());
        stringBuilder.append(", chars = [");
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            char c2 = string.charAt(n2);
            stringBuilder.append(c2 & 0xFFFF);
        }
        stringBuilder.append("], codePoints = [");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(nArray[n2]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String simplifyInternationalChars(String string) {
        TBf tBf = new TBf((int)string.codePoints().count());
        tBf.w2Z(string);
        tBf.BOK(8205);
        return tBf.toString();
    }
}

