/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.opensoundcontrol.OscAddressSpace;
import com.bitwig.extension.api.opensoundcontrol.OscConnection;
import com.bitwig.extension.api.opensoundcontrol.OscMessage;
import com.bitwig.extension.api.opensoundcontrol.OscMethod;
import com.bitwig.extension.api.opensoundcontrol.OscModule;
import com.bitwig.extension.api.opensoundcontrol.OscServer;
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ChainSelector;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorDevice;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.DeviceLayer;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.MasterTrack;
import com.bitwig.extension.controller.api.Preferences;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Transport;
import java.io.IOException;

public class jbx
extends ControllerExtension {
    private Transport w2Z;
    private MasterTrack BOK;
    private CursorTrack HaN;
    private CursorDevice rLM;
    private ChainSelector bsM;
    private DeviceLayer KyJ;
    private SettableIntegerValue UN3;
    private IntegerValue JEB;
    private OscServer zxv;

    public jbx(JvI jvI, ControllerHost controllerHost) {
        super(jvI, controllerHost);
    }

    @Override
    public void init() {
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        Preferences preferences = controllerHost.getPreferences();
        SettableRangedValue settableRangedValue = preferences.getNumberSetting("port", "Server", 1024.0, 32000.0, 1.0, "", 9001.0);
        settableRangedValue.addRawValueObserver(this::w2Z);
        this.w2Z = controllerHost.createTransport();
        this.BOK = controllerHost.createMasterTrack(1);
        this.HaN = controllerHost.createCursorTrack("osc-cursor-track", "OSC cursor track", 1, 1, true);
        this.rLM = this.HaN.createCursorDevice();
        this.bsM = this.rLM.createChainSelector();
        this.KyJ = this.bsM.activeChain();
        this.UN3 = this.bsM.activeChainIndex();
        this.JEB = this.bsM.chainCount();
        this.KyJ.name().markInterested();
        this.JEB.markInterested();
        this.UN3.markInterested();
        this.w2Z();
    }

    private void w2Z(double d2) {
        int n2 = (int)d2;
        try {
            this.zxv.start(n2);
        }
        catch (IOException iOException) {
            ((ControllerHost)this.getHost()).showPopupNotification("Could not set the OSC port to " + n2 + ": " + iOException.getMessage());
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public void flush() {
    }

    private void w2Z() {
        OscModule oscModule = ((ControllerHost)this.getHost()).getOscModule();
        OscAddressSpace oscAddressSpace = oscModule.createAddressSpace();
        oscAddressSpace.setName("bitwig");
        oscAddressSpace.registerObjectMethods("/bitwig/transport", this.w2Z);
        oscAddressSpace.registerObjectMethods("/bitwig/cursorDevice", this.rLM);
        oscAddressSpace.registerObjectMethods("/bitwig/cursorTrack", this.HaN);
        oscAddressSpace.registerObjectMethods("/bitwig/masterTrack", this.BOK);
        oscAddressSpace.registerObjectMethods("/bitwig/", this);
        oscAddressSpace.registerDefaultMethod(this::w2Z);
        oscAddressSpace.setShouldLogMessages(true);
        this.zxv = oscModule.createUdpServer(oscAddressSpace);
    }

    private void w2Z(OscConnection oscConnection, OscMessage oscMessage) {
        ((ControllerHost)this.getHost()).println("OSC method not found for " + oscMessage.getAddressPattern() + "(" + oscMessage.getTypeTag() + ")");
    }

    @OscMethod(address="/test/int")
    public void handleTestInt(int n2) {
        ((ControllerHost)this.getHost()).println("int value: " + n2);
    }

    @OscMethod(address="/test/long")
    public void handleTestLong(long l2) {
        ((ControllerHost)this.getHost()).println("long value: " + l2);
    }

    @OscMethod(address="/test/float")
    public void handleTestFloat(float f2) {
        ((ControllerHost)this.getHost()).println("float value: " + f2);
    }

    @OscMethod(address="/test/double")
    public void handleTestDouble(double d2) {
        ((ControllerHost)this.getHost()).println("double value: " + d2);
    }

    @OscMethod(address="/test/bool")
    public void handleTestBool(boolean bl2) {
        ((ControllerHost)this.getHost()).println("boolean value: " + bl2);
    }

    @OscMethod(address="/test/string")
    public void handleTestString(String string) {
        ((ControllerHost)this.getHost()).println("string value: " + string);
    }

    @OscMethod(address="/test/ping")
    public void handleTestPing(OscConnection oscConnection) {
        oscConnection.sendMessage("/test/pong", new Object[0]);
    }

    @OscMethod(address="/test/chain-selector/select-next")
    public void handleChainSelectorNext() {
        this.bsM.selectNext();
    }

    @OscMethod(address="/test/chain-selector/select-prev")
    public void handleChainSelectorPrev() {
        this.bsM.selectPrevious();
    }

    @OscMethod(address="/test/chain-selector/select-first")
    public void handleChainSelectorFirst() {
        this.bsM.selectFirst();
    }

    @OscMethod(address="/test/chain-selector/select-last")
    public void handleChainSelectorLast() {
        this.bsM.selectLast();
    }

    @OscMethod(address="/test/chain-selector/cycle-next")
    public void handleChainSelectorCycleNext() {
        this.bsM.cycleNext();
    }

    @OscMethod(address="/test/chain-selector/cycle-prev")
    public void handleChainSelectorCyclePrev() {
        this.bsM.cyclePrevious();
    }

    @OscMethod(address="/test/chain-selector/test-active-chain")
    public void handleChainSelectorTestActiveChain() {
        ((ControllerHost)this.getHost()).println("ChainSelectorIndex: " + this.UN3.get());
        ((ControllerHost)this.getHost()).println("ChainSelectorChainCount: " + this.JEB.get());
        ((ControllerHost)this.getHost()).println("ChainSelectorActiveChainName: " + this.KyJ.name().get());
    }
}

