<?xml version="1.0" encoding="UTF-8"?>
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
	<modelVersion>4.0.0</modelVersion>
	<groupId>${info.groupId}</groupId>
	<artifactId>${info.artifactId}</artifactId>
	<packaging>jar</packaging>
	<name>${info.name}</name>
	<version>${info.version}</version>
	
	<repositories>
       <repository>
         <id>bitwig</id>
         <name>Bitwig Maven Repository</name>
         <url>https://maven.bitwig.com</url>
       </repository>
   </repositories>

	<dependencies>
		<dependency>
			<groupId>com.bitwig</groupId>
			<artifactId>extension-api</artifactId>
			<version>${info.requiredAPIVersion}</version>
		</dependency>
	</dependencies>

	<build>
		<plugins>
		   <plugin>
               <groupId>org.apache.maven.plugins</groupId>
               <artifactId>maven-compiler-plugin</artifactId>
               <version>3.8.0</version>
               <configuration>
                  <optimize>true</optimize>
                  <fork>true</fork>
                  <source>1.8</source>
                  <target>1.8</target>
                  <encoding>UTF-8</encoding>
                  <maxmem>1024m</maxmem>
               </configuration>
         </plugin>
		
			<plugin>
				<groupId>com.coderplus.maven.plugins</groupId>
				<artifactId>copy-rename-maven-plugin</artifactId>
				<version>1.0</version>
				<executions>
					<execution>
						<id>rename-file</id>
						<phase>install</phase>
						<goals>
							<goal>copy</goal>
						</goals>
						<configuration>
							<sourceFile>${r"${project.build.directory}/${project.build.finalName}"}.jar</sourceFile>
							<destinationFile>${r"${project.build.directory}"}/${info.className}.bwextension</destinationFile>
						</configuration>
					</execution>
				</executions>
			</plugin>
		</plugins>
	</build>

</project>

