"""
Copyright 2008-2018 VMware, Inc.  All rights reserved. -- VMware Confidential
"""

import os

from vmis.util.log import getLog

# One of either 'gtk', 'console', or 'null'
TYPE = None
# The single instance of the UI.
instance = None

log = getLog('vmis.ui')


def Initialize(ui):
   """
   Initialize the UI system

   @param ui: name of the ui to use (gtk or console)
   """
   global TYPE

   if ui not in ('deferred-gtk', 'deferred-gtk-with-required', 'console'):
      raise ValueError('ui must be either deferred-gtk or console')

   # This imports all public symbols from the specific UI into the
   # current module's global scope.
   term = os.environ.get('TERM')
   TYPE = ui

   # We need to make sure that we support curses and our terminal
   # can use hpa.  Otherwise we should default to the dumb terminal.
   if term and term not in ('dumb', 'unknown'):
      try:
         import curses
         curses.setupterm()
         hpa = curses.tigetstr('hpa')
         if hpa is None:
            log.info('Terminal does not support hpa.  Falling back '
                     'on the null terminal type.')
            term = 'dumb'
      except Exception as e:
         log.info('Could not set up curses...  Falling back on null term type.')
         term = 'dumb'

   if not term or term in ('dumb', 'unknown'):
      exec('from vmis.ui.null import *', globals())
   else:
      exec('from vmis.ui.console import *', globals())


class MessageTypes:
   """ Types of messages to show """
   INFO, WARNING, ERROR = list(range(3))
