"""
Copyright 2008,2019 VMware, Inc.  All rights reserved. -- VMware Confidential
"""
__all__ = ('path',)

import py_compile
import textwrap

from vmis.core.errors import AbortError
from vmis.util.log import getLog

log = getLog('vmis.util')

def wrap(func, ignoreErrors, *args, **kwargs):
   """ Need a more generic wrapper for handling various exceptions.
   This is just a lame one that catches all basic exceptions except
   MemoryError and logs them """
   if ignoreErrors:
      try:
         func(*args, **kwargs)
      except (MemoryError, KeyboardInterrupt, SystemExit, AbortError):
         raise
      except:
         log.exception('Error occured, ignoring')
   else:
      func(*args, **kwargs)

def Format(text):
   """ Format text for output to console """
   return textwrap.fill(text)

def CompilePython(filePath):
   """
   Compile the given Python file

   @returns: path to compiled file
   @raises py_compile.PyCompileError
   """
   return py_compile.compile(str(filePath))
